#include <math.h>
#include <stdlib.h>
#include "scnHelix.h"
#include "../resource.h"


#define MAX_POLYS 22
#define MAX_FADE 1.0f
#define FADE_TIME 40000
#define MAX_ROTATION_DEGREES_X (360.0f*6.0f)
#define MAX_ROTATION_DEGREES_Y (360.0f*4.0f)
#define MAX_ROTATION_DEGREES_Z (360.0f*2.0f)
#define QUADS_X (1.0f)
#define QUADS_Y (1.0f)

static bool end = false;

typedef struct {
  int visiblePolys;
  GLfloat x, y, z;
  GLfloat ax[MAX_POLYS], ay[MAX_POLYS], az[MAX_POLYS];
  GLfloat iax[MAX_POLYS], iay[MAX_POLYS], iaz[MAX_POLYS];
  GLfloat rsx, rsy, rsz;
  GLfloat alpha[MAX_POLYS];
  __int32 sttime[MAX_POLYS];
} THelix;


static THelix *helix;


TScnHelix::TScnHelix() 
{
};


int TScnHelix::run(__int32 time) 
{

  sharedTextures->bindTexture(UNKNOWN_LOGO_HELIX);
	TGLState::enable(GL_TEXTURE_2D);

	TGLState::enable(GL_BLEND);
  TGLState::disable(GL_DEPTH_TEST);					// Enables Depth Testing
  TGLState::disable(GL_LIGHTING);


  helix->visiblePolys=MAX_POLYS;
  if(time<FADE_TIME) {
    helix->visiblePolys=MAX_POLYS*time/FADE_TIME;
  } else helix->visiblePolys=MAX_POLYS;

  for(int i=0; i<MAX_POLYS; i++) {
    if(!end) {
      helix->ax[i]=time*helix->rsx+helix->iax[i];
      helix->ay[i]=time*helix->rsy+helix->iay[i];
      helix->az[i]=time*helix->rsz+helix->iaz[i];
      if(helix->ax[i]>MAX_ROTATION_DEGREES_X) helix->ax[i]=MAX_ROTATION_DEGREES_X;
      if(helix->ay[i]>MAX_ROTATION_DEGREES_Y) helix->ay[i]=MAX_ROTATION_DEGREES_Y;
      if(helix->az[i]>MAX_ROTATION_DEGREES_Z) helix->az[i]=MAX_ROTATION_DEGREES_Z;
      if (helix->ax[i]==MAX_ROTATION_DEGREES_X &&
          helix->ay[i]==MAX_ROTATION_DEGREES_Y && 
          helix->az[i]==MAX_ROTATION_DEGREES_Z)
      {
        end = true;
      }
    }

    int rt=time-helix->sttime[i];

    helix->alpha[i]=0.0f;
    if(rt>=0) {
      helix->alpha[i]=MAX_FADE*rt/(FADE_TIME+helix->sttime[i]);
    }
    if(helix->alpha[i]>MAX_FADE) helix->alpha[i]=MAX_FADE;
  }


  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
 
  glLoadIdentity();

  glTranslatef(helix->x, helix->y, helix->z);
  
  if(time>26500) {
    helix->visiblePolys=1;
    helix->alpha[0]=1.0f-((time-26500)/1000.0f);
    if(helix->alpha[0]<0) helix->alpha[0]=0;
  }

  for (i = 0; i < helix->visiblePolys; i ++)
  {
    glPushMatrix();
    glColor4f(1.0f,1.0f,1.0f,helix->alpha[i]); // alpha
    glRotatef(helix->ax[i], 1,0,0);
    glRotatef(helix->ay[i], 0,1,0);
    glRotatef(helix->az[i], 0,0,1);
    glBegin(GL_QUADS);
  		glNormal3f( 0.0f, 0.0f,  1.0f);
      glTexCoord2f(1.0f, 1.0f); 
      glVertex3f(QUADS_X, QUADS_Y, 0);			// Top Right Of The Quad (Front)
  		glTexCoord2f(0.0f, 1.0f); 
      glVertex3f(-QUADS_X, QUADS_Y, 0);			// Top Right Of The Quad (Front)
  		glTexCoord2f(0.0f, 0.0f); 
      glVertex3f(-QUADS_X, -QUADS_Y, 0);			// Top Right Of The Quad (Front)
  		glTexCoord2f(1.0f, 0.0f); 
      glVertex3f(QUADS_X, -QUADS_Y, 0);			// Top Right Of The Quad (Front)
    glEnd();
    glPopMatrix();
  }

  return 1;
}


int TScnHelix::setup(int reason)
{
  strcpy(sceneName, "Helix");

  if(reason==REASON_INIT) {
    sharedTextures->insertTexture(UNKNOWN_LOGO_HELIX, USE_ALPHA);
  
    helix = new THelix;
    helix->x = 0;
    helix->y = -0;
    helix->z = -2;
    helix->visiblePolys=MAX_POLYS;

    for(int i=0; i<MAX_POLYS; i++) {
      helix->ax[i] = 0;
      helix->ay[i] = 0;
      helix->az[i] = 0;
      helix->iax[i] = GLfloat(i * 180.0f / MAX_POLYS);
      helix->iay[i] = 0;
      helix->iaz[i] = 0;

      helix->sttime[i]=FADE_TIME*i/MAX_POLYS;
    }
    helix->rsx = 0.15f;
    helix->rsy = 0.10f;
    helix->rsz = 0.05f;
  }
  return 1;
}

void TScnHelix::free() 
{
}
