/********************************************************************************
Proyecto Jaguar
  Interface de Sonido.
    
  1 - 28/10/00
  2 - 30/10/00
********************************************************************************/
#ifndef __SOUNDSYSTEM_H_
#define __SOUNDSYSTEM_H_

#define __SOUNDSYSTEM_USE_BASS_
//#define __SOUNDSYSTEM_USE_MINIFMOD_

enum { TMODTYPE_MODULE=1, TMODTYPE_STREAM };

#ifdef __SOUNDSYSTEM_USE_BASS_
  #include "bass.h"
#endif

#ifdef  __SOUNDSYSTEM_USE_MINIFMOD_
  #include "minifmod.h"
#endif

struct TSoundInfo {
  void *dumb;
};


class TSoundSystem {
public:
  TSoundSystem();
  ~TSoundSystem();
  void setup();            // Setup
  void init();            // Setup
  int  load(char *fileName, int type); // Carga la musica (pero no la reproduce)
  void play();             // Reproduce la musica
  void stop();             // Para la musica
  void getInfo(TSoundInfo *info);          // Coge informacion del modulo (se hara una estructura)
  void close();
private:
  int freq;
  int modType;
#ifdef __SOUNDSYSTEM_USE_BASS_
  HMUSIC modfile;
  HSTREAM stream;
#endif
#ifdef  __SOUNDSYSTEM_USE_MINIFMOD_
  FMUSIC_MODULE *mod;
#endif


};







#endif