#ifndef __IMAGELOAD_H
#define __IMAGELOAD_H

typedef struct sTimage {
	int width, height;
	int bpp;
	int pitch;
	__int32 *data;
} Timage;

#define AllocBuffer(w,h,bpp) AllocEmptyImage(w,h,bpp);
Timage *AllocEmptyImage(int width, int height, int bpp);
Timage *UseBuffer(int width, int height, int bpp, __int32 *buffer);
Timage *LoadPCX(char *fileName);
Timage *LoadTGA(char *fileName);
Timage *LoadResourceTGA(int fileName);
Timage *LoadMemoryTGA(unsigned char *in);
void freeImage(Timage *pp);


#endif
