
#include "imageLoad.h"

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>


typedef struct {
   unsigned char numIden;
   unsigned char colorMapType;
   unsigned char imageType;
   unsigned char colorMapSpec[5]; // not used, just here to take up space
   unsigned char origX[2];
   unsigned char origY[2];
   unsigned char width[2];
   unsigned char height[2];
   unsigned char bpp;
   unsigned char imageDes; // don't use, space eater
} sTgaHeader;


void imgErr(char *str) {
	  MessageBox(NULL,str,"DUMP imageLoad()",0);
}

Timage *AllocEmptyImage(int width, int height, int bpp) {
	Timage *img;

	img=(Timage *)malloc(sizeof(Timage));
	img->width=width;
	img->height=height;
	img->bpp=bpp;
	img->pitch=width*((bpp+1)/8);
	img->data=(__int32 *)malloc(width*img->pitch);
	memset(img->data,0,width*img->pitch);

	return img;
}

Timage *UseBuffer(int width, int height, int bpp, __int32 *buffer) {
	Timage *img;

	img=(Timage *)malloc(sizeof(Timage));
	img->width=width;
	img->height=height;
	img->bpp=bpp;
	img->pitch=width*((bpp+1)/8);
	img->data=buffer;

	return img;
}

Timage *LoadPCX(char *filename) {
	void *freee;
  Timage img, *pimg;
	char str[5000];	
	FILE *f;
	unsigned short xmin, ymin, xmax, ymax;
	unsigned char nplanes;
	unsigned char b, p;
	int desp;
	int H, W;

  if (!filename) {
    imgErr("Opening a PCX with NULL filename");
    return NULL;
  }

	if ((f = fopen(filename, "rb")) == NULL) {    
		sprintf(str,"Can't open file -> %s", filename);
		imgErr(str);
		return NULL;
	}
	if ((freee = malloc(4)) == NULL) {    
		sprintf(str,"Can't malloc 4 bytes (%s)", filename);
		imgErr(str);
		fclose(f);    
		return NULL;
	}
	if (fread(freee, 4, 1, f) < 1)  {    
		sprintf(str,"Can't load header (%s)", filename);
		imgErr(str);
		free(freee);
		fclose(f);
		return NULL;
	}
	fseek(f, 4, SEEK_SET);
	fread(&xmin, 2, 1, f);
	fread(&ymin, 2, 1, f);
	fread(&xmax, 2, 1, f);
	fread(&ymax, 2, 1, f);
	fseek(f, 65, SEEK_SET);
	fread(&nplanes, 1, 1, f);


  if (nplanes < 3) {
		sprintf(str,"Only 24bpp PCX supported (%s)", filename);
		imgErr(str);
		free(freee);
    fclose(f);
    return NULL;
  }
  H = ymax + 1 - ymin;
  W = xmax + 1 - xmin;

  
	free(freee);

  img.width=W;
	img.height=H;
	img.bpp=32;
	img.pitch=W*4;
	img.data=(__int32 *)malloc(W*H*4);
	if(!img.data) {
		sprintf(str,"Cant's malloc (%s)", filename);
		imgErr(str);
		fclose(f);
		return NULL;
	}

  fseek(f,128,SEEK_SET);
  
	
	int dpb=0;
	int rept=0, val=0;
	for(int c=0;c<H;c++) {
		int shift = 16;
		while(shift>=0) {
			desp=(c*W);
			
			for (int d = 0; d < W;d++) {
				if(rept) {
					img.data[desp] |= (val << shift);
					desp++;
					rept--;
				} else {
					fread(&b,1,1,f);
					if (b<=0xC0) {
						img.data[desp] |= (b << shift);
						desp++;
					} else {
			      fread(&p, 1, 1, f);
						rept = b & 0x3F;
						val = p;
						d--;
					}
				}
			}
			shift-=8;
		}

	}
 

	fclose(f);  

	pimg = (Timage *)malloc(sizeof(*pimg));
  *pimg = img;
  return pimg;
}


Timage *LoadTGA(char *filename) {
	FILE *in;
	Timage *img;
	char DummyA[12];
	int DummyC;
	int DummyC2;    
	char str[5000];	

  if (!filename) {
    imgErr("Opening a TGA with NULL filename");
    return NULL;
  }

  if (!(in=fopen(filename,"rb"))) {
		sprintf(str,"Can't open file -> %s", filename);
		imgErr(str);
		return NULL;
  }

  if (!fread(DummyA,12,1,in)) {
		sprintf(str,"Can't load header (%s)", filename);
		imgErr(str);
		fclose(in);
		return NULL;
  }

  DummyC2 = fgetc(in);
  DummyC = fgetc(in);
  
	int Width = (DummyC<<8) + DummyC2;
  
  DummyC2 = fgetc(in);
  DummyC = fgetc(in);
  
	int Height = (DummyC<<8) + DummyC2;

  DummyC = fgetc(in);
  int Bpp = DummyC;

  DummyC = fgetc(in);
  
  img = (Timage *)malloc(sizeof(Timage));
  if (img==NULL) {
		sprintf(str,"Cant's malloc (%s)", filename);
		imgErr(str);
		fclose(in);
		return NULL;
  }


  img->width  = Width;
  img->height = Height;
  img->bpp = Bpp;
  img->pitch = Width*((Bpp+1)/8);
  
	int size = img->pitch*Height;
  img->data = (__int32 *)malloc (size);
  if (img->data==NULL) {
		sprintf(str,"Can't malloc (%s)", filename);
		imgErr(str);
		free(img);
		fclose(in);
		return NULL;
  }  

  if (!fread (img->data,1,size,in)) {
		sprintf(str,"Can't load file (%s)", filename);
		imgErr(str);
		free(img);
		fclose(in);
		return NULL;
  }

  if (fclose(in)) {
		sprintf(str,"Can't close file (%s)", filename);
		imgErr(str);
		free(img);
		fclose(in);
		return NULL;
  }

	if(img->bpp=32) {
		__int32 *flip;
		flip = (__int32 *)malloc(img->pitch);
		for(int a=0;a<img->height/2;a++) {
			for (int b=0;b<img->width;b++) {
				flip[b]=img->data[b+a*img->width];
				img->data[b+a*img->width]=img->data[b+((img->height-1)-a)*img->width];
				img->data[b+((img->height-1)-a)*img->width]=flip[b];
			}
		}
		free(flip);
	}


  return img;
}

Timage *LoadResourceTGA(int filename) {
	unsigned char *in;
  unsigned char *where;
	Timage *img;

	HRSRC		rec;
	HGLOBAL		handle;

	rec = FindResource(NULL, (char *)filename, RT_RCDATA);
	handle = LoadResource(NULL, rec);
		
	in = (unsigned char *)LockResource(handle);


  if(!in) return NULL;
  where=in;

 
  sTgaHeader *header = (sTgaHeader *) where;
  where+=(sizeof(sTgaHeader)+header->numIden);

  if(header->colorMapType != 0)
      return NULL;

  if(header->imageType != 2 && header->imageType != 3)
     return NULL;

  img = (Timage *)malloc(sizeof(Timage));
  if (!img) return NULL;
  
  img->width = header->width[0] + header->width[1] * 256; 
  img->height = header->height[0] + header->height[1] * 256; 
  img->bpp = header->bpp; 
  img->pitch = img->width*((img->bpp+1)/8);
  
	int size = img->pitch*img->height;
  
  if (img->bpp != 32 && img->bpp != 24 && img->bpp != 8) {
    free(img);
    return NULL;
  }

  img->data = (__int32 *)malloc (size);
  if(!img->data) {
    free(img);
    return NULL;
  }


  size = img->width * img->height; 

  if(img->bpp==32) {
    unsigned char *rgba = new unsigned char [size*4];
    unsigned char temp;
    int i;

    if(!rgba) {
      free(img->data);
      free(img);
      return NULL;
    }

    if(!memcpy(rgba,where,size*4)) {
      delete [] rgba;
      free(img->data);
      free(img);
      return NULL;
    }

    for(i=0;i<size*4;i+=4) {
      temp = rgba[i];
      rgba[i] = rgba[i + 2];
      rgba[i + 2] = temp;
    }

    for(i=0;i<size*4;i+=4) {
      img->data[i/4]=(rgba[i+3]<<24)|(rgba[i+2]<<16)|(rgba[i+1]<<8)|(rgba[i]);
    }
    delete [] rgba;

  } else if(img->bpp==24) {
    unsigned char *rgb = new unsigned char[size * 3];
    unsigned char temp;
    int i;

    if(!rgb) {
      free(img->data);
      free(img);
      return NULL;
    }

    if (!memcpy(rgb, where, size * 3)) {
      delete [] rgb;
      free(img->data);
      free(img);
      return NULL;
    }

    for (i = 0; i < size * 3; i += 3) {
      temp = rgb[i];
      rgb[i] = rgb[i + 2];
      rgb[i + 2] = temp;
    }
    
    for(i=0;i<size;i+=3) {
      img->data[i/3]=(rgb[i+2]<<16)|(rgb[i+1]<<8)|(rgb[i]);
    }
    delete [] rgb;
  }

  return img;
}

Timage *LoadMemoryTGA(unsigned char *in) {
  unsigned char *where;
	Timage *img;

  if(!in) return NULL;
  where=in;

 
  sTgaHeader *header = (sTgaHeader *) where;
  where+=(sizeof(sTgaHeader)+header->numIden);

  if(header->colorMapType != 0)
      return NULL;

  if(header->imageType != 2 && header->imageType != 3)
     return NULL;

  img = (Timage *)malloc(sizeof(Timage));
  if (!img) return NULL;
  
  img->width = header->width[0] + header->width[1] * 256; 
  img->height = header->height[0] + header->height[1] * 256; 
  img->bpp = header->bpp; 
  img->pitch = img->width*((img->bpp+1)/8);
  
	int size = img->pitch*img->height;
  
  if (img->bpp != 32 && img->bpp != 24 && img->bpp != 8) {
    free(img);
    return NULL;
  }

  img->data = (__int32 *)malloc (size);
  if(!img->data) {
    free(img);
    return NULL;
  }


  size = img->width * img->height; 

  if(img->bpp==32) {
    unsigned char *rgba = new unsigned char [size*4];
    unsigned char temp;
    int i;

    if(!rgba) {
      free(img->data);
      free(img);
      return NULL;
    }

    if(!memcpy(rgba,where,size*4)) {
      delete [] rgba;
      free(img->data);
      free(img);
      return NULL;
    }

    for(i=0;i<size*4;i+=4) {
      temp = rgba[i];
      rgba[i] = rgba[i + 2];
      rgba[i + 2] = temp;
    }

    for(i=0;i<size*4;i+=4) {
      img->data[i/4]=(rgba[i+3]<<24)|(rgba[i+2]<<16)|(rgba[i+1]<<8)|(rgba[i]);
    }
    delete [] rgba;

  } else if(img->bpp==24) {
    unsigned char *rgb = new unsigned char[size * 3];
    unsigned char temp;
    int i;

    if(!rgb) {
      free(img->data);
      free(img);
      return NULL;
    }

    if (!memcpy(rgb, where, size * 3)) {
      delete [] rgb;
      free(img->data);
      free(img);
      return NULL;
    }

    for (i = 0; i < size * 3; i += 3) {
      temp = rgb[i];
      rgb[i] = rgb[i + 2];
      rgb[i + 2] = temp;
    }
    
    for(i=0;i<size;i+=3) {
      img->data[i/3]=(rgb[i+2]<<16)|(rgb[i+1]<<8)|(rgb[i]);
    }
    delete [] rgb;
  }

  return img;
}



void freeImage(Timage *pp) {
  if(pp) {
    if(pp->data)
  		free(pp->data);
  	free(pp);
  }
}