#include "debug.h"
#include "statemachine.h"
#include "../resource.h"

TDemoDebug::TDemoDebug() {
  isSetup=0;
  font=NULL;
  strings=NULL;
  showDebug=false;
  infoTime=0;
  base=-1;
}

GLint TDemoDebug::setup() {
  font=LoadResourceTGA(FONT_TGA);
  for(int i=0;i<font->width*font->height;i++){
     __int32 fd=font->data[i];
    font->data[i]=(fd & 0xFF)<<24|0xFFFFFF;
  }
 
  showDebug=false;
  base=0;
  isSetup=1;

  return 1;
}


#ifndef GL_TEXTURE_2D_BINDING_EXT 
  #define GL_TEXTURE_2D_BINDING_EXT 0x8069
#endif

GLvoid TDemoDebug::buildFont(GLvoid) {
  if(!isSetup) setup();
  if(!font) return;

  glGenTextures(1, &texture);
	base=glGenLists(256);								// Creating 256 Display Lists
	
  GLint tex;
  glGetIntegerv(GL_TEXTURE_2D_BINDING_EXT, &tex);

  glBindTexture(GL_TEXTURE_2D, texture);			// Select Our Font Texture
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, font->width, font->height, 0, GL_RGBA, GL_UNSIGNED_BYTE, font->data);
	for (int loop=0; loop<256; loop++) {
		GLfloat cx=float(loop%16)/16.0f;
		GLfloat cy=float(loop/16)/16.0f;

		glNewList(base+loop,GL_COMPILE);
			glBegin(GL_QUADS);
				glTexCoord2f(cx,1-cy);
				glVertex2i(0,0);
				glTexCoord2f(cx+0.0625f,1-cy);
				glVertex2i(16,0);
				glTexCoord2f(cx+0.0625f,1-cy-0.0625f);
				glVertex2i(16,16);
				glTexCoord2f(cx,1-cy-0.0625f);
				glVertex2i(0,16);
			glEnd();
			glTranslated(12,0,0);
		glEndList();
	}

  glBindTexture(GL_TEXTURE_2D, tex);
}

GLvoid TDemoDebug::killFont(GLvoid) { 
  if(!isSetup) return;

  if(strings) {
    delete strings;
    strings=NULL;
  }
	glDeleteLists(base, 256);
  base=-1;
}

GLvoid TDemoDebug::glPrint(GLint x, GLint y, const char *fmt, ...) {
  char text[256];
	va_list	ap;

	if (fmt == NULL)
		return;

	va_start(ap, fmt);
	    vsprintf(text, fmt, ap);
	va_end(ap);

  TGLState::disable(GL_LIGHTING);
	TGLState::disable(GL_DEPTH_TEST);
  TGLState::disable(GL_BLEND);
  TGLState::enable(GL_ALPHA_TEST);
  glAlphaFunc(GL_GEQUAL, 0.3f);

  TGLState::enable(GL_TEXTURE_2D);

  GLint tex;
  glGetIntegerv(GL_TEXTURE_2D_BINDING_EXT, &tex);

	glBindTexture(GL_TEXTURE_2D, texture);
  glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0,640, 480, 0, -100,100);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	glTranslated(x,y,0);
	glListBase(base);
	glCallLists(strlen(text),GL_UNSIGNED_BYTE,text);
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
  TGLState::disable(GL_ALPHA_TEST);

  glBindTexture(GL_TEXTURE_2D, tex);
  
}

GLvoid TDemoDebug::drawText(GLint x, GLint y, GLfloat r, GLfloat g, GLfloat b, const char *fmt, ...)	{
  if(!isSetup) setup();
  if(!strings) strings = new TList<TDbgString*>;

	char text[256];
	va_list	ap;

	if (fmt == NULL)
		return;

	va_start(ap, fmt);
  vsprintf(text, fmt, ap);
	va_end(ap);
  
  TDbgString *debStr = new TDbgString;
  debStr->x=x;
  debStr->y=y;
  debStr->r=r;
  debStr->g=g;
  debStr->b=b;
  strcpy(debStr->text, text);
  strings->insert(debStr);

}

GLvoid TDemoDebug::setInfo(const char *fmt, ...) {
	char text[256];
	va_list	ap;

	if (fmt == NULL)
		return;

	va_start(ap, fmt);
  vsprintf(text, fmt, ap);
	va_end(ap);

  if(strcmp(infoText, text)) infoTime=INFOLINE_TIME;
  strcpy(infoText, text);  
}


GLvoid TDemoDebug::dumpDebugScreen(GLvoid) {
  if(!isSetup) setup();
  if(!strings) return;

  TNode <TDbgString*>*temp;
 
  if(infoTime) {
    glLoadIdentity();
    glColor3f(1,1,1);
   	glPrint(0,480-16,infoText);
    infoTime--;
  }
  for(temp = strings->front; temp != NULL; temp = temp->next)  {
    if(temp!=NULL) {
      if(showDebug) {
        glLoadIdentity();
    	  glColor3f(temp->getValue()->r, temp->getValue()->g, temp->getValue()->b);
   	    glPrint(temp->getValue()->x, temp->getValue()->y, temp->getValue()->text);
      }
    }
  }
  strings->clear();
  delete strings;
  strings=NULL;
}

GLvoid TDemoDebug::free(GLvoid) {
  if(!isSetup) return;

  if(strings) {
    delete strings;
    strings=NULL;
  }
  killFont();
  freeImage(font);
  isSetup=0;
}


