/**
	
		TTimer - Aadido 31/10/00


/*
	TTimer class
	
	This is a precision timer for demo-timing (all purpose really, but
	that's why I made it and included it here)

	Routines to call:
		start -> will reset the timing to 0, querying the timer will
		         return the value (i.e., Milliseconds) passed since
				  	 the time you called start()

		getTicks -> this is referencial only, you should not use this
		            value except for references, never use it on direct
						  	calculations.

		getTicksPerSecond -> will return the number of ticks per second
		                     (so you can use the ticks returned by
										   	 getTicks(), but that's a bit stupid, keep 
												 reading :)
		getMs -> exactly like 
		         getPrecisionTimeCount(TIMER_PRECISION_MILLISECOND);
		
		getPrecisionTimeCount -> will return the time passed since start()
		           was last called, in the time unit (seconds up to
							 1/1000th of millisecond) you choose. I have
							 included some #defines for common values used.

		getCurrentFrame -> pretty useful when timing a demo. Will return
		           the correct value for "positioning" a effect in time
							 (with a precision of a millisecond, if you need more
							 precision, multiply both values by same number).
							 Take you want a rotozoomer (this uses TRotoZoomer which
							 uses a precision of 1/4 of a degree as "angle") to
							 rotate 1 complete loop (that's 1440 of angle, or 360*4)
							 every 5 seconds, you'd do like this (pseudo-code):

							 loop {
									TRotozoom.Run(MyTextureSurface, MyConsoleSurface, TTimer.getCurrentFrame(1440,5000), MyZoom);
									MyConsoleSurface.update();
							 }
							 
							 This is really pretty useful when timing a demo, having
							 a separate timer for global time and another one for
							 "effect" time. Or you could just implement (ok, ok, I'll
							 do it tomorrow! :) another one which takes the duration
							 of the effect and the starting time, so you could use
							 a global timer always :)

							 This could be a bit messy if you have never done timing
							 before, but it's really easy and useful once you understand
							 it.

	Jcl / Unknown 2000

*/

#ifndef __TIMER_H
#define __TIMER_H

#include <windows.h>

#define TIMER_PRECISION_S            1
#define TIMER_PRECISION_TENTH_S      10
#define TIMER_PRECISION_HUNDREDTH_S  100
#define TIMER_PRECISION_MILLISECOND  1000
#define TIMER_PRECISION_TENTH_MS     10000
#define TIMER_PRECISION_HUNDREDTH_MS 100000

class TTimer {
private:
	LARGE_INTEGER startValue;
	LARGE_INTEGER actualValue;
	LARGE_INTEGER counterFrequency;
	LARGE_INTEGER moreMs;
public:
	TTimer(void);

	void start(void);
	void SetAtMs(__int64 where);  // This doesn't work yet :)
	__int32 getTicks(void);
	__int32 getMs(void);
	__int32 getTicksPerSecond(void);
	__int32 getPrecisionTimeCount(int precision);
	__int32 getCurrentFrame(int totalframes, int totalms);
};


#endif