#ifndef __DEMO_H_
#define __DEMO_H_

// Use this to exclude the Debugger from the compilation
//#define EXCLUDE_DEBUGGER 1

#include <windows.h>
#include <stdio.h>

#include "TextureRepository.h"
#include "scenefactory.h"
#include "scene.h"
#include "win32/soundsystem.h"
#include "win32/window.h"
#include "timer.h"
#ifndef EXCLUDE_DEBUGGER
  #include "debug.h"
#endif

class TDemo {
  TWindow *win;
  TSceneFactory *sceneFactory;  
  TTimer *timer;
  TSoundSystem *music;
  __int32 timerOffs;
  bool musicLoaded;
  int endtime;
public:
  TTextureRepository *sharedTextures;
#ifndef EXCLUDE_DEBUGGER
  TDemoDebug *debug;
#endif
  TDemo(char *title, int width, int height, int bits, bool fullscreen);
  ~TDemo();
  void setMusic(char *filename, int type);
  void addScene(TScene *scene, __int32 startTime, __int32 endTime);
  int setup();
  int run();
  int run(__int32 tOffset);
  void free();
};

#endif