;compile with sjasmplus

    device zxspectrum128
        ORG 6639
begin
sbuf	equ	$7000; buffer for store tile
;part of BASIC
    db $12,$0A,00,$EE,$34,$FD,$DD ; graphics 4
;print usr (6659)
    DB " USR"
    db $96
    db "6659"
    db $95,$FF,0,0;,$0E
start:
;setup memory configuration, VIDEO at $8000-$BFFF, see Gepi kodu programozas kezdoknek.pdf, p.64
    di
    ld      a, 50h
    ld      (3), a          ; 0x0003 - (1 byte) memory paging mode, saving value to port 2 before writing
    out     (2), a          ; U0,U1,VID
    ei
    halt


	ld a,64+16+4+1:out ($63),a ; color for text -;.I.G.R.B
;print text
	ld ix,t1
	call to
;for 3 routines no need to setup IX,because IX points at next data
	call to
	call to
	call to

;start scan keys 0-9
klp:
;76543210
;41.60235
	di
	ld	a, 0 ; operaciosrendszer.pdf, p150
	out	(3), a
	in	a, (58h)
	ld c,0
		  bit 3,a:jp  z,kdone ;0
	inc c:bit 6,a:jp  z,kdone ;1
	inc c:bit 2,a:jp  z,kdone ;2
	inc c:bit 1,a:jp  z,kdone ;3
	inc c:bit 7,a:jp  z,kdone ;4
	inc c:bit 0,a:jp  z,kdone ;5
	inc c:bit 4,a:jp  z,kdone ;6
;76543210
;7....98.
	ld	a, 1
	out	(3), a
	in	a, (58h)

	inc c:bit 7,a:jp  z,kdone ;7
	inc c:bit 1,a:jp  z,kdone ;8
	inc c:bit 2,a:jp  z,kdone ;9
	ei
	jp klp

;for tiles:
;128/4=32 pixel per block
;32/4=8 bytes
kdone: ;C=number level
	ld a,c,(ln),a
levels:
	ei
	halt
	xor a ; black colors
	out ($60),a
	out ($61),a
	out ($62),a
	out ($63),a

	ld hl,0,(cxy),hl; setup variables, cxy =cursor coordinates
	call zeromem

;setup  level
	ld hl,(ln)
	ld h,0
	ld de,hl
	add hl,hl
	add hl,de
	add hl,hl ;N*6
	ld de,levd
	add hl,de
;4 byte is data for colours
	ld a,(hl):out ($60),a:inc hl
	ld a,(hl):out ($61),a:inc hl
	ld a,(hl):out ($62),a:inc hl
	ld a,(hl):out ($63),a:inc hl

;level adress, compressed by zx7
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	ld de,p2
	call dzx7_standard ; d-crunch

	call zeromem

;output picture
	ld de,$8000+56*64+16
	ld ixl,128
	ld hl,p2
co:
	push de
	ld bc,32
	ldir
	pop de
	ld a,e
	add a,64
	ld e,a
	jr nc,noincd
	inc d
noincd:
	dec ixl
	jr nz,co

;swap tile - test routine
;	ld hl,$8000+56*64+16
;	ld de,$8000+56*64+16+8
;	call swapt

	ld bc,150; delay, show number
dl:
	ei
	halt
	dec bc
	ld a,b:or c:jr nz,dl

;swap tiles
	call mix

;draw cursor
	ld hl,$8000+56*64+16
	ld (sxy),hl;sxy is screen address for cursor
	call drt

glp:
	di
	ld de,(cxy) ;D.E=y.x cursor
	ld hl,(sxy) ;screen memory
;check if shift pressed
	ld	a, 6;b3
	out	(3), a
	in	a, (58h)
	ld (shk),a

;right?
	ld	a, 8
	out	(3), a
	in	a, (58h)
	bit 5,a
	jp z,right
;left ?
	bit 6,a
	jp z,left
;down ?
	bit 2,a
	jp z,down
;up ?
	bit 1,a
	jp z,up
	jp glp

up:
; if D=0 go back
	inc d
	dec d
	jp z,glp

	call recbuf ; put back tile, so cursor border has been erased
;check shift pressed?
	ld a,(shk)
	bit 3,a
	jp z,usw ; if pressed, jump to swap routine

	dec d ;for cursor Y=Y-1
	ld (cxy),de
	ld bc,64*32
	or a:sbc hl,bc
	ld (sxy),hl
	jp nomatch

usw:
	push hl
	ld de,-64*32
	ex de,hl
	add hl,de
	call swapt; swap tiles, HL,DE=screen address
	pop hl
	jr endk

down: ; if D=3(cursor Y) go back
	ld a,d
	cp 3
	jp z,glp

	call recbuf
;check shift pressed
	ld a,(shk)
	bit 3,a
	jp z,dsw

	inc d
	ld (cxy),de
	ld bc,64*32
	add hl,bc
	ld (sxy),hl
	jp nomatch

dsw:
	push hl
	ld de,64*32
	ex de,hl
	add hl,de
	call swapt
	pop hl
	jr endk

left:
	inc e:dec e ;id E=0(cursor X) go back to loop
	jp z,glp

	call recbuf
;check shift pressed
	ld a,(shk)
	bit 3,a
	jp z,lsw

	dec e
	ld (cxy),de
	ld bc,8
	or a:sbc hl,bc
	ld (sxy),hl
	jp nomatch
lsw:
	push hl
	ld de,-8
	ex de,hl
	add hl,de
	call swapt
	pop hl
	jr endk

right:
	ld a,e ; if E=3(cursor X) go back to loop
	cp 3
	jp z,glp

	call recbuf
;check shift pressed
	ld a,(shk)
	bit 3,a
	jp z,rsw

	inc e
	ld (cxy),de
	ld bc,8
	add hl,bc
	ld (sxy),hl
endk:
	call check ;check picture with original data
	jp nz,nomatch
;if match blink text
	ld a,20
blink:
	ei:halt:halt
	ld ix,t2
	push af
	call to
	pop af
	dec a
	jr nz,blink
	ld a,(ln) ; next level
	inc a
	cp 10
	jr nz,noln
	xor a
noln:
	ld (ln),a
	jp levels
nomatch:
	call drt ; draw Cursor and store data to sbuf

;test for keypressed
tesk:
	di
sky:
	ld	a, 8
	out	(3), a
	in	a, (58h)
	cpl
	and %01100110
	jr nz,sky
	ei
	halt
	jp glp
rsw:
	push hl
	ld de,8
	ex de,hl
	add hl,de
	call swapt
	pop hl
	jr endk

;vaiables
ln: db 0 ;level number
shk: db 0 ;shift key
cxy:dw 0 ; Y.X
sxy:dw $8000+56*64+16
;'''''''''''''''''''''''''''''''''''''''''''''''
;level data - 4 bytes for colors: ports are $60-$63
;next word is an address packed data
;.I.G.R.B
;76543210
levd:
;1
	db 0
	db 64+16
	db 64+4+16
	db 64+4+1+16
	dw pu1
;2
	db 0
	db 16+1
	db 64+4+16
	db 64+4+1+16
	dw pu2
;3
	db 4
	db 16
	db 0
	db 64+4+16
	dw pu3

;4
	db 1
	db 1+4+64
	db 4+16
	db 4+16+64
	dw pu4

;5
	db 0
	db 4+64
	db 4+16
	db 16+1
	dw pu5

;6
	db 0
	db 16+1+4+64
	db 4+16
	db 64+4+16
	dw pu6
;7
	db 1
	db 1+4+16
	db 4+16
	db 64+4+16
	dw pu7
;8
	db 1
	db 4+16+1
	db 1+4
	db 0;4+16+1
	dw pu8
;9
	db 4
	db 4+16+1+64
	db 4+16
	db 0
	dw pu9
;10
	db 0
	db 4+16+1+64
	db 4+16+1
	db 4+16
	dw pu10
;[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
random: ;A=random number
	push hl,de
seed: ld hl,12345
  ; hl ^= hl << 5
  ld d,h
  ld a,l
  add hl,hl
  add hl,hl
  add hl,hl
  add hl,hl
  add hl,hl
  xor l
  ld l,a
  ld a,d
  xor h
  ld h,a
  ; hl ^= hl >> 9
  rra
  xor l
  ld l,a
  ; hl ^= hl <<8
  xor h
  ld h,a
  ld (seed+1),hl
  pop de,hl
  ret
mix: ;mix tiles routine
	ld a,16
mi0:
	push af
mi1:
	call random
	and 15; tile number 0-15
	ld c,a
	call random
	and 15
	ld b,a ; if numbers match, repeat
	cp c
	jr z,mi1
	call calcadr ; calc screen address by number
	push hl
	ld a,c
	call calcadr
	ex de,hl
	pop hl
	call swapt
	pop af
	dec a
	jr nz,mi0
	call check; if mixed picture match with original, repeat
	jp z,mix
	ret

calcadr:
	ld d,a; NUMBER =Y*4+X
	and 3
	ld e,a
	srl d
	srl d
	ld a,d
	add a,a;Y*32 tiles 0-3,4-7,8-11,12-15
	add a,a
	add a,a
	add a,a
	add a,a
	add a,56
	ld h,a,l,0
	srl h ; Y*64
	rr l
	srl h
	rr l
	set 7,h
	ld d,0
	ld a,e
	add a,a ;X*8
	add a,a
	add a,a
	add a,16
	ld e,a
	add hl,de ;HL=screen address
	ret
zeromem: ;zero VID memory
	push hl
	ld hl,$8000,de,$8001,bc,64*240-1,(hl),l:ldir
	pop hl
	ret
;#####################################################
;routine check match field with original puzzle
check:
	push hl
	ld hl,$8000+56*64+16
	ld de,p2
	ld c,0
	ld a,128
che1:
	push hl
	exa
	ld b,32
che2:
	ld a,(de)
	cp (hl)
	jr z,nxtc
	ld c,1
nxtc:
	inc hl,de
	djnz che2
	pop hl
	push bc
	ld bc,64:add hl,bc
	pop bc
	exa
	dec a
	jp nz,che1
	ld a,c
	or a
	pop hl
	ret
;=====================================================
swapt: ; swap tiles, DE,HL=Addresses
	push hl
	ld a,32
sw1:
	push af
	push de,hl
	ld b,8
sw2:
	ld a,(hl):exa
	ld a,(de),(hl),a
	exa:ld (de),a
	inc hl,de
	djnz sw2
	pop hl,de
	ld c,64
	add hl,bc
	ex de,hl
	add hl,bc
	ex de,hl
	pop af
	dec a:jp nz,sw1
	pop hl
	ret
;+++++++++++++++++++++++++++++++++++++++++++++++++++++
recbuf: ; recover from buf
	push hl,de
	ld de,sbuf
	ex de,hl
	ld a,32
rb1:
	ldi:ldi:ldi:ldi
	ldi:ldi:ldi:ldi
	ex de,hl
	ld bc,64-8
	add hl,bc
	ex de,hl
	dec a
	jr nz,rb1
	pop de,hl
	ret
;*****************************************************
;draw cursor,HL=screen address
drt:
	push hl
	ld ix,sbuf
	ld de,crs
	ld c,32
m1:
	ld b,8
	push hl
m2:
	ld a,(hl),(ix+0),a:inc ix
	ld a,(de)
	cpl
	and (hl)
	ld (hl),a

	ld a,(de):or (hl):ld (hl),a
	inc de,hl
	djnz m2
	pop hl
	ld a,c
	ld c,64
	add hl,bc
	ld c,a
	dec c
	jr nz,m1
	pop hl
	ret
;*****************************************************
; text out, IX points at screen address and text
to:
	ld e,(ix+0):inc ix;get screen address
	ld d,(ix+0):inc ix
tol:
	ld a,(ix+0):inc ix
	or a:ret z ;asciiz, 0 is end of text
	ld h,0,l,a
	ld bc,fnt-256; char*8+font address
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,bc
	
	ld b,8
	push de
ch8:
	ld a,(hl)
	and $F0
	ld c,a
	rra
	rra
	rra
	rra
	or c
	ld c,a
	ld a,(de)
	xor c
	ld (de),a
	inc de
	ld a,(hl)
	and $0F
	ld c,a
	add a,a
	add a,a
	add a,a
	add a,a
	or c
	ld c,a
	ld a,(de)
	xor c
	ld (de),a
	ld a,e
	add a,63
	ld e,a
	ld a,d
	adc a,0
	ld d,a
	inc hl
	djnz ch8
	pop de
	inc de,de
	jp tol

;text messages
t2:
	dw $8000+56*64+16-8*64
	db "Congratulations!",0
t1:
	dw $8006
	db "Goblinish presents Pixteen",0

	dw $8006+16*64+2
	db "press 0 to 9 for puzzle",0

	dw $8006+16*64*2+6*2
	db "Control:#$%&",0

	dw $8004+16*64*3+4
	db "Shift+#$%& - move tile",0
;data for cursor
crs:
	db 255,255,255,255,255,255,255,255
	db 255,255,255,255,255,255,255,255
 dup 28
	db %11001100,000,000,000,000,000,000,%00110011
edup
	db 255,255,255,255,255,255,255,255
	db 255,255,255,255,255,255,255,255
fnt:incbin "Xeno.fnt"
;compressed data
zx7:include "zx7.a80"
pu1: incbin "p1.bin.zx7"
pu2: incbin "p2.bin.zx7"
pu3: incbin "p3.bin.zx7"
pu4: incbin "p4.bin.zx7"
pu5: incbin "p5.bin.zx7"
pu6: incbin "p6.bin.zx7"
pu7: incbin "p7.bin.zx7"
pu8: incbin "p8.bin.zx7"
pu9: incbin "p9.bin.zx7"
pu10: incbin "p10.bin.zx7"
p2:;place where decrunched puzzle data stores
end
    display /d,start
    display /d,end-begin
    savebin "pu.bin",begin,end-begin

;erase previous file
	LUA
	os.remove("pu.cas")
	ENDLUA
 shellexec "tvctape pu.bin pu.cas"
 