#include <stdio.h>
#include <fstream.h>
#include <stdlib.h>
#include <math.h>

int main(int argc, char *argv[])
{
  FILE *in;
  FILE *out;
  int counter=0;
  int clipdata[65536];

  // open raw data

  in = fopen ("SCREEN.PRG","rb");    // open ball
  fgetc(in);
  fgetc(in);
  counter=0;
  while(feof(in)==0) {
      clipdata[counter]=fgetc(in);
      counter++;
  }
  counter--;                           // don't count eof-char
  fclose(in);                          // close stream

  cout << counter << " bytes read\n";

  out=fopen("clipdata.txt","w");

  // write first 128 bytes (pointers)

  fputs("layer0clipmap    ;pointers to rle-ed rowdata\n",out);
  int c1;
  int offset;
  int pointer;
  offset=clipdata[0]+clipdata[1]*256;
  for(c1=0;c1<64;c1++){
    pointer=clipdata[c1*2]+clipdata[c1*2+1]*256-offset;
    if(c1%8==0) {fputs("        .word ",out);}
    else        {fputs(",",out);}
    fprintf(out,"cliprows+%i",pointer);
    if (pointer<10)  {fputs(" ",out);}
    if (pointer<100) {fputs(" ",out);}
    if (pointer<1000){fputs(" ",out);}
    if(c1%8==7) {fputs("\n",out);}
  }//for c1
  fputs("cliprows\n",out);
  c1*=2;
  while(c1<counter){
    if(c1%32==0) {fputs("        .byte ",out);}
    else {fputs(",",out);}
    fprintf(out,"%i",pointer=clipdata[c1]);
    if (pointer<10)  {fputs(" ",out);}
    if (pointer<100) {fputs(" ",out);}
    if(c1%32==31) {fputs("\n",out);}
    c1++;
  }//while
  fclose(out);
  return 0;
}
