#include <stdio.h>
#include <string.h>
#include <fstream.h>
#include <stdlib.h>

int main(void)
{
       //12345.12345.12345.12345.12345.
  char* font[21]={
        "        *   ***     *** ***   *****",
        "       ***  ****   **** ****  *****",
        "       ***  ****   **** ****  *****",
        "      ***** ***** ***** ***** *****",
        "      ** ** ** ** **    ** ** **   ",
        "      ** ** ** ** **    ** ** **   ",
        "      ** ** ** ** **    ** ** **   ",
        "      ** ** ** ** **    ** ** **   ",
        "      ** ** ****  **    ** ** **   ",
        "      ***** ***   **    ** ** ***  ",
        "      ***** ****  **    ** ** ***  ",
        "      ** ** ** ** **    ** ** **   ",
        "      ** ** ** ** **    ** ** **   ",
        "      ** ** ** ** **    ** ** **   ",
        "      ** ** ** ** **    ** ** **   ",
        "      ** ** ** ** **    ** ** **   ",
        "      ** ** ** ** **    ** ** **   ",
        "      ** ** ***** ***** ***** *****",
        "      ** ** ****   **** ****  *****",
        "      ** ** ****   **** ****  *****",
        "      ** ** ***     *** ***   *****"
	};

	int nrchars=(strlen(font[0])+6)/6;
	int nrtripplets=(nrchars+2)/3;

	int size=64*nrtripplets;
    int size2=21*72;  // 72 chars of 21 bytes

    int loadarea[65536];
    int loadbytes=0;

	unsigned char* output=new unsigned char[size];
	unsigned char* output2=new unsigned char[size2];

    int counter;
    int counter2;
    int ch,y;
    FILE *in;

	memset(output,0,size);
	memset(output2,0,size2);

    // clear counter2

    for (counter=0;counter<size2;counter++){
        output2[counter]=0;
    }//for counter


    // ASK IF USER WANTS TO CONVERT EXISTING FONT.BIN TO .TXT
    // OR CONVERT THE CHARS IN THE CODE TO .TXT AND .BIN

    int answer=0;

    cout << "Do you want to convert font.bin into .txt file (1)\nor generate both .bin and .txt file from the chars inside the code (2)?";

    while (!(answer==1 || answer==2)){
      cin >> answer;
    }//while
    cout << "You answered " << answer << "." << endl;

    if(answer==2){
    // CONVERT CHARS IN CODE TO DATA
	  for (ch=0; ch<nrchars; ch++){
		  int base=(ch/3)*64+(ch%3);
		  for (y=0;y<21;y++){
			unsigned char byte=0;
			for (int x=0;x<5;x++){
			  if (font[y][ch*6+x]=='*')
			    byte|=1<<(5-x);
            }//for x
			output[base+y*3]=byte;
            output2[ch*21+y]=byte;
		  }
	  }
   }//if answer
   if (answer==1){
   // READ FONT.BIN
     loadbytes=0;
     in = fopen ("font.bin","rb");    // open existing font
     while(feof(in)==0) {
       loadarea[loadbytes]=fgetc(in);
       loadbytes++;
     }//while
     //convert read sprite data into letterdata
     nrchars=3*((loadbytes+62)/64);
     for (counter=0;counter<nrchars;counter++){
       for (y=0;y<21;y++){
         output2[counter*21+y]=loadarea[y*3+(counter/3)*64+counter%3];
       }//for y
     }//for counter

   }//if answer==1

   if (answer==2){
      // output font in sprite-bin file

	  FILE *f=fopen("font.bin", "wb");
	  fwrite(output,size,1,f);
	  fclose(f);
    }//if answer

    // output font mixed with grid data, we always do this, no matter what.

    FILE *f2=fopen("font.txt", "wb");

    ch=y=0;
    fputs(";display-font data mixed with display-grid data\n\n*=gridandfont\n\n",f2);

    for (counter=0;counter<256;counter++){

      //check if we need to move *
      if(counter%64==0 && counter!=0){
        fputs("\n*=*+$600\n\n",f2);
      }//if

      fputs ("        .byte ",f2);
      for (counter2=0;counter2<3;counter2++){
        fprintf(f2,"%i,",output2[(ch+counter2)*21+y]);
      }//for
      y++;
      if(y==21){ch+=3;y=0;}
      fputs ("0,",f2);
      if(counter%32==31){           //we have to fill the last bit up with empty shit
        fputs("0,0,0,",f2);
      }//if
      else{
        for (counter2=0;counter2<3;counter2++){
          fprintf(f2,"%i,",output2[(ch+counter2)*21+y]);
        }//for
        y++;
        if(y==21){ch+=3;y=0;}
      }//else
      fputs ("$55\n",f2);
    }//for coutner
    fclose(f2);

	delete output;

	return 0;
}

