/************************************************
 *     MP3 constant tables for decoder          *
 * heavily based on 'xamp' from Tomislav Uzelac *
 * Skal 98                                      *
 ************************************************/

#ifndef _MP3_TAB_H_
#define _MP3_TAB_H_

/******************************************************************/

EXTERN USHORT MP3_Scale_l[2][22];
EXTERN USHORT MP3_Scale_s[2][13][3];
EXTERN INT MP3_imdcts[2];
EXTERN FLT MP3_Out[2][32][18]; // after requantization...


/* the last sfb is given implicitly on pg.28. of the standard. 
 * scalefactors for that one are 0, pretab also
 */
/* leftmost index denotes ID, so first three tables 
 * are for MPEG2 (header->ID==0)
 * and the other three are for MPEG1 (header->ID==1)
 */

/* 22.05, 24, 16 */  
EXTERN SHORT MP3_b8_l[2][3][22] =
{
   {        // table B.8b ISO/IEC 11172-3
      { 5,11,17,23,29,35,43,53,65,79,95,115,139,167,199,237,283,335,395,463,521,575 },
      { 5,11,17,23,29,35,43,53,65,79,95,113,135,161,193,231,277,331,393,463,539,575 },
      { 5,11,17,23,29,35,43,53,65,79,95,115,139,167,199,237,283,335,395,463,521,575 }
   },
   {
      { 3,7,11,15,19,23,29,35,43,51,61,73,89,109,133,161,195,237,287,341,417,575 },
      { 3,7,11,15,19,23,29,35,41,49,59,71,87,105,127,155,189,229,275,329,383,575 },
      { 3,7,11,15,19,23,29,35,43,53,65,81,101,125,155,193,239,295,363,447,549,575 }
   }
};   

EXTERN SHORT MP3_b8_s[2][3][13] = 
{
   {        // table B.8b ISO/IEC 11172-3
      { 3,7,11,17,23,31,41,55,73,99,131,173,191 },
      { 3,7,11,17,25,35,47,61,79,103,135,179,191 },
      { 3,7,11,17,25,35,47,61,79,103,133,173,191 }
   },
   {
      { 3,7,11,15,21,29,39,51,65,83,105,135,191 },
      { 3,7,11,15,21,27,37,49,63,79,99,125,191 },
      { 3,7,11,15,21,29,41,57,77,103,137,179,191 }
   }
};

/******************************************************************/

 /* 
  * the maximum value of is_pos. for short blocks is_max[sfb=0] == is_max[6],
  * it's sloppy but i'm sick of waisting storage. blaah...
  *   (Tomislav Uzelac)
  */
EXTERN INT HUFF_IS_Max[21];
EXTERN INT HUFF_IS[2][578];

/******************************************************************/
/******************************************************************/

#endif      // _MP3_TAB_H_

