; Sets a specified block of the palette to a greenish gradient. The starting
; index is specified in ax. Not the entire palette is set; as the brighter
; colors advance in the palette, the darkest color leaves a trail. Setting the
; palette register at 0 to a nonzero green value would set the border color to
; a non-black color, which is not intended, so it is explicitly skipped.

;------------------------------------------------------------------------------
;macro for writing a green gradient into the vga palette
;NumIter - number of color entries being generated
;cx, dx are destroyed
;no result
;------------------------------------------------------------------------------

ColorCycle MACRO NumIter
LOCAL SetNextColor, SkipBorder
     mov  cl, NumIter
     mov  dx, 03C8h       ;port for setting palette index to change
SetNextColor:
     push ax
     add  ax, cx
     test al, al          ;skip color at index zero, see commet at the bottom
     jz   SkipBorder

     out  dx, al          ;write palette index to change to port
     inc  dx              ;increment to port 03C9h to write rgb values
     xor  ax, ax
     out  dx, al          ;set red (always 0)
     mov  al, cl          ;load green value (which is the current loop counter)
     out  dx, al          ;set green
     xor  ax, ax
     out  dx, al          ;set blue (always 0)
     dec  dx              ;reset port to 03C8h again
SkipBorder:
     pop  ax
     loop SetNextColor
ENDM
