; These are two macros to set the entire VGA palette to black. In the original
; version by Resident, the code in the macro ClearPalPorts was used, which is
; significantly faster but results in larger code.

;------------------------------------------------------------------------------
;macro to set the entire vag palette to black (via BIOS calls)
;ax, bx, cx, dx destroyed (bx, cx, dx set to 00h)
;no result
;------------------------------------------------------------------------------
ClearPalBios MACRO
LOCAL ClearPaletteLoop
     mov ax, 01010h       ;set the entire vga palette to black
     xor bx, bx
     xor cx, cx           
     xor dx, dx
ClearPaletteLoop:
     int 10h              ;use bios interrupt to set palette,
     dec bl               ;bl contains the palette index
     jnz ClearPaletteLoop
ENDM

;------------------------------------------------------------------------------
;macro to set the entire vga palette to black (via ports)
;ax, dx, ds destroyed (ax set to 00h)
;no result
;------------------------------------------------------------------------------
ClearPalPorts MACRO
LOCAL ClearPaletteLoop
     mov  dx, 03C8h
     mov  ds, dx          ;this was in the implementation by Resident
     xor  ax, ax
ClearPaletteLoop:
     out  dx, al
     inc  dx              ;switch to port 03C9h (to set rgb components)
     xchg ah, al
     out  dx, al          ;red
     out  dx, al          ;green
     out  dx, al          ;blue
     xchg ah, al
     dec  dx              ;switch to port 03C8h again (to set next index)
     inc  al
     jnz  ClearPaletteLoop
ENDM
