/*

	Polygon drawing library

	M3D_poly.h
*/

#ifndef _M3D_POLY_H
#define _M3D_POLY_H

#include <math.h>
#include <graph.h>
#include <stdio.h>
#include <stdlib.h>
#include "M3D_math.h"
#include "M3D_colr.h"


typedef struct {
	float		clip_top, clip_bot;			/* Size of virtual window.	Must be within 0 and buffer_height */
	float		clip_left, clip_right;		/* 							Must be within 0 and buffer_width */
	
	char		*buffer;					/* Output buffer. All polys will be drawn here. */

	int			buffer_width;
	int			buffer_height;
	
	float		view_center_x;				/* Used when vertices are projected in 2d. */
	float		view_center_y;
} M3Dviewport;


typedef struct {						/* Usual stuff. */
	int			x, y;
	int			color2;
	M3Dcolor	color;
} M3Dpoly_point;


/* Globals set by set_out_viewport. These variables will be used in all polyfillers. */

extern	char	*M3Dout_buffer;
extern	char	*M3Dscreen;
extern	int		M3Dbuffer_width, M3Dbuffer_height;
extern	float	M3Dview_center_x, M3Dview_center_y;
extern	int		M3Dclip_top, M3Dclip_bot;
extern	int		M3Dclip_left, M3Dclip_right;


extern	void	set_out_viewport (M3Dviewport *view);

extern	void	draw_solid_poly (M3Dpoly_point *points);
extern	void	draw_gouraud_poly (M3Dpoly_point *points);

extern	void	set_mode13h (long parm1);
extern	void	retrace ();
extern	void	setborder(char col);
extern	void	drawrgbgouraudpoly (long x1, long y1, long x2, long y2, long x3, long y3,
									long r1, long g1, long b1, long r2, long g2, long b2, long r3, long g3, long b3);
extern	void	showbuffer (char *buffer);
extern	void	clearbuffer (char *buffer);

#endif