/*

	Camera library
	
	M3D_cam.h

*/

#ifndef _M3D_CAM_H
#define _M3D_CAM_H

#include <conio.h>
#include <graph.h>
#include <malloc.h>
#include "m3d_math.h"
#include "m3d_poly.h"
#include "m3d_geom.h"

#ifndef	TRUE
	#define	TRUE	0
#endif
#ifndef	FALSE
	#define	FALSE	-1
#endif


typedef struct {
	M3Dvector		position;
	M3Dvector		target;
	float			bank;
	float			FOV;
	float			eye_distance;
	
	int				rotate_x;
	int				rotate_y;
	int				rotate_z;

	M3Dviewport		viewport;
	
	M3Dmatrix		matrix;
} M3Dcamera;


extern	void	setup_camera(M3Dcamera *cam);
extern	void	render(M3Dcamera *cam);

#endif