/*

	Camera library
	
	M3D_cam.c

*/

#include "M3D_cam.h"


void	setup_camera (M3Dcamera *cam)
{
	int			ax, ay, az;
	float		d1, d2;
	M3Dvector	focus;
	M3Dmatrix	mat1, mat2;
	
	init_matrix(mat1);
	init_matrix(mat2);

	vector_sub(&cam->target, &cam->position, &focus);

	d1 = sqrt((focus.x * focus.x) + (focus.y * focus.y) + (focus.z * focus.z));
	d2 = sqrt((focus.x * focus.x) + (focus.z * focus.z));

	ax = (int)(asin(focus.y / d1) * 1800 / 3.141528);
	ay = (int)(acos(focus.z / d2) * 1800 / 3.141528);
	az = (int)(cam->bank) * 10;

/*	printf("%d %d %d\n", ax, ay, az);*/

	rotate_XYZ(mat1, -ax, -ay, -az);
	translate(mat2, -cam->position.x, -cam->position.y, -cam->position.z);

	mult_matrix_matrix(mat2, mat1, cam->matrix);
}


void	render (M3Dcamera *cam)
{
	set_out_viewport(&cam->viewport);

	transform_world(cam->matrix);

	check_mesh_visibility();
	process_lights();

	project(cam->eye_distance);

	sort_polys();
	draw_polys();
}