// flare temple

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "\sr\h\sr.h"
#include "\lib\h\control.h"
#include "\lib\h\memory.h"
#include "\lib\h\bitmap.h"
#include "h\inside.h"

static char        *palette,*qtable,*tmap,*ftable,*flarepic;
static char        *envmap;
static SR_FILE     *sro[6];
static SR_MAT      *mat[3];
static SR_SCENE    *scene;
static SR_CAMERA   *camera;
static SR_MESH     *ob[6];
static SR_BITMAPOBJ *flare[15];
static MATRIX3     obmtx[6],cammtx,dummymtx,flaremtx[15];
static VECTOR3     obloc[6],camloc,dummyloc,flareloc[15];
static SR_OBJ      *dummy;
static SR_LIGHT    *light;

static int temple_tag;
static int flarecounter;
       int sync_length;
       int sync_adder = 2;

//-----------------------------------------------------------------------------

static void init_camera()
{
    dummy = MEM_allocate_named(sizeof(SR_OBJ),"dummy camera holder");
    SR_init_object(dummy);
    SR_mrotxyz (dummymtx,0,0,0);
    SR_add_object (scene,dummy);

    camera = MEM_allocate_named(sizeof(SR_CAMERA),"camera");
	SR_camera_init(camera);
    SR_add_object  (scene, (SR_OBJ *)camera);
    camera->parent = dummy;

    scene->camera = camera;
    SR_vmake (camloc,0,320,-850);
    SR_mrotxyz (cammtx,PI/12,0,PI);
}

//-----------------------------------------------------------------------------

static void initialize_objects()
{
    int i;

    for (i=0; i<6; i++)
    {
        ob[i] = MEM_allocate_named (SR_SIZE(sro[i]),"temple scene object");
        SR_init_object((SR_OBJ *)ob[i]);
        SR_load_object(ob[i],sro[i],65536*0.1,mat[0]);
        SR_set_object_render(ob[i],SR_TEX);
        SR_add_object(scene,(SR_OBJ*)ob[i]);
        ob[i]->flags|=SR_ENVLOCAL;
        SR_vmake (obloc[i],0,0,0);
        SR_mrotxyz (obmtx[i],0,0,0);
    }

    SR_set_object_render(ob[0],SR_TEX);
    SR_set_object_render(ob[1],SR_TEX_I);
    ob[2]->flags&=~SR_ENVLOCAL;
    ob[2]->flags|=SR_DO_LIGHT;

    SR_set_object_render(ob[2],SR_TEX_G);

    SR_set_object_render(ob[3],SR_TRI_GI);            // putki1
    SR_set_location ((SR_OBJ *)ob[3],0,160,0);
    SR_mrotxyz (obmtx[3],DEGREE_TO_RAD(105.0),DEGREE_TO_RAD(15.0),DEGREE_TO_RAD(30.0));
    SR_mesh_relocate_vertices (ob[3],-ob[3]->vertex[12].x,
                                     -ob[3]->vertex[12].y,
                                     -ob[3]->vertex[12].z);
    SR_mesh_scale (ob[3],1.5,1.5,5.3);
    SR_calc_poly_normals(ob[3]);
    SR_calc_vertex_normals(ob[3]);
    for (i=0; i<ob[3]->pnum; i++)
        ob[3]->poly[i].mat = mat[1];

    SR_set_object_render(ob[4],SR_TRI_GI);      // putki2
    SR_set_location ((SR_OBJ *)ob[4],0,160,0);
    SR_mesh_relocate_vertices (ob[4],-ob[4]->vertex[12].x,
                                     -ob[4]->vertex[12].y,
                                     -ob[4]->vertex[12].z);
    SR_mrotxyz (obmtx[4],DEGREE_TO_RAD(75.0),DEGREE_TO_RAD(-20.0),0);
    SR_mesh_scale (ob[4],1.5,1.5,5.3);
    SR_calc_poly_normals(ob[4]);
    SR_calc_vertex_normals(ob[4]);

    for (i=0; i<ob[4]->pnum; i++)
        ob[4]->poly[i].mat = mat[1];

    SR_set_object_render(ob[5],SR_TRI_GI);      // putki2
    SR_mrotxyz (obmtx[5],DEGREE_TO_RAD(90.0),0,0);
    SR_mesh_scale (ob[5],3.0,3.0,4.6);
    SR_calc_poly_normals(ob[5]);
    SR_calc_vertex_normals(ob[5]);
    SR_vmake (obloc[5],0,100,0);

    for (i=0; i<ob[5]->pnum; i++)
        ob[5]->poly[i].mat = mat[1];

    SR_vmake (obloc[3],0,-150,0);
    SR_vmake (obloc[4],0,-150,0);

    for (i=0; i<flarecounter;i++)
    {
        flare[i]=MEM_allocate_named(sizeof(SR_BITMAPOBJ),"flare");
        SR_bitmap_init(flare[i]);
        flare[i]->bitmap = flarepic;
        flare[i]->qtable = ftable;
        flare[i]->render_func = SR_BMP_I;
        SR_vmake(flareloc[i],rand()%1000-500,rand()%300+70,rand()%1000-500);
        flare[i]->physwidth = 128;
        flare[i]->xsiz = 128;
        flare[i]->ysiz = 104;
        flare[i]->refscale = 1.0;
        flare[i]->scale = 0.25;
        SR_add_object (scene,(SR_OBJ*)flare[i]);
        SR_mrotxyz (flaremtx[i],0,0,0);
    }

// add light source

    light = MEM_allocate_named (sizeof(SR_LIGHT),"temple light source");
    SR_init_object((SR_OBJ *)light);
    light->flags|=SR_ILLUMINATE;
    light->falloff = 500;
    light->luminance =100*16;
    SR_add_object(scene,(SR_OBJ*)light);

}

//-----------------------------------------------------------------------------

static void rota_object()
{
    MATRIX3 m;
    int i;
    FLOAT p,y;

    SR_mrotxyz (m,0,0.01,0);
    SR_mmul (dummymtx[0],m);
    SR_mrotxyz (m,0,0,0.005);
    SR_mmul (cammtx[0],m);

    for (i=0; i<flarecounter; i++)
    {
        SR_mrotxyz (m,-0.01*(flarecounter-i),-0.03*i,0);
        SR_mmul (flaremtx[i],m);
    }

    p = DEGREE_TO_RAD(sin(timer/179.0)*35);
    y = DEGREE_TO_RAD(cos(timer/231.4)*33.3);

    SR_mrotxyz (obmtx[3],PI/2+p,y,0);
    SR_mrotxyz (obmtx[4],PI/2-p,-y,0);

}

//-----------------------------------------------------------------------------

void temple_irq()
{
    rota_object();
    sync_length+=sync_adder;
    if (sync_length<150 || sync_length > 700) sync_adder=-sync_adder;
}

//-----------------------------------------------------------------------------

static void copy_locations()
{
    int i;
    float r;

    for (i=0; i<6; i++)
    {
        ob[i]->x = obloc[i][0];
        ob[i]->y = obloc[i][1];
        ob[i]->z = obloc[i][2];
        SR_mcopy (ob[i]->matrix,obmtx[i]);
    }

    for(i=0; i<flarecounter;i++)
    {
        r = fabs(sin((timer+i*13)/271.1)*0.7)+0.15;

        flare[i]->x = flareloc[i][0]*r;
        flare[i]->y = flareloc[i][1]*r;
        flare[i]->z = flareloc[i][2]*r;
        SR_mcopy (flare[i]->matrix,flaremtx[i]);
    }

    r = fabs(sin((timer)/471.1)*0.7);

    dummy->x = dummyloc[0];      // copy camera parameters
    dummy->y = dummyloc[1];
    dummy->z = dummyloc[2];
    SR_mcopy (dummy->matrix,dummymtx);

    r = fabs(sin((timer)/461.1)*1.0);
    light->falloff = r*1000;

    for (i=5; i<11; i++)
    {
        r = sin( (timer+i*53)/(971.1+i*11) )*16*16*0.95;
        ob[3]->vertex[i].g = r+16*16;
        ob[4]->vertex[i].g = r+20*16;
        ob[5]->vertex[i].g = r+22*16;
    }

    r = (sin(timer/891.1)*0.3)+0.6;

    camera->x = (camloc[0]*r);      // copy camera parameters
    camera->y = (camloc[1]*r);
    camera->z = (camloc[2]*r);
    SR_mcopy (camera->matrix,cammtx);

}

//-----------------------------------------------------------------------------

void temple_main_loop()
{

    scene->buffer = buffer1;

    file_io++;

    copy_locations();

    file_io--;

//    SR_clear_view (scene,0);
    SR_render_view(scene);

    show_info();
    flip_page();
}

//-----------------------------------------------------------------------------

void temple_load()
{
    file_io++;

    temple_tag = MEM_get_unused_tag();
    MEM_set_tag (temple_tag);

    tmap        = load_file ("temple/temple.raw");
    flarepic    = load_file ("temple/flare.raw");
    qtable      = load_file ("temple/temple.int");
    ftable      = load_file ("temple/flare.shd");
    palette     = load_file ("temple/temple.pal");
    sro[0]      = load_file ("temple/mesta21.sro");
    sro[1]      = load_file ("temple/mesta22.sro");
    sro[2]      = load_file ("temple/mesta23.sro");
    sro[3]      = load_file ("temple/putki.sro");
    sro[4]      = load_file ("temple/putki.sro");
    sro[5]      = load_file ("temple/putki.sro");

    mat[0]      = MEM_allocate_named(sizeof(SR_MAT),"temple material");
    mat[1]      = MEM_allocate_named(sizeof(SR_MAT),"temple material 2");

    scene = MEM_allocate_named(sizeof(SR_SCENE),"temple scene");

    SR_init_scene (scene);                  // initialize scene to default parameters
    SR_set_viewport(scene,320,200,0,0,320,200);

    scene->perspective = 170;

    SR_set_material (mat[0],tmap,NULL,qtable,NULL,255,255,8,8);
    SR_set_material (mat[1],tmap,NULL,ftable+32*256,NULL,255,255,8,8);

    flarecounter = 10;

    sync_length = 500;

    init_camera();
    initialize_objects();

    file_io--;
}

//-----------------------------------------------------------------------------

void temple_init()
{
    MEM_set(buffer1,0,320*200);
    MEM_set(buffer2,0,320*200);
    strobo();
    set_base_palette(palette);
    set_demo_irq  (&temple_irq);
    set_demo_loop (&temple_main_loop);
}

//-----------------------------------------------------------------------------

void temple_exit()
{
    set_demo_irq  (NULL);
    set_demo_loop (NULL);
    //MEM_free_tagged (temple_tag);
}

//-----------------------------------------------------------------------------

