#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "\sr\h\sr.h"
#include "\lib\h\control.h"
#include "\lib\h\memory.h"
#include "\lib\h\bitmap.h"
#include "h\inside.h"

typedef struct
{
    float x,y;
    int intensity;
    int used;
} lightstruct;

static short       *lightbuf;

static char        *palette,*intropic,*qtable;
static BITMAP      *introbmo;
static lightstruct *lightdrop;
static VECTOR2      target;
static          int intro_tag;
static volatile int burst;
static volatile int bcount;

//-----------------------------------------------------------------------------

void intro_burst()
{
    int i;
    burst = 1;

    for (i=0; i<130; i++)
    {
        lightdrop[i].x = rand()%320;
        lightdrop[i].y = rand()%200;
        lightdrop[i].intensity=7000;
    }

}

//-----------------------------------------------------------------------------

void intro_irq()
{

    target[0]+=10*sin(demotimer/(50.0))*4.7+cos(demotimer/43.1)+4.4*sin(demotimer/27.1);
    target[1]+=12*cos(demotimer/(31.4))*3.7+cos(demotimer/36.1)+2.6*sin(demotimer/41.1);

    if (target[0]>319) target[0] = 30+rand()%40;
    if (target[0]<0)   target[0] = 250+rand()%50;
    if (target[1]>199) target[1] = 30+rand()%20;
    if (target[1]<0)   target[1] = 160+rand()%20;

}

//-----------------------------------------------------------------------------

static void change_lightmap()
{
    int i,b;
    int x,y;
    int j,k;
    int in;

    if (burst>0 && bcount<128) bcount++;

    for (i=0; i<bcount; i++)
    {
        if (!(rand()%20))
        {
            x = target[0]+rand()%90-40;
            y = target[1]+rand()%80-40;

            lightdrop[i].x = x;
            lightdrop[i].y = y;
            lightdrop[i].intensity = rand()%6500;
            lightdrop[i].intensity+= bcount*100;

            if (!rand()%3)
                lightdrop[i].intensity = -lightdrop[i].intensity;

            lightdrop[i].intensity+= (bcount-22) *30;

        }

        if (lightdrop[i].x<0)   lightdrop[i].x = rand()%50+260;
        if (lightdrop[i].y<0)   lightdrop[i].y = rand()%30+160;
        if (lightdrop[i].x>319) lightdrop[i].x = rand()%30+50;
        if (lightdrop[i].y>199) lightdrop[i].x = rand()%30+45;

        if (lightdrop[i].x>=1 && lightdrop[i].x<319 &&
            lightdrop[i].y>=1 && lightdrop[i].y<199)
        {
            k = (int)(lightdrop[i].x)+(int)(lightdrop[i].y)*320;

            if(sqrt((80-lightdrop[i].x)*(80-lightdrop[i].x)+
               (80-lightdrop[i].y)*(80-lightdrop[i].y))<60) continue;

            in = lightbuf[k]+lightdrop[i].intensity;
            if (in<-30000) in = -30000; else
            if (in>30000) in = 30000;
            lightbuf[k]=in;
        }
    }

}

//-----------------------------------------------------------------------------

static void blur_lightmap()
{
    short *l;
    int x,y;

    l = lightbuf+1+320;

    for (y=1; y<198; y++,l+=2)
    for (x=1; x<319; x++,l++)
    {
        l[0] = (((int)l[0]*4+l[-1]+l[1]+l[-320]+l[320]))/8;
    }
}

//-----------------------------------------------------------------------------

static void apply_lightmap()
{
    short *l;
    char *b;
    int x,y,k;

    l = lightbuf;
    b = buffer1;

    for (y=0; y<200; y++)
    for (x=0; x<320; x++,l++,b++)
    {
        k = l[0];
        if (k<0) k = 0; else
        if (k>63) k = 63;
        b[0]=qtable[k*256+b[0]];
    }
}

//-----------------------------------------------------------------------------

void intro_main_loop()
{

    change_lightmap();
    blur_lightmap();

    BITMAP_draw (introbmo,0,0);
    apply_lightmap();

    show_info();
    flip_page();
}

//-----------------------------------------------------------------------------

void intro_load()
{
    int i;

    file_io++;

    lightdrop = MEM_allocate_named (sizeof(lightstruct)*130,"intro light drops");

    intro_tag = MEM_get_unused_tag();
    MEM_set_tag (intro_tag);

    qtable      = load_file ("intro/intro.shd");
    palette     = load_file ("intro/intro.pal");
    intropic    = load_file ("intro/intro.raw");
    lightbuf    = MEM_allocate_named(sizeof(short)*320*200,"intro lightbuf");

    introbmo = BITMAP_make_sprite8 (intropic, 320, 320,200, "intro pic");
    introbmo->type = BITMAP8_M;

    set_base_palette(palette);
    set_fade (1.0,120);

    for (i=0; i<130; i++)
    {
        lightdrop[i].x=rand()%320;
        lightdrop[i].y=rand()%200;
        lightdrop[i].intensity=0;
    }

    target[0] = 200;
    target[1] = 150;

    burst = 0;
    bcount = 22;

    file_io--;
}

//-----------------------------------------------------------------------------

void intro_init()
{
    set_demo_irq  (&intro_irq);
    set_demo_loop (&intro_main_loop);

}

//-----------------------------------------------------------------------------

void intro_exit()
{
    set_demo_irq  (NULL);
    set_demo_loop (NULL);
    MEM_free_tagged (intro_tag);
}

//-----------------------------------------------------------------------------

