#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <i86.h>

#include "h\inside.h"
#include "h\snd.h"
#include "\lib\h\tga.h"
#include "\lib\h\control.h"
#include "\lib\h\memory.h"
#include "\lib\h\vga.h"
#include "\lib\h\file.h"
#include "h\dsmi.h"
#include "\sr\h\sr.h"
#include "script"

int DEBUG    = 0;
int ZIPLOAD  = 0;
int SILENT   = 0;

#define DPMI_INT    0x31

//-----------------------------------------------------------------------------

volatile int next_event;
volatile int file_io;

volatile int force_exit = 0;
volatile int cli = 0;

float *fpalette;
float *fpalette_add;
float  fade_level= 0.0;

char *base_palette;             // palette choses by user
char *cur_palette;              // fading taken into account

char *buffer1;
char *buffer2;
char *irqstack;

volatile void (*demo_irq)();   // current demo part function
volatile void (*demo_loop)();  // demo part main loop functions
volatile int   timer;           // total timer
volatile int   demotimer;       // timer for each specific part
volatile int   fadecounter;
volatile float frames_blitted;
volatile float framecounter;

         int   inside_tag;
         int   origmem;

//-----------------------------------------------------------------------------

         int   textwidth[256];
unsigned char *textplace;
unsigned char *textchars[256];
unsigned char *textgfx;

unsigned char *textcharlist =
 "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
 "0123456789+-':;?!\"#$%&/()[]{}<>\\'`҂* &|.,";


char errmsg[1024];                // error message

//-----------------------------------------------------------------------------

int   entrycounter;               // how many entries in file entry list
char *databuffer;                 // file data buffer

typedef struct
{
    char  name[32];
    int   size;
    int   offset;
    char *data;       // not needed in this program
    int   comptype;   // compression type
} entrystruct;

entrystruct *entrylist;           // entry list

//-----------------------------------------------------------------------------

struct meminfo {
    unsigned int LargestBlockAvail;
    unsigned int MaxUnlockedPage;
    unsigned int LargestLockablePage;
    unsigned int LinAddrSpace;
    unsigned int NumFreePagesAvail;
    unsigned int NumPhysicalPagesFree;
    unsigned int TotalPhysicalPages;
    unsigned int FreeLinAddrSpace;
    unsigned int SizeOfPageFile;
    unsigned int Reserved[3];
} MemInfo;

//-----------------------------------------------------------------------------

int memfree()
{
    union REGS regs;
    struct SREGS sregs;

    if(DOSEXT==X32)
    {
        regs.x.eax = 0x350B;
        int386(0x21, &regs, &regs);
//        printf("Total memory available %d Kb.\n", regs.x.eax/1024);

        return regs.x.eax;
    }
    else  // dos4gw/pmodew
    {
        regs.x.eax = 0x00000500;
        memset( &sregs, 0, sizeof(sregs) );
        sregs.es = FP_SEG( &MemInfo );
        regs.x.edi = FP_OFF( &MemInfo );

        int386x( DPMI_INT, &regs, &regs, &sregs );

        return MemInfo.LargestBlockAvail;
    }
}

//-----------------------------------------------------------------------------

extern void decomp_file (char *frombuf, char *tobuf, int length);

#pragma aux decomp_file "*_" \
 parm caller [esi] [edi] [ecx]\
 modify [];

//-----------------------------------------------------------------------------

char *data_load(char *name, int *size)
{
    FILE *infile;
    int inlength;
    char *inbuf,*outbuf;

    infile = fopen(name,"rb");               // open input file
    if (!infile) return NULL;

    fseek (infile,0,2);
    inlength=ftell(infile);                     // get file length

    inbuf=malloc(inlength+40);

    if (!inbuf)
        return NULL;

    fseek (infile,0,0);
    if (fread (size,4,1,infile)<1)
        return NULL;

    if (fread (inbuf, 1, inlength-4,infile)<(inlength-4))
        return NULL;

    memset (inbuf+inlength,255,40);

    outbuf=MEM_allocate_named(*size+40,"whole data buffer");
    decomp_file (inbuf,outbuf,*size);
    free(inbuf);
    return outbuf;
}

//-----------------------------------------------------------------------------

void init_filesystem()
{

    int     size;
    int     entrystart;
    int     i;
    if (!ZIPLOAD) return;                       // we don't need this

    databuffer = data_load ("inside.dat",&size);

    if (!databuffer)
        FAIL ("couldn't open data file 'inside.dat'\n");

    entrycounter = *(int *)(databuffer+size-4);
    entrystart = size-4-entrycounter*sizeof(entrystruct);
    entrylist = (entrystruct *)((char *)databuffer+entrystart);

}

//-----------------------------------------------------------------------------

void dummyfunc()
{

}

//-----------------------------------------------------------------------------

void *load_zip_file (char *fname)
{
    int i;
    int foo=-1;
    char name[80];

    file_io++;

    strcpy (name,fname);
    strlwr (name);

    for (i=0; i<strlen(name); i++)
        if (name[i]=='\\') name[i]='/';

    for (i=0; i<entrycounter && foo==-1; i++)
        if (!strcmp(name,entrylist[i].name))
            foo = i;

    if (foo==-1)
        FAIL ("cannot find file %s from inside.dat",name);

    file_io--;
    return ((char *)databuffer+entrylist[foo].offset);
}

//-----------------------------------------------------------------------------

void start_timer()
{
    demotimer = 0;
    timer = 0;
    framecounter = 0;
    frames_blitted=0;
}

//-----------------------------------------------------------------------------

void FAIL(char *format, ...)
{
    va_list argptr;

    va_start (argptr, format);
    vsprintf (errmsg, format, argptr);
    va_end (argptr);

    exit(-1);
}

//-----------------------------------------------------------------------------

void set_base_palette (char *pal)
{
    int i,j;

    for (i=0; i<768; i++)
    {
        j = pal[i];
        if (j>63) j=63;
        if (j<0)  j=0;
        base_palette[i] = j;
    }

    set_fade (fade_level,fadecounter);
}

//-----------------------------------------------------------------------------

void negate_palette(int ticks)
{
    int i,j;

    for (i=0; i<768; i++)
    {
        j = 63-base_palette[i]&63;
        cur_palette[i]=j;
    }

    set_fade (1.0, ticks);
}

//-----------------------------------------------------------------------------
// level: 0 == black, 1.0 == as base_palette, above 1.0 == brighter
//-----------------------------------------------------------------------------

void flash (int addition, int ticks)
{
    int i,j;

    for (i=0; i<768; i++)
    {
        j = base_palette[i]+addition;
        if (j<0) j=0; else if (j>63) j = 63;
        cur_palette[i] = j;
    }

    set_fade (1.0,ticks);
}

//-----------------------------------------------------------------------------

void fade_out()
{
    set_fade (0.0,40);
}

//-----------------------------------------------------------------------------

void fade_white()
{
    set_fade (100.0,0);
}

//-----------------------------------------------------------------------------

void negative()
{
    negate_palette(20);

}

//-----------------------------------------------------------------------------

void strobo()
{
    flash (63,15);
}

//-----------------------------------------------------------------------------

void set_fade (float level, int ticks)
{
    int i;
    float ticks_1;

    if (ticks<=0)
        ticks = 1;

    ticks_1 = 1.0/ticks;

    for (i=0; i<768; i++)
    {
        fpalette[i]=cur_palette[i];
        fpalette_add[i]=((level*base_palette[i])-fpalette[i])*ticks_1;
    }

    fade_level = level;
    fadecounter = ticks;
}

//-----------------------------------------------------------------------------

void fade()
{
    int i;
    if (fadecounter<=0) return;
    fadecounter--;

    for (i=0; i<768; i++)
    {
        fpalette[i]+=fpalette_add[i];

        if (fpalette[i]<0)  fpalette[i]  = 0.0;
        if (fpalette[i]>63) fpalette[i] = 63.0;
        cur_palette[i]=fpalette[i];
    }

    VGA_set_palette(cur_palette);
}

//-----------------------------------------------------------------------------
// this is going to change
//-----------------------------------------------------------------------------

void *load_file (char *name)
{
    void *p;
    FILE *f;

    if (ZIPLOAD)
    {
        p = load_zip_file(name);
        return p;
    }

    file_io++;
    p = FILE_allocate (name);

    if (!p)
        FAIL ("File not found <%s>\n",name);

    if (DEBUG)
    {
        f = fopen ("inside.lst","a+t");
        fprintf (f,"%s\n",name);
        fclose(f);
    }

    file_io--;

    return (p);
}


//-----------------------------------------------------------------------------

void blit_screen(char *source)
{
    int y;
    char *dest;
    int x;

    dest   = VGA_screen+VGA_ystart*VGA_xwidth+VGA_xstart;
    source = source+VGA_ystart*VGA_xwidth+VGA_xstart;

    x = VGA_xstop;
    if (x>VGA_xwidth) x = VGA_xwidth;
    x = x-VGA_xstart;

    for (y=VGA_ystart; y<VGA_ystop; y++,dest+=VGA_xwidth,source+=VGA_xwidth)
        MEM_copy (dest,source,x);

}

//-----------------------------------------------------------------------------

void demoirq()
{
    static int re_entrance = 0;

    if (cli)
        return;

    timer++;
    demotimer++;

    SND_irq_play();

    if (re_entrance)
        return;

    re_entrance++;

    if (!file_io)
    {
        if (!VRI_phase_now)
        {
            framecounter++;
            fade();
            if (draw_status==FRAME_READY)
            {
                draw_status=FRAME_BLITTING;
                blit_screen(buffer2);
                frames_blitted++;
                draw_status=FRAME_WAITING;
            }

            if (demo_irq)
                demo_irq();
        }


    }

    re_entrance--;

}

//-----------------------------------------------------------------------------
// initializes the whole thing
//-----------------------------------------------------------------------------

void initialize()
{
    FILE *f;

    sprintf (errmsg,"INSIDE by CNCD - please see file 'readme.txt' for more information\n");

    origmem = memfree();

    MEM_init (2500);

    if (!ZIPLOAD)
    {
        f = fopen("inside.lst","wt");
        fclose(f);
    }

    MEM_clear_allocs = 1;
    MEM_debug = 1;
    file_io = 0;

    frames_blitted = 0;
    framecounter =0;

    inside_tag = MEM_get_unused_tag();
    MEM_set_tag (inside_tag);

    init_filesystem();

    VGA_set_viewport (320,200,0,0,320,200);

    buffer1      = MEM_allocate_named(VGA_xwidth*VGA_yheight,"screen buffer 1");
    buffer2      = MEM_allocate_named(VGA_xwidth*VGA_yheight,"screen buffer 2");
    VGA_buffer   = buffer1;

    base_palette = MEM_allocate_named (768,"base palette");
    cur_palette  = MEM_allocate_named (768,"current palette");
    fpalette     = MEM_allocate_named (768*sizeof(float),"fl. point palette");
    fpalette_add = MEM_allocate_named (768*sizeof(float),"fl. point palette adders");
    irqstack     = MEM_allocate_named(65536,"IRQ stack");

    if (origmem<5500000)
        FAIL ("Inside requires approx. 5500 kB of runtime memory in order to work.\n"\
              "You currently have only %d kB free for the demo. If you're running\n"\
              "on an 8 Mb system, please remove memory-consuming TSRs and make your\n"\
              "smartdrive buffer smaller.\n",origmem/1024);


    init_fonts();

    SR_init();                                  // init surrender

    demo_irq    = NULL;
    demo_loop   = NULL;
    draw_status = FRAME_WAITING;
    next_event  = 0;
    VRI_func    = NULL;
    fadecounter = 0;


    IRQ_init (irqstack+63000);
    VRI_func = NULL;
    KBD_hook ();
    VRI_hook (4);

    VGA_set_mode (0x13);


    intro_load();
    logo_load();
    credit_load();
    flight_load();
    temple_load();
    nigga_fetch_1();
    nigga_fetch_2();
    nigga_fetch_3();
    nigga_fetch_4();
    water_load();
    flower_load();
    nigga_load();
    twirl_load();

    SND_init();
    SND_set_sync (VRI_synctime);
    VRI_func  = &demoirq;
    start_timer();

}

//-----------------------------------------------------------------------------

int already_shut = 0;


void shutdown()
{
    int i,memleft;

    if (already_shut) exit;

    already_shut = 1;

    memleft = origmem-memfree();

    VRI_func    = NULL;
    demo_irq    = NULL;
    demo_loop   = NULL;
    draw_status = FRAME_WAITING;

    for (i=0; i<768; i++)
        cur_palette[i]=0;

    VGA_set_palette(cur_palette);

    VGA_set_mode(0x3);
    VRI_free();
    KBD_free();
    if (DEBUG)
        MEM_file_dump("inside.dmp");
    SND_kill_background_music();

    if (DEBUG)
        printf ("memory used %d\n",memleft);

    printf("%s\n", errmsg);
}

//-----------------------------------------------------------------------------

void set_demo_irq (void *func())
{
    demo_irq = func;
    demotimer = 0;
}

//-----------------------------------------------------------------------------

void set_demo_loop (void *func())
{
    demo_loop = func;
    demotimer = 0;
}

//-----------------------------------------------------------------------------

void flip_page()
{
    char *t;

    t = buffer1;
    buffer1=buffer2;
    buffer2=t;

    VGA_buffer = buffer1;

    draw_status = FRAME_READY;
}

//-----------------------------------------------------------------------------

int check_events()
{
    int curposition;
    int eventposition;
    int foo;

    foo = 0;

    curposition   = ampGetPattern()*64 + ampGetRow();
    eventposition = eventlist[next_event].pattern*64 + eventlist[next_event].position;

    if (curposition >= eventposition)
    {
        eventlist[next_event].func();        // execute event function
        next_event++;
        foo++;
    }

    if (!eventlist[next_event].func)
        force_exit = 1;

    if (KBD_buffer[KEY_ESC])
        force_exit = 1;

    return foo;

}

//-----------------------------------------------------------------------------

void show_info()
{
    if (!DEBUG) return;
    write_text (3,10,"%02d:%02d",ampGetPattern(),ampGetRow());
    write_text (3,170,"%05d kB",MEM_used/1024);
}

//-----------------------------------------------------------------------------

void take_screenshot()
{
    FILE    *F;
    char    shotname[80];
    int     shotnum = 0;

    file_io++;

    F = (void *)12345;

    while(F)
	{
		sprintf(shotname, "shot%u.tga", shotnum);
		F = fopen(shotname, "rb");
        if(F) fclose(F);
		shotnum++;
	}

    TGA_save_raw8 (shotname, buffer1, base_palette,320,200);

    file_io--;

}

//-----------------------------------------------------------------------------

void run_demo()
{
    while (!force_exit && !KBD_buffer[KEY_ESC])
    {
        if (demo_loop)
            demo_loop();

        while (!force_exit && check_events());

        if (KBD_buffer[KEY_S])
            take_screenshot();
    }
}

//-----------------------------------------------------------------------------

void init_fonts()
{
    int i;

    if (!DEBUG) return;

    textgfx   = FILE_allocate ("data/fonakki.raw");
    textplace = FILE_allocate ("data/fonakki.siz");

	for(i=0;i<strlen(textcharlist);i++)
	{
		textchars[textcharlist[i]]=textgfx+i*17*21;
        textwidth[textcharlist[i]]=textplace[i]+2;
	}

    textwidth[' ']=3;
}

//-----------------------------------------------------------------------------

void write_text ( int x, int y, char *format, ... )
{
    static int i,scy,num;
    static char outstr[256];
	static va_list argptr;
    char *bitmap;
    char *drawbuf;

	va_start (argptr, format);
	vsprintf (outstr, format, argptr);
	va_end (argptr);

    drawbuf = VGA_buffer+x+y*VGA_xwidth;

	for(i=0;i<strlen(outstr);i++)
	{
	   num = outstr[i];
	   bitmap=textchars[num];

	   scy = 0;

       for(y=0;y<21;y++,bitmap+=17,scy+=VGA_xwidth)
	   {
            if (scy>0 && scy<VGA_xwidth*(VGA_yheight-21))

			for(x=0; x<textwidth[num]; x++)
			 if(bitmap[x])
                drawbuf[x+scy]=100;

	   }

	  drawbuf+=textwidth[num]+3;

    }

}
//-----------------------------------------------------------------------------

