#ifndef __TEXTURE_H
#define __TEXTURE_H

#include "types.h"

typedef struct texture
{
	int	bitsperpixel;
	int 	width,height;
	int32	*image;
	int	*clut;
	int	addr,clutaddr;
	int64	TW,TH;
}texture;

void texture_cleartexturemem(int color);
void texture_init(texture *tex);
void texture_upload(texture *tex, int addr);
void texture_load(texture *tex, char *file);
void texture_loadalpha(texture *tex, char *file);
int64 texture_TEX1(texture* tex);
int64 texture_TEX2(texture* tex);
int64 texture_TEX3(texture* tex);
int texture_allocinit(int start);
int texture_allocvideomem(int size);
void texture_allocupload(texture *tex);

#endif