#ifndef __DMA_H
#define __DMA_H

#include "hwreg.h"

void FlushCache(int);
inline static void dma02_wait(){while(D2_CHCR&0x100);}
inline static void dma01_wait(){while(D1_CHCR&0x100);}

inline static dma02_send(volatile void *start, int32 size, int32 chcr)
{
	D2_MADR=(int32)start;
	D2_QWC=size;
	D2_CHCR=chcr;
}

void dmareset();

//macros for simple chain mode using dma02

extern int128 *dma_chainmem;
extern int128 *dma_chainnext;

inline static void dma_beginchain(void *mem)
{
	dma_chainmem=mem;
	dma_chainnext=dma_chainmem;
}

inline static void dma_endchain()
{
	dma_chainnext->lo=0x70000000;
}

inline static dma_sendchain()
{
	D2_MADR=(int32)dma_chainmem;
	D2_TADR=(int32)dma_chainmem;
	D2_QWC=0;
	D2_CHCR=0x105;//+64;
}

#define dma_begingp(){gif_begin(dma_chainnext+1);}

#define dma_endgp(){dma_chainnext->lo=0x10000000+gif_length;dma_chainnext+=gif_length+1;}

#endif