#include <windows.h>
#include <gl/gl.h>
#include "ijl.h"


#include "fxBack5.hpp"



fxBack5::fxBack5()
{
}


bool fxBack5::Init(const Loader* l)
{
	JPEG_CORE_PROPERTIES jcprops1;
	BYTE pixel_buff [512*512*3];

	ijlInit (&jcprops1);

	jcprops1.JPGFile = "data/funcode.jpg";

	jcprops1.DIBWidth = 512;
	jcprops1.DIBHeight = 512;
	jcprops1.DIBChannels = 3;
	jcprops1.DIBColor = IJL_RGB;
	jcprops1.DIBPadBytes = 0;
	jcprops1.DIBBytes = pixel_buff;

    ijlRead (&jcprops1, IJL_JFILE_READWHOLEIMAGE);
	ijlFree (&jcprops1);	

	glGenTextures(1 , &back1);
	glBindTexture(GL_TEXTURE_2D, back1);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 512, 512, 0, GL_RGB, GL_UNSIGNED_BYTE, pixel_buff);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

	return true;
}


void fxBack5::Render(float time, const Demo *env)
{
	glEnable( GL_TEXTURE_2D );
	glDisable( GL_BLEND );
	glDisable( GL_LIGHTING );
	glDisable( GL_DEPTH_TEST );

	glLoadIdentity();
	glTranslatef( 0.0f, 0.0f, -3.0f );

	glColor4ub( 255, 255, 255 , 128);
	glBindTexture(GL_TEXTURE_2D, back1);

	glBegin( GL_QUADS );
		glTexCoord2f( 0.0f , 0.0f );
		glVertex3f( -1.68f , 1.25f , 0.0f );
		glTexCoord2f( 1.0f , 0.0f );
		glVertex3f( 1.68f , 1.25f , 0.0f );
		glTexCoord2f( 1.0f , 1.0f );
		glVertex3f( 1.68f , -1.25f , 0.0f );
		glTexCoord2f( 0.0f , 1.0f );
		glVertex3f( -1.68f , -1.25f , 0.0f );
	glEnd();

	glEnable( GL_DEPTH_TEST );
}


void fxBack5::Push(ud type, float value)
{
}


void fxBack5::DeInit()
{
	glDeleteTextures( 1 , &back1 );
}


fxBack5::~fxBack5()
{
}

