
// conceptual.cpp
// main function originally for the ethereal borntro
// written by pompy / ethereal

#include "demoengine.hpp"
#include "loader.hpp"


// Include FX headers here !

#include "fxFlag.hpp"
#include "fxMetaballs.hpp"
#include "fxWater.hpp"
#include "fxBack2.hpp"
#include "fxBackground.hpp"
#include "fxMistirassoni.hpp"
#include "fxSmousse.hpp"
#include "fxSkeutuveu.hpp"
#include "fxBack3.hpp"
#include "fxBack4.hpp"
#include "fxBack5.hpp"
#include "fxBack6.hpp"
#include "fxFlashyboris.hpp"
#include "fxBack7.hpp"
#include "fxWater1.hpp"
#include "fxWater2.hpp"



extern Demo* environement;



int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) 
{

	if(showStartDlg(hInstance) == FALSE) return 0;

	/*
	**	Warning : MFC uses the GWL_USERDATA field of the window class.
	*/

	Demo* Conceptual;
	Conceptual = new OpenGLDemo(hInstance);

	Loader data("conceptual.dat", NULL, Conceptual);

	Conceptual->SetLoader( &data );
	
	data.SelectDemo(1); 

	// The Loader class should know whenever the music is mp3 or module.
	// It should select the player by itself. */

	Player *p = new ModPlayer();

	Conceptual->SetPlayer(p);

	Conceptual->music_player->Open("data/CONCEPT.xm");

	Conceptual->Init("Conceptual", data); 

	// Main application loop.

	while ( !Conceptual->done )
	{
		Conceptual->DoTheDemo();
	}

	delete Conceptual;

	return 0;
} // WinMain

#define FX_BACK1 16
#define FX_BACK2 17
//#define FX_SKEUTUVEU 43
//#define FX_FLASHYBORIS 50

//-----------------------------------------------------------------
// Here the implementation of the Loading based on FX identifiers.
//-----------------------------------------------------------------

void Demo::AddFX(int ID, unsigned int start, unsigned int end, int slot)
{

	if ( ID == FX_METABALLS )
		AddFX( new fxMetaballs(), start, end, slot );

	if ( ID == FX_FLAG )
		AddFX( new fxFlag(), start, end, slot );

	if ( ID == FX_WATER )
		AddFX( new fxWater(), start, end, slot );

	if ( ID == FX_MISTIRASSONI )
		AddFX( new fxMistirassoni(), start, end, slot );

	if ( ID == FX_SMOUSSE )
		AddFX( new fxSmousse(), start, end, slot );

	if ( ID == FX_BACK1 )
		AddFX( new fxBack1(), start, end, slot );

	if ( ID == FX_BACK2 )
		AddFX( new fxBack2(), start, end, slot );

	if ( ID == FX_SKEUTUVEU )
		AddFX( new fxSkeutuveu(), start, end, slot );

	if ( ID == FX_BACK3 )
		AddFX( new fxBack3(), start, end, slot );
	
	if ( ID == FX_BACK4 )
		AddFX( new fxBack4(), start, end, slot );

	if ( ID == FX_BACK5 )
		AddFX( new fxBack5(), start, end, slot );
	
	if ( ID == FX_BACK6 )
		AddFX( new fxBack6(), start, end, slot );

	if ( ID == FX_FLASHYBORIS )
		AddFX( new fxFlashyboris(), start, end, slot );

	if ( ID == FX_BACK7 )
		AddFX( new fxBack7(), start, end, slot );

	if ( ID == FX_WATER1 )
		AddFX( new fxWater1(), start, end, slot );

	if ( ID == FX_WATER2 )
		AddFX( new fxWater2(), start, end, slot );

}


#define SEQ1   20200
#define SEQ2   47500
#define SEQ3   73000
#define SEQ4   74333
#define SEQ41  81555
#define SEQ42  88777
#define SEQ5   96000
#define SEQ51 104666
#define SEQ52 110332
#define SEQ6  115500
#define SEQ7  135000
#define SEQ8  138000
#define SEQ9  170000	// White flash
#define SEQ10 183000	// White flash
//#define SEQ11 


/*
**
**	The timeline was implemented here.
**
*/


void Demo::InitEvents()
{
	// Here all the event constructors shall be called...
	// The events must be sorted by the event taking effect the earlier
	// to the last event in the demo..

	
	events[0]  = new EventFX( this, 0, SEQ1, 5, FX_METABALLS );
	events[1]  = new EventFX( this, 0, SEQ1, 1, FX_BACK3 );
//	events[0]  = new EventFX( this, 0, SEQ1, 4, FX_SMOUSSE );
//	events[1]  = new EventFX( this, 0, SEQ1, 1, FX_BACK6 );
//	events[0]  = new EventFX( this, 0, SEQ1, 5, FX_MISTIRASSONI );
//	events[1]  = new EventFX( this, 0, SEQ1, 2, FX_BACK1 );
	
	events[2]  = new EventFX( this, SEQ1, SEQ2, 6, FX_SKEUTUVEU );
	events[3]  = new EventFX( this, SEQ1, SEQ2, 2, FX_BACK5 );
	
	events[4]  = new EventFX( this, SEQ2, SEQ3, 3, FX_FLASHYBORIS );
	events[5]  = new EventFX( this, SEQ2, SEQ3, 1, FX_BACK7 );
	
	events[6]  = new EventFX( this, SEQ3, SEQ4, 2, FX_BACK4 );

	events[7]  = new EventFX( this, SEQ4, SEQ6, 1, FX_BACK2 );
	events[8]  = new EventFX( this, SEQ4, SEQ41, 3, FX_WATER );
	events[9]  = new EventFX( this, SEQ41, SEQ42, 5, FX_WATER1 );
	events[10]  = new EventFX( this, SEQ42, SEQ5, 4, FX_WATER2 );
	events[11]  = new EventFX( this, SEQ5, SEQ51, 6, FX_WATER );
	events[12]  = new EventFX( this, SEQ51, SEQ52, 7, FX_WATER1 );
	events[13]  = new EventFX( this, SEQ52, SEQ6, 3, FX_WATER2 );

	events[14]  = new EventFX( this, SEQ6, SEQ8, 5, FX_MISTIRASSONI );
	events[15]  = new EventFX( this, SEQ6, SEQ8, 2, FX_BACK1 );
	
	events[16]  = new EventFX( this, SEQ8, SEQ10, 1, FX_BACK6 );
	events[17]  = new EventFX( this, SEQ8, SEQ10, 3,  FX_SMOUSSE);

}


/*
**	Here the sync...
*/


void BassSync(FMUSIC_MODULE *mod,unsigned char param)
{
	if (environement != NULL)
	{
		for (int i=0; i<MAX_SLOTS; i++)
		{
			if ( (environement->slots[i] != NULL) && (environement->slots[i]->fx != NULL) )
				environement->slots[i]->fx->Push( PUSH_BASS, 1.0f );
		}
	}
}



void PercSync(FMUSIC_MODULE *mod,unsigned char param)
{
	if (environement != NULL)
	{
		for (int i=0; i<MAX_SLOTS; i++)
		{
			if ( (environement->slots[i] != NULL) && (environement->slots[i]->fx != NULL) )
				environement->slots[i]->fx->Push( PUSH_PERC, 1.0f );
		}
	}
}



void BlehSync(FMUSIC_MODULE *mod,unsigned char param)
{
	if (environement != NULL)
	{
		for (int i=0; i<MAX_SLOTS; i++)
		{
			if ( (environement->slots[i] != NULL) && (environement->slots[i]->fx != NULL) )
				environement->slots[i]->fx->Push( PUSH_BLEH, 1.0f );
		}
	}
}


