Unit V64SEND;

// Version 1.0
//
// V64 Send/Receive Sources 1.0 by Hartec
// ======================================
//
// This source is partly based uppon the gdsend.pas
// and also talk64 and v64io sources were a good help 
// when writeing this unit. A BGI Thank you to the
// authors =)
//
// This sources has all functions that are essential
// when communicating with the doctor.
//
// I have also inculded calls of various bios functions
// like print ,clear screen and backup.
// I am sorry I have not included all functinos yet but
// I will do that very soon when I have time again and
// when I have remove some little bugs ;) Forgive me !
//
// v1.0 : first release has most functions included.
//
// Next : I will try to put in more(ALL) functions
//        Perhaps some comments on the code ;)
//
//  Feel free to contact me at Hartec@dextrose.com
//
// (c) Hartec 1998

Interface

type
  TSendname       = String[11];

var
    PortBase   : Word;

const
      LPT1            : Word = $378;
      LPT2            : Word = $278;
      LPT3            : Word = $3B8;
      PORT_STROBE            = 32000;
      PORT_TIMEOUT           = 32000;
      BLOCK_SIZE             = 32768;
      GD_READ_COMMAND        = 'GD6R';
      GD_WRITE_COMMAND       = 'GD6W';
      GD_PRINT_COMMAND       = 'GD6EP';
      GD_CALL_COMMAND        = 'GD6EC';
      GD_CALL_CLRSCR         = $FFE3;
      GD_CALL_NAME           = $FFEC;

procedure SetPort(Value : Word);
procedure PortOut(IOAddr : WORD; Data : BYTE);
function PortIn(IOAddr : WORD) : BYTE;
function PortWaitFor(IOAddr : Word; Data : Byte;Wait : Longint) : boolean;
function PortWaitForNot(IOAddr : Word; Data : Byte;Wait : Longint) : boolean;
function PortSendBlock(aBlock : Array of Byte; Size : LongInt) : boolean;
function PortRecvBlock(var aBlock : Array of Byte; Size : LongInt) : boolean;
function InitPort : boolean;
function PortCheckSync : boolean;
function SendSaveData(Buf : Array of Byte) : boolean;
function RecvSaveData(var Buf : array of byte) : boolean;
function SendHeader(FileSize : Longint;St : String) : boolean;
function PortSendInteger(aInt : Longint) : boolean;
function PortSendString(aString : String) : boolean;
function V64Call(address : word) : boolean;
function V64ClrScr : boolean;
function V64Backup(Size : integer) : boolean;
function V64Name : boolean;
function V64Print(line,column : byte;St : string) : boolean;
function FormatFileName(aString : String) : TSendNAme;

Implementation

uses SysUtils;

procedure SetPort(Value : Word);
begin
  PortBase := Value;
end;

function PortIn(IOAddr : WORD) : BYTE; //assembler;
begin
asm
    mov dx,IOAddr
    in  al,dx
    mov Result,al
end;
end;

procedure PortOut(IOAddr : WORD; Data : BYTE);// assembler;
begin
asm
    mov  dx,IOAddr
    mov  al,Data
    out  dx,al
end;
end;

Function PortWaitFor(IOAddr : Word; Data : Byte;Wait : Longint) : boolean;
var Ticks  : Integer;
    InByte : Byte;
begin
  if Wait <> 0 then Ticks := Wait
                else Ticks := 1;
  While Ticks > 0 do
  begin
    InByte := PortIn(IOAddr);
    if (InByte and Data) <> 0 then
    begin
     Result := True;
     Exit;
    end;
    if Wait <> 0 then  Dec(Ticks);
  end;
  Result := False;
end;

function PortWaitForNot(IOAddr : Word; Data : Byte;Wait : Longint) : Boolean;
var Ticks  : Integer;
    InByte : Byte;
begin
  if Wait <> 0 then Ticks := Wait
                else Ticks := 1;
  While Ticks > 0 do
  begin
    InByte := PortIn(IOAddr);
    if (InByte and Data) = 0 then
    begin
     Result := True;
     Exit;
    end;
    if Wait <> 0 then Dec(Ticks);
  end;
  Result := False;
end;

function FormatFileName(aString : String) : TSendNAme;
var aPos : Integer;
begin
  aString := UpperCase(ExtractFileName(aString));
  aPos    := Pos('.',aString);
  if aPos <> 0 then Result := Copy(aString,1,aPos-1) {Copy filename}
                else Result := aString;
  While Length(Result) < 8 do  Result := Result + ' ';
  if aPos <> 0 then  Result := Result + Copy(aString,aPos+1,12);
  While Length(Result) < 11 do Result := Result + ' ';
end;

function PortSendBlock(aBlock : Array of Byte; Size : LongInt) : boolean;
var FirstByte : Boolean;
    x         : LongInt;
begin
  FirstByte := not ((PortIn(PortBase+2) and 1) <> 0);
  x         := 0;
  While x < Size do
  begin
    if Firstbyte then
      begin {Firstbyte}
        if not PortWaitForNot(PortBase+2,2,PORT_STROBE) then
        begin
         Result := False;
         Exit;
        end;
        PortOut(PortBase,aBlock[x]);
        PortOut(PortBase+2,5);
        Inc(x);
        FirstByte := false;
      end
    else
      begin {Otherbyte}
        if not PortWaitFor(PortBase+2,2,PORT_STROBE) then
        begin
         Result := False;
         Exit;
        end;
        PortOut(PortBase,aBlock[x]);
        PortOut(PortBase+2,4);
        Inc(x);
        FirstByte := true;
      end;
  end;
   Result := True;
end;

function PortRecvBlock(var aBlock : Array of Byte ; Size : LongInt) : boolean;
var x         : LongInt;
    LowNibble : Byte;
    HiNibble  : Byte;
begin
  PortOut(PortBase,$80);
  for x := 0 to Size-1 do
  begin
    LowNibble := $0;
    HiNibble  := $0;

    if not PortWaitFor(PortBase+1,$80,PORT_TIMEOUT) then
    begin
     Result := False;
     Exit;
    end;
    LowNibble := Portin(PortBase+1);
    LowNibble := ((LowNibble shr 3) and $0F);

    PortOut(PortBase,$0);
    if not PortWaitForNot(PortBase+1,$80,PORT_TIMEOUT) then
    begin
     Result := False;
     Exit;
    end;
    HiNibble := PortIN(PortBase+1);
    HiNibble := ((HiNibble shl 1) and $F0);

    aBlock[x] := (HiNibble or LowNibble);
    PortOut(PortBase,$80);
  end;
  Result := True;
end;

function InitPort : boolean;
begin
  PortOut(PortBase,0);
  PortOut(PortBase+2,4);
  if not PortWaitForNot(PortBase+2,8,PORT_TIMEOUT) then
  begin
   Result := False;
   Exit;
  end;
  PortOut(PortBase,$AA);
  PortOut(PortBase+2,0);
  if not PortWaitFor(PortBase+2,8,PORT_TIMEOUT) then
  begin
   Result := False;
   Exit;
  end;
  PortOut(PortBase+2,4);
  if not PortWaitForNot(PortBase+2,8,PORT_TIMEOUT) then
  begin
   Result := False;
   Exit;
  end;
  PortOut(PortBase,$55);
  PortOut(PortBase+2,0);
  if not PortWaitFor(PortBase+2,8,PORT_TIMEOUT) then
  begin
   Result := False;
   Exit;
  end;
  PortOut(PortBase+2,4);
  if not PortWaitForNot(PortBase+2,8,PORT_TIMEOUT) then
  begin
   Result := False;
   Exit;
  end;
  Result := True;
end;

function PortSendString(aString : String) : boolean;
var Chars : Array[0..255] of char;
    Bytes : Array[0..255] of Byte absolute Chars;
begin
  StrPCopy(Chars,aString);
  Result := PortSendBlock(Bytes,Length(aString));
end;

function PortCheckSync : boolean;
var Ticks  : Integer;
    InByte : Byte;
begin
  if PORT_TIMEOUT <> 0 then Ticks := PORT_TIMEOUT
                        else Ticks := 1;
  While Ticks > 0 do
  begin
    InByte := PortIn(PortBase+2);
    if (((InByte and 3)=3) or ((InByte and 3)=0)) then Break;
    if PORT_TIMEOUT <> 0 then Dec(Ticks);
  end;
  if Ticks = 0 then
  begin
   Result := False;
   Exit;
  end;
  PortOut(PortBase,0);
  if not PortWaitForNot(PortBase+1,$80,PORT_TIMEOUT) then
  begin
   Result := False;
   Exit;
  end;
  Result := True;
end;

function PortSendInteger(aInt : Longint) : boolean;
var Bytes : Array[0..3] of Byte absolute aInt;
begin
  Result := PortSendBlock(Bytes,4);
end;


function SendHeader(FileSize : Longint;St : String) : boolean;
var FileName : String[11];
begin
  Filename := St;
  if not PortSendInteger(FileSize) then
  Begin
   Result := False;
   Exit;
  end;
  While Length(FileName) < 11 do  FileName := FileName+' ';
  if not PortSendString(FileName) then
  begin
   Result := False;
   Exit;
  end;
  Result := True;
end;

function SendSaveData(Buf : Array of Byte) : boolean;
begin
  if not InitPort then
  begin
   Result := False;
   Exit;
  end;
  if not PortSendString(GD_READ_COMMAND+Chr(1)) then
  begin
   Result := False;
   Exit;
  end;
  if not SendHeader(256*512,'PC-RAM') then
  begin
   Result := False;
   Exit;
  end;
  if not PortSendBlock(Buf,256*512) then
  begin
   Result := False;
   Exit;
  end;
  Result := True;
end;


function RecvSaveData(var Buf : array of byte) : boolean;

var RecvName : array[0..11] of char;
    TempData : array[0..15] of byte;
begin
 StrPCopy(RecvName,FormatFileName('PC-RAM'));
 if not InitPort then
 begin
  Result := False;
  Exit;
 end;
 if not PortSendString(GD_WRITE_COMMAND) then
 begin
  Result := False;
  Exit;
 end;
 if not PortSendString(RecvName) then
 begin
  Result := False;
  Exit;
 end;
 if not PortCheckSync then
 begin
  Result := False;
  Exit;
 end;
 if not PortRecvBlock(TempData,1) then
 begin
  Result := False;
  Exit;
 end;
 if not PortRecvBlock(TempData,15) then
 begin
  Result := False;
  Exit;
 end;
 if not PortRecvBlock(Buf,256*512) then
 begin
  Result := False;
  Exit;
 end;
 Result := True;
end;


function V64Call(address : word) : boolean;
var    buffer2    : array[0..1] of byte;// absolute address;
begin
  buffer2[0] := address shr 8;
  buffer2[1] := address and $ff;
  if not InitPort then
  begin
   Result := False;
   Exit;
  end;
  if not PortSendString(GD_CALL_COMMAND) then
  begin
   Result := False;
   Exit;
  end;
  if not PortSendBlock(buffer2,2) then
  begin
   Result := False;
   Exit;
  end;
  if not PortCheckSync then
  begin
   Result := False;
   Exit;
  end;
  if not PortRecvBlock(buffer2,1) then
  begin
   Result := False;
   Exit;
  end;
  Result := True;
end;

function V64ClrScr : boolean;
begin
 Result := V64Call(GD_CALL_CLRSCR);
end;

function V64Name : boolean;
begin
 Result := V64Call(GD_CALL_NAME);
end;

function V64Backup(Size : integer) : boolean;
begin
 case Size of
       64  : Result := V64Call($FE00);
      128  : Result := V64Call($FE07);
      192  : Result := V64Call($FE0E);
      256  : Result := V64Call($FE15);
 end;
end;

function V64Print(line,column : byte;St : string) : boolean;
var   buffer2 : array[0..1] of byte;
begin
  buffer2[0] := line;  buffer2[1] := column;
  if not InitPort then
  begin
   Result := False;
   Exit;
  end;
  if not PortSendString(GD_PRINT_COMMAND) then
  begin
   Result := False;
   Exit;
  end;
  if not PortSendBlock(buffer2,2) then
  begin
   Result := False;
   Exit;
  end;
  if not PortCheckSync then
  begin
   Result := False;
   Exit;
  end;
  if not PortRecvBlock(buffer2,1) then
  begin
   Result := False;
   Exit;
  end;
  if not PortSendString(ST+ Chr($FF)) then
  begin
   Result := False;
   Exit;
  end;
  Result := True;
end;

begin
 SetPort(LPT1);
end.