
#include "despair.h"
#include "stext.h"
#include "writer.h"

#include <tcscr.h>
#include <llkey.h>
#include <llscreen.h>
#include <text.h>

#define _VSBASE_H_

#include "vspace.h"

#include <stdio.h>

// -------------------------

typedef dword TPixel;
static int BPP = 32;

#define pal ScrapPal
static byte (*pix)[256];

#define NTAB (VSTM_ANLEV)

#define desttab (VSTM_AlphaTbl[0])

static dword BeginTime;

#define NGREETS 20

static byte *GreetTex[NGREETS];
static dword GreetPal[NGREETS][256];
static int   GreetW[NGREETS];
static int   GreetH[NGREETS];
static int   NumGreet = 0;
static int   GreetScan = -240;

void DrawGrScan(TPixel *dest, int n, byte *tex, int x);
#pragma aux DrawGrScan parm [EDI] [ECX] [ESI] [EBX] modify [EAX EDX] = \
"               MOV     EAX,[NumGreet]          " \
"               SHL     EAX,10                  " \
"               MOV     EDX,OFFSET GreetPal     " \
"               ADD     EDX,EAX                 " \
"               LEA     EDI,[EDI+EBX*4]         " \
"   @@lp:        XOR    EAX,EAX                 " \
"                MOV    EBX,[EDI]               " \
"                MOV    AL,[ESI]                " \
"                AND    EBX,0x3FCFF3FC          " \
"                ADD    EDI,4                   " \
"                INC    ESI                     " \
"                MOV    EAX,[EDX+EAX*4]         " \
"                AND    EAX,0x3FCFF3FC          " \
"                ADD    EAX,EBX                 " \
"                TEST   EAX,0xC0300C00          " \
"                JZ     @@c3                    " \
"                TEST   EAX,0xC0000000          " \
"                JZ     @@c1                    " \
"                 OR    EAX,0x3FC00000          " \
"             @@c1:                             " \
"                TEST   EAX,0x00300000          " \
"                JZ     @@c2                    " \
"                 OR    EAX,0x000FF000          " \
"             @@c2:                             " \
"                TEST   EAX,0x00000C00          " \
"                JZ     @@c3                    " \
"                 OR    EAX,0x000003FC          " \
"             @@c3:                             " \
"                DEC    ECX                     " \
"                MOV    [EDI-4],EAX             " \
"                JNZ    @@lp                    " \


/*
{
    int i;

    for (i = 0; i < n; i++, x++)
        dest[x] = TCS_AddPixel(dest[x], GreetPal[NumGreet][tex[i]]);
}
*/

static void DrawGreet(int x, int y, byte *tex, int w, int h)
{
    int i;

    for (i = 0; i < h; i++, y++)
        if (y >= 0 && y < TCS_Height)
            DrawGrScan(&TCS_Screen[320*y], w, tex + w*i, x);
}


static void DrawScan(TPixel *dest, int n, byte *tex, TPixel *tab,
              sint32 u, sint32 u2, sint32 v, sint32 v2,
              sint32 a, sint32 a2, sint32 r, sint32 r2,
              sint32 g, sint32 g2, sint32 b, sint32 b2,
              bool dith) {
    sint32 ir, ig, ib, ia, iu, iv;

    r = FP8Mult(r, a);
    g = FP8Mult(g, a);
    b = FP8Mult(b, a);

    r2 = FP8Mult(r2, a2);
    g2 = FP8Mult(g2, a2);
    b2 = FP8Mult(b2, a2);

    a *= NTAB;
    a2 *= NTAB;

    ir = ((r2-r)/n);
    ig = ((g2-g)/n);
    ib = ((b2-b)/n);
    iv = ((v2-v)/n);
    iu = ((u2-u)/n);
    ia = ((a2-a)/n);

    VSTM_APos = a << 0;
    VSTM_RPos = r << 0;
    VSTM_GPos = g << 0;
    VSTM_BPos = b << 0;
    VSTM_UPos = u << 8;
    VSTM_VPos = v << 8;

    VSTM_AInc = ia << 0;
    VSTM_RInc = ir << 0;
    VSTM_GInc = ig << 0;
    VSTM_BInc = ib << 0;
    VSTM_UInc = iu << 8;
    VSTM_VInc = iv << 8;

    VSTM_Dither = dith;
    VSTM_TexturePtr = tex;
    VSTM_TextureMask = 0xFFFF;

    VSTM_DumpScan2000(dest, n);
}

static bool DoTmap32(dword time) {
    TPixel *p, *q;
    int i;
    float angle = (time-BeginTime)/2.0;
    float  r0 = (cos(0.012*angle+0.2)/2.4)+0.5,
           r1 = (cos(0.025*angle+1.7)/2.4)+0.5,
           r2 = (cos(0.010*angle+3.2)/2.4)+0.5,
           r3 = (cos(0.031*angle+0.9)/2.4)+0.5,
           g0 = (cos(0.013*angle+2.2)/2.4)+0.5,
           g1 = (cos(0.020*angle+9.0)/2.4)+0.5,
           g2 = (cos(0.014*angle+1.1)/2.4)+0.5,
           g3 = (cos(0.011*angle+3.3)/2.4)+0.5,
           b0 = (cos(0.018*angle+0.0)/2.4)+0.5,
           b1 = (cos(0.042*angle+2.2)/2.4)+0.5,
           b2 = (cos(0.009*angle+5.2)/2.4)+0.5,
           b3 = (cos(0.016*angle+1.0)/2.4)+0.5,
           a0 = (cos(0.032*angle+3.1)/2.4)+0.5,
           a1 = (cos(0.002*angle+0.3)/2.4)+0.5,
           a2 = (cos(0.022*angle+2.0)/2.4)+0.5,
           a3 = (cos(0.013*angle+0.2)/2.4)+0.5;

    sint32 u, v, du, dv;

    q = TCS_Screen;

    du =  (0.9*cos(0.005*angle)+1)*cos((2*sin(0.0033*angle)+0.005*angle))*65536/2 * 2;
    dv = ((0.9*cos(0.005*angle)+1)*sin((2*cos(0.0033*angle)+0.005*angle))*65536/2 * 2) * (6.0 / 5);

    u =  32768+4*256*8192*cos(0.0057*angle);
    v = (32768+4*256*8192*sin(0.004 *angle)) * (6.0 / 5);

#define TCS_SizeX TCS_Width
#define TCS_SizeY TCS_Height

    u += -TCS_SizeX*du + TCS_SizeY*dv;
    v += -TCS_SizeX*dv - TCS_SizeY*du;

    for (i = 0; i < TCS_SizeY; i+=1, q += TCS_SizeX) {
            // Initial/final values for a, r, g, b.
        float ri, gi, bi, ai, rf, gf, bf, af;
        ai = a0 + (a3 - a0)*i/TCS_SizeY;
        ri = r0 + (r3 - r0)*i/TCS_SizeY;
        gi = g0 + (g3 - g0)*i/TCS_SizeY;
        bi = b0 + (b3 - b0)*i/TCS_SizeY;
        af = a1 + (a2 - a1)*i/TCS_SizeY;
        rf = r1 + (r2 - r1)*i/TCS_SizeY;
        gf = g1 + (g2 - g1)*i/TCS_SizeY;
        bf = b1 + (b2 - b1)*i/TCS_SizeY;

        p = q;

        DrawScan(p, TCS_SizeX, pix, desttab,
                 u, u+TCS_SizeX/1*du,
                 v, v+TCS_SizeX/1*dv,
                 ai*65536, af*65536, ri*65536, rf*65536,
                 gi*65536, gf*65536, bi*65536, bf*65536,
                 (i>>0)&1);
        u -= dv;
        v += du;
    }

    {
        int gr;

        GreetScan = (time-BeginTime)/4 - 270;

#define GRHEIGHT 35
        gr = GreetScan / GRHEIGHT;
        gr--;
        for (; gr < NGREETS; gr++)
        {
            if (gr >= 0 && gr < NGREETS)
            {
                NumGreet = gr;
                if (gr & 1)
                {
                    DrawGreet((310 - GreetW[gr]), gr * GRHEIGHT - GreetScan, GreetTex[gr], GreetW[gr], GreetH[gr]);
                }
                else
                {
                    DrawGreet(10, 160 + GreetScan - gr * GRHEIGHT, GreetTex[gr], GreetW[gr], GreetH[gr]);
                }
            }
            if (gr * GRHEIGHT - GreetScan > 200)
                break;
        }
        GreetScan++;
    }

        // Antialias
    if (TCS_Bpp > 16) {
        for (i = (TCS_SizeY-1)*TCS_SizeX
          , p = TCS_Screen
          , q = TCS_Screen + TCS_SizeX;
         i > 0;
         i--, p++, q++)
        *p = (
              (*p & 0x3FCFF3FC) + (p[1] & 0x3FCFF3FC)
             +(*q & 0x3FCFF3FC) + (q[1] & 0x3FCFF3FC)
             ) >> 2;
        for (i = TCS_SizeY-1, p = TCS_Screen; i >= 0; i--) {
            *p = 0;
            p += TCS_SizeX;
        }
    }

//    DoText(time - BeginTime);
    DoWriter(time - BeginTime);

    TCS_Dump(TCS_Screen, 0, TCS_Height);

    return TRUE;
}

extern bool LoadTmap32(dword time) {
    int i, j;
    static byte gpal[NGREETS][768];

    LLS_SetMode(LLSM_DIRECT, LLS_VMode);   // Free the mem.

    REQUIRE( (pix = NEW(256*256)) != NULL);
    VSPIX_Load("GFX\\feedback.gif", pix, pal, NULL, NULL);

    for (i = 0; i < NGREETS; i++)
        REQUIRE( (GreetTex[i] = NEW(256*64)) != NULL);

    VSPIX_Load("GFX\\GREET\\gre.gif", GreetTex[ 0], gpal[ 0], &GreetW[ 0], &GreetH[ 0]);
    VSPIX_Load("GFX\\GREET\\ami.gif", GreetTex[ 1], gpal[ 1], &GreetW[ 1], &GreetH[ 1]);
    VSPIX_Load("GFX\\GREET\\cap.gif", GreetTex[ 2], gpal[ 2], &GreetW[ 2], &GreetH[ 2]);
    VSPIX_Load("GFX\\GREET\\cen.gif", GreetTex[ 3], gpal[ 3], &GreetW[ 3], &GreetH[ 3]);
    VSPIX_Load("GFX\\GREET\\clo.gif", GreetTex[ 4], gpal[ 4], &GreetW[ 4], &GreetH[ 4]);
    VSPIX_Load("GFX\\GREET\\fue.gif", GreetTex[ 5], gpal[ 5], &GreetW[ 5], &GreetH[ 5]);
    VSPIX_Load("GFX\\GREET\\gob.gif", GreetTex[ 6], gpal[ 6], &GreetW[ 6], &GreetH[ 6]);
    VSPIX_Load("GFX\\GREET\\hex.gif", GreetTex[ 7], gpal[ 7], &GreetW[ 7], &GreetH[ 7]);
    VSPIX_Load("GFX\\GREET\\isp.gif", GreetTex[ 8], gpal[ 8], &GreetW[ 8], &GreetH[ 8]);
    VSPIX_Load("GFX\\GREET\\mir.gif", GreetTex[ 9], gpal[ 9], &GreetW[ 9], &GreetH[ 9]);
    VSPIX_Load("GFX\\GREET\\mis.gif", GreetTex[10], gpal[10], &GreetW[10], &GreetH[10]);
    VSPIX_Load("GFX\\GREET\\mov.gif", GreetTex[11], gpal[11], &GreetW[11], &GreetH[11]);
    VSPIX_Load("GFX\\GREET\\nov.gif", GreetTex[12], gpal[12], &GreetW[12], &GreetH[12]);
    VSPIX_Load("GFX\\GREET\\sci.gif", GreetTex[13], gpal[13], &GreetW[13], &GreetH[13]);
    VSPIX_Load("GFX\\GREET\\spl.gif", GreetTex[14], gpal[14], &GreetW[14], &GreetH[14]);
    VSPIX_Load("GFX\\GREET\\the.gif", GreetTex[15], gpal[15], &GreetW[15], &GreetH[15]);
    VSPIX_Load("GFX\\GREET\\tlo.gif", GreetTex[16], gpal[16], &GreetW[16], &GreetH[16]);
    VSPIX_Load("GFX\\GREET\\vpt.gif", GreetTex[17], gpal[17], &GreetW[17], &GreetH[17]);
    VSPIX_Load("GFX\\GREET\\wah.gif", GreetTex[18], gpal[18], &GreetW[18], &GreetH[18]);
    VSPIX_Load("GFX\\GREET\\zor.gif", GreetTex[19], gpal[19], &GreetW[19], &GreetH[19]);

    for (j = 0; j < NGREETS; j++)
        for (i = 0; i < 256; i++) {
            GreetPal[j][i] = ((int)gpal[j][i*3] << 22) + ((int)gpal[j][i*3+1] << 12) + ((int)gpal[j][i*3+2] << 2);
        }
    VSCLR_InitRGBInfo(NULL,
                VSDSF_RPOS+2, VSDSF_RWIDTH-2,
                VSDSF_GPOS+2, VSDSF_GWIDTH-2,
                VSDSF_BPOS+2, VSDSF_BWIDTH-2);
    VSCLR_MakeAlphaTab(&VSCLR_RGBInfo, VSTM_AlphaTbl[0], pal,  NTAB);

    InitWriter("ENDTEXT.TXT");
    InitInks();

    return TRUE;
}

extern bool InitTmap32(dword time) {
    int i, j;

    BeginTime = time;

    if ( (i = BASE_CheckArg("bpp")) > 0)
        BPP = atoi(ArgV[i]);

    if (
        !TCS_Init(320, 200, BPP)
     && !TCS_Init(320, 200, 32)
     && !TCS_Init(320, 200, 16)
     && !TCS_Init(320, 200, 15)
     && !TCS_Init(320, 200, 8)) {
        BASE_Abort("You suck.\n");
    }

    CurFunction = DoTmap32;

    return TRUE;
}

extern bool EndTmap32(dword time) {
    TCS_End(-1);
    DISPOSE(pix);

    EndWriter();

    CurFunction = NULL;
    return TRUE;
}
