//	vectors.h

#ifndef _VECTORS_
#define _VECTORS_

#define Pi 3.141592654

// Vector class
class TVector {
	public:
			double x, y, z;
			
			TVector(double nx, double ny, double nz) { x = nx; y = ny; z = nz; };
			TVector()		{ };
			
			void SetP(double nx, double ny, double nz) { x = nx; y = ny; z = nz; };
			void Normalize();
			double Magnitude();
			void Traslate(double tx, double ty, double tz) { x += tx; y += ty; z += tz; };
			void Rotate(int ax, int ay, int az);
			void Scale(double sx, double sy, double sz) { x *= sx; y *= sy; z *= sz; };
			void ScaleXYZ(double s) { x *= s; y *= s; z *= s; };
};


// Common Vector operations
double DotProduct(TVector a, TVector b);
TVector CrossProduct(TVector a, TVector b);
TVector AddVectors(TVector a, TVector b);
TVector SubVectors(TVector a, TVector b);
TVector MulVector(TVector v, double k);
TVector DivVector(TVector v, double k);
TVector CopyVector(TVector source);

TVector operator +(TVector a, TVector b);
TVector operator -(TVector a, TVector b);
TVector operator *(TVector a, TVector b);
TVector operator *(TVector v, double k);
TVector operator *(double k, TVector v);
TVector operator /(TVector v, double k);
TVector operator +=(TVector &a, TVector b);
TVector operator -=(TVector &a, TVector b);


// Vertex class
class TVertex : public TVector {
	public:
			TVector normal;
			int x2d, y2d;
			double u, v;
			int c;
			int tag;
			double vx, vy, vz, zorder;
			
			TVertex();
			TVertex(double nx, double ny, double nz);
			
			void CalcEnvUV();
			void VRotate(int ax, int ay, int az);
			void FakeNormal();
};


// trigonometric tables
#define NumDegrees 1440
extern double SinT[NumDegrees], CosT[NumDegrees];
void CalcTrigTables();


#endif
