//	blitter.cpp

#include <stdlib.h>
#include "globals.h"
#include "blitter.h"

VBE_ModeInfoBlock vesamodeinfo;
unsigned *SCREEN;

// color lookup tables
unsigned lut16bit[6][256];
unsigned lut16bitOFS;
unsigned ScreenSize;

void Blit(unsigned source);

void InitVideo() {
     int bpp;
     char k = 0;
     VBE_SetMode(3, 0, 1);
     _write(54, "\n\r --> Choose a cool video mode (vesa 2.0 required):\n\r");
     _write(26, "\n\r       1.- 320x240x15bpp");
     _write(26, "\n\r       2.- 320x240x16bpp");
     _write(19, "\n\r       3.- Exit\n\r");

     while ((k < '1') || (k > '3')) k = _inkey();
     switch (k) {
            case '1':   bpp = 15; break;
            case '2':   bpp = 16; break;
            default:  exit(EXIT_SUCCESS);
     }

     _write(46, "\n\r --> Want to add blur to every frame (y/n)? ");
     k = 0;
     while ((k != 'y') && (k != 'n')) k = _inkey();
     blurflag = (k == 'y');

     int mode = VBE_FindMode(ScreenWidth, ScreenHeight, bpp);
     if (mode == -1) {
        VBE_SetMode(3, 0, 1);
        _write(46, "lfb mode not found. try univbe or something.\n\r");
        exit(1);
     }
     if (!VBE_IsModeLinear(mode)) {
        VBE_SetMode(3, 0, 1);
        _write(46, "lfb mode not found. try univbe or something.\n\r");
        exit(1);
     }

     VBE_SetMode(mode, 1, 1);
     SCREEN = (unsigned *)VBE_GetVideoPtr(mode);
     if (!SCREEN) {
        VBE_SetMode(3, 0, 1);
        _write(46, "lfb mode not found. try univbe or something.\n");
        exit(1);
     }

     VBE_Mode_Information(mode, &vesamodeinfo);

     // calculate color lookup tables
     for (unsigned i = 0; i < 256; i++) {
     	lut16bit[0][i] = (i >> (8 - vesamodeinfo.RedMaskSize)) << vesamodeinfo.RedFieldPosition;
     	lut16bit[1][i] = (i >> (8 - vesamodeinfo.GreenMaskSize)) << vesamodeinfo.GreenFieldPosition;
     	lut16bit[2][i] = (i >> (8 - vesamodeinfo.BlueMaskSize)) << vesamodeinfo.BlueFieldPosition;
     	lut16bit[3][i] = lut16bit[0][i] << 16;
     	lut16bit[4][i] = lut16bit[1][i] << 16;
     	lut16bit[5][i] = lut16bit[2][i] << 16;
     }
     
     lut16bitOFS = (unsigned)lut16bit;
     ScreenSize = ScreenWidth * ScreenHeight;
}


void Blit(unsigned source) {
	unsigned count = ScreenSize >> 1;
	_asm {
		mov esi, [source]
		mov edi, [SCREEN]
		mov ebx, [lut16bitOFS]
		xor ecx, ecx
		blah:   mov eax, [esi]
				mov cl, al
				mov edx, [ebx + ecx * 4 + 2048]
				mov cl, ah
				or edx, [ebx + ecx * 4 + 1024]
				shr eax, 16
//				mov cl, al
				or edx, [ebx + eax * 4]
//				mov [edi], dx
//				add edi, 2

//				shl edx, 16
				mov eax, [esi + 4]
				mov cl, al
				add esi, 8
				or edx, [ebx + ecx * 4 + 5120]
				mov cl, ah
				or edx, [ebx + ecx * 4 + 4096]
				shr eax, 16
//				mov cl, al
				or edx, [ebx + eax * 4 + 3072]
				mov [edi], edx
				add edi, 4

				dec [count]
				jnz blah
	}
}

