////////////////////////////////////////////////////////////////////////////
//
//        CIENKA    -    100 Kb intro by FAC/DLB featuring music by Uctumi
//
//        File:     bitmaps.h
//
//        Description:   This file defines the next two classes:
//                       class TBitmap which handles 32 bpp bitmaps and
//                       class TBitmap8bpp which handles 256 color bitmaps
//
////////////////////////////////////////////////////////////////////////////


#ifndef _BITMAPS_
#define _BITMAPS_

// Some auxiliary types

typedef unsigned char byte;
typedef unsigned short word;


// A little macro to pack the rgb components into a dword

unsigned RGB(byte r, byte g, byte b);
#pragma aux RGB =      \
"xor ah, ah"	\
"shl eax, 16"	\
"mov ax, bx"	\
parm [al] [bh] [bl]	\
modify [eax]	\
value [eax];


// TBitmap class definition

class TBitmap {
      public: int ancho, alto;     // width and height
              unsigned *datos;     // pointer to image data
              int *tablay;         // pointer to precalculated Y offsets

      TBitmap(int w, int h);
      ~TBitmap();

      void Borra(unsigned color);  // Clear bitmap
      void Blur();                 // Blur bitmap
};


// TBitmap8bpp class definition

class TBitmap8bpp {
      public: int ancho, alto;     // width and height
              byte *datos;         // pointer to image data
              int *tablay;         // pointer to precalculated Y offsets
              unsigned paleta[256];     // palette

      TBitmap8bpp(int w, int h);
      TBitmap8bpp(int w, int h, unsigned char *data, unsigned *palette);
      ~TBitmap8bpp();

      void Borra(byte color);
      void BlitTo(TBitmap *dest, int x0, int y0);
      void TransBlitTo(TBitmap *dest, int x0, int y0, byte tcolor);
      void BlitTo8bpp(TBitmap8bpp *dest, int x0, int y0);
      void Blur();
};

#endif
