#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include "hires256.h"
#include "stuff.h"
#include "phongpal.h"
#include "mcubetbl.h"
#include "metaball.h"

// picture files
#include "m1.h"
#include "m2.h"
#include "m3.h"
#include "m4.h"
#include "m5.h"
#include "m6.h"
#include "m7.h"
#include "m8.h"
#include "m9.h"
#include "m10.h"
#include "m11.h"
#include "m12.h"
#include "m13.h"
#include "m14.h"
#include "m15.h"
#include "m16.h"
#include "m17.h"
#include "m18.h"
#include "m19.h"
#include "env12.h"
#include "truss01.h"
#include "truss02.h"
#include "truss03.h"
#include "truss04.h"
#include "truss05.h"
#include "truss06.h"
#include "truss07.h"
#include "truss08.h"
#include "truss09.h"
#include "truss10.h"
#include "truss11.h"
#include "truss12.h"
#include "truss13.h"
#include "truss14.h"
#include "truss15.h"
#include "truss16.h"


#define GridSizeX 20
#define GridSizeY 16
#define GridSizeZ 18
#define GridSizeXY 320  // GridSizeX * GridSizeY

#define ZSkip 6

#define CellSizeX 52
#define CellSizeY 52
#define CellSizeZ 52

#define StartPX 520     // CellSizeX * GridSizeX / 2
#define StartPY 416
#define StartPZ 156     // CellSizeZ * (GridSizeZ / 2 - ZSkip)

#define radius 1.75

#define GX 19           //  GridSizeX - 1
#define GY 15
#define GZ 10           //  GridSizeZ - 2 - ZSkip

// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))
int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif


typedef struct {
	double x, y, z;
	int x2d, y2d;
	double u, v;
} MTVertex;


double blob[GridSizeZ][GridSizeY][GridSizeX];
static MTVertex VertexPos[8];
static int PX, PY, PZ, bpos = 0;
double blobpos[9 * 256];
int XCBlob, YCBlob;
double MetaTable1[256];
unsigned char MetaIdx1 = 0;

int X_MIN[480], X_MAX[480];
double U_MIN[480], U_MAX[480], V_MIN[480], V_MAX[480];


void CDDALine(int x1, int y1, int x2, int y2, int color, unsigned int where) {
	//	line clipping
	double m = (double)(y2 - y1) / (double)(x2 - x1);
	double im = 1 / m;
	if (x1 <= x2) {
                if ((x1 > 639) || (x2 < 0)) return;
		if (x1 < 0) { y1 += dtoi(-x1 * m); x1 = 0; }
                if (x2 > 639) { y2 -= dtoi((x2 - 639) * m); x2 = 639; }
	}
	else {
                if ((x1 < 0) || (x2 > 639)) return;
		if (x2 < 0) { y2 += dtoi(-x2 * m); x2 = 0; }
                if (x1 > 639) { y1 -= dtoi((x1 - 639) * m); x1 = 639; }
	}
	if (y1 <= y2) {
                if ((y1 > 479) || (y2 < 0)) return;
		if (y1 < 0) { x1 += dtoi(-y1 * im); y1 = 0; }
                if (y2 > 479) { x2 -= dtoi((y2 - 479) * im); y2 = 479; }
	}
	else {
                if ((y1 < 0) || (y2 > 479)) return;
		if (y2 < 0) { x2 += dtoi(-y2 * im); y2 = 0; }
                if (y1 > 479) { x1 -= dtoi((y1 - 479) * im); y1 = 479; }
	}
	
	int width = x2 - x1;
	int height = y2 - y1;
	if (width < 0) width = -width;
	if (height < 0) height = - height;
	if (width > height) {
		if (height == 0) height = 1;
		if (x1 > x2) {
			int temp = x1; x1 = x2; x2 = temp;
			temp = y1; y1 = y2; y2 = temp;
		}
		int dy = (height << 16) / width;
                int yinc = (y1 > y2) ? (-640) : (640);
                unsigned int off = where + (y1 << 9) + (y1 << 7) + x1;
		_asm {
			mov edi, [off]
			mov esi, [yinc]
                        mov eax, [color]
			mov edx, [dy]
			xor ebx, ebx
			mov ecx, [width]
			lloop:  mov [edi], al
                                inc edi
                                add bx, dx
                                jnc cont
                                add edi, esi
			cont:   dec ecx
                                jnz lloop
		}
		return;
	}
	if (width < height) {
		if (width == 0) width = 1;
		if (y1 > y2) {
			int temp = y1; y1 = y2; y2 = temp;
			temp = x1; x1 = x2; x2 = temp;
		}
		int ddx = (width << 16) / height;
		int xinc = (x1 > x2) ? (-1) : (1);
                unsigned int off = where + (y1 << 9) + (y1 << 7) + x1;
		_asm {
			mov edi, [off]
			mov esi, [xinc]
                        mov eax, [color]
			mov edx, [ddx]
			xor ebx, ebx
			mov ecx, [height]
			lloop:  mov [edi], al
                                add edi, 640
                                add bx, dx
                                jnc cont
                                add edi, esi
			cont:   dec ecx
                                jnz lloop
		}
		return;
	}
	if (width == 0) width = 1;
	int dx = (x1 > x2) ? (-1) : (1);
        int dy = (y1 > y2) ? (-640 + dx) : (640 + dx);
        unsigned int off = where + (y1 << 9) + (y1 << 7) + x1;
	_asm {
		mov edi, [off]
                mov eax, [color]
		mov ebx, [dy]
		mov ecx, [width]
		lloop:  mov [edi], al
                        add edi, ebx
                        dec ecx
                        jnz lloop
	}
}

// texture
void MScanSide(MTVertex *v1, MTVertex *v2) {
        int y1 = v1->y2d;
        int y2 = v2->y2d;
        int altura = y2 - y1;
        if (altura == 0) return;
        if ((y2 <= 0) || (y1 >= 480)) return;
        int dxdy = (((v2->x2d - v1->x2d) << 16) + 32768) / altura;
        int x = v1->x2d << 16;
        double dudy = (v2->u - v1->u) / (double)altura;
        double u = v1->u;
        double dvdy = (v2->v - v1->v) / (double)altura;
        double v = v1->v;
        if (y1 < 0) { x -= y1 * dxdy; y1 = 0; }
        if (y2 > 479) y2 = 479;
        for (int y = y1; y <= y2; y++) {
                if (x < X_MIN[y]) { X_MIN[y] = x; U_MIN[y] = u; V_MIN[y] = v; }
                if (x > X_MAX[y]) { X_MAX[y] = x; U_MAX[y] = u; V_MAX[y] = v; }
                x += dxdy;
                u += dudy;
                v += dvdy;
        }
}


void TTriangle(MTVertex *v1, MTVertex *v2, MTVertex *v3, unsigned int texture, unsigned int where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        if (v1->y2d < ymin) ymin = v1->y2d;
        if (v2->y2d < ymin) ymin = v2->y2d;
        if (v3->y2d < ymin) ymin = v3->y2d;
        if (v1->y2d > ymax) ymax = v1->y2d;
        if (v2->y2d > ymax) ymax = v2->y2d;
        if (v3->y2d > ymax) ymax = v3->y2d;
        if (v1->x2d < xmin) xmin = v1->x2d;
        if (v2->x2d < xmin) xmin = v2->x2d;
        if (v3->x2d < xmin) xmin = v3->x2d;
        if (v1->x2d > xmax) xmax = v1->x2d;
        if (v2->x2d > xmax) xmax = v2->x2d;
        if (v3->x2d > xmax) xmax = v3->x2d;
        if (ymax == ymin) return;
        if ((ymin > 479) || (ymax < 0)) return;
        if ((xmin > 639) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 480
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 480
                rep stosd
        }

        if (v1->y2d < v2->y2d) MScanSide(v1, v2); else MScanSide(v2, v1);
        if (v2->y2d < v3->y2d) MScanSide(v2, v3); else MScanSide(v3, v2);
        if (v1->y2d < v3->y2d) MScanSide(v1, v3); else MScanSide(v3, v1);

        if (ymin < 0) ymin = 0;
        if (ymax > 479) ymax = 479;
        unsigned int off = ymin * 640 + where;
        int deltax, x, dudx, dvdx, u, v;
        for (int i = ymin; i <= ymax; i++) {
                deltax = ((X_MAX[i] - X_MIN[i]) >> 16) + 1;
                x = X_MIN[i] >> 16;
                dudx = dtoi((U_MAX[i] - U_MIN[i]) * 65536.0) / deltax;
                dvdx = dtoi((V_MAX[i] - V_MIN[i]) * 65536.0) / deltax;
                u = dtoi(U_MIN[i] * 65536.0);
                v = dtoi(V_MIN[i] * 65536.0);
                if (x < 0) { u -= x * dudx; v -= x * dvdx; deltax += x; x = 0; }
                if (X_MAX[i] > 41877504) deltax = 640 - x;
                if (deltax > 0)
                _asm {
                        mov edi, [off]
                        mov ecx, [deltax]
                        mov esi, [v]
                        mov edx, [u]
                        add edi, [x]
                        lp:     movzx ebx, si
                                add esi, [dvdx]
                                mov bl, dh
                                add edx, [dudx]
                                add ebx, [texture]
                                mov al, [ebx]
                                mov [edi], al
                                inc edi
                                dec ecx
                                jnz lp
                }
                off += 640;
        }
}


void Metaball_Setup() {
	VertexPos[0].x = 0;
	VertexPos[0].y = 0;
	VertexPos[0].z = 0;
	VertexPos[1].x = CellSizeX;
	VertexPos[1].y = 0;
	VertexPos[1].z = 0;	            
	VertexPos[2].x = CellSizeX;
	VertexPos[2].y = 0;
	VertexPos[2].z = CellSizeZ;	
	VertexPos[3].x = 0;
	VertexPos[3].y = 0;
	VertexPos[3].z = CellSizeZ;	
	VertexPos[4].x = 0;
	VertexPos[4].y = CellSizeY;
	VertexPos[4].z = 0;	
	VertexPos[5].x = CellSizeX;
	VertexPos[5].y = CellSizeY;
	VertexPos[5].z = 0;	
	VertexPos[6].x = CellSizeX;
	VertexPos[6].y = CellSizeY;
	VertexPos[6].z = CellSizeZ;	
	VertexPos[7].x = 0;
	VertexPos[7].y = CellSizeY;
	VertexPos[7].z = CellSizeZ;

	int n = 0;
	double ang;
	for (int i = 0; i < 256; i++) {
		ang = i * 3.14159265 / 128.0;
                blobpos[n++] = -sin(ang * 2) * 4 + 10;
                blobpos[n++] = -cos(ang) * 5 + 8;
                blobpos[n++] = cos(ang * 2) * 2 + 7;
                blobpos[n++] = -cos(ang) * 7.0 + 10;
                blobpos[n++] = -sin(ang * 2) * 4 + 8;
                blobpos[n++] = sin(ang) * 2 + 9;
                blobpos[n++] = cos(ang) * 6 + 10.0;
                blobpos[n++] = sin(ang*2) * 4 + 8;
                blobpos[n++] = cos(ang) * 3 + 8;
	}

        for (i = 0; i < 16000; i++) {
                M9[i] = 128 + M9[i] / 2;
                M10[i] = 128 + M10[i] / 2;
                M12[i] = 128 + M12[i] / 2;
                M17[i] = 128 + M17[i] / 2;
                TRUSS01[i] /= 2;
                TRUSS02[i] /= 2;
                TRUSS03[i] /= 2;
                TRUSS04[i] /= 2;
                TRUSS05[i] /= 2;
                TRUSS06[i] /= 2;
                TRUSS07[i] /= 2;
                TRUSS08[i] /= 2;
                TRUSS09[i] /= 2;
                TRUSS10[i] /= 2;
                TRUSS11[i] /= 2;
                TRUSS12[i] /= 2;
                TRUSS13[i] /= 2;
                TRUSS14[i] /= 2;
                TRUSS15[i] /= 2;
                TRUSS16[i] /= 2;
        }

        for (i = 0; i < 256; i++)
                MetaTable1[i] = -0.1 + 0.1 * sin(i * 3.14159265 / 128.0);
}


void Metaball_Free() { }


MTVertex Interpola( MTVertex p1, MTVertex p2, int z1, int y1, int x1,
					int z2, int y2, int x2) {
        double *val1 = &(blob[z1][y1][x1]);
        double *val2 = &(blob[z2][y2][x2]);
        MTVertex p;
        double mu = (1.0 - (*val1)) / ((*val2) - (*val1));
	p.x = PX + p1.x + mu * (p2.x - p1.x);
	p.y = PY + p1.y + mu * (p2.y - p1.y);
	p.z = PZ + p1.z + mu * (p2.z - p1.z);
        double perspective = 256.0 / (512.0 - p.z);
        p.x2d = dtoi(p.x * perspective) + XCBlob;
        p.y2d = dtoi(-p.y * perspective) + YCBlob;
	double nx1 = *(val1 + 1) - (*val1);
	double ny1 = *(val1 + GridSizeX) - (*val1);
	double nz1 = *(val1 + GridSizeXY) - (*val1);
	double nx2 = *(val2 + 1) - (*val2);
	double ny2 = *(val2 + GridSizeX) - (*val2);
	double nz2 = *(val2 + GridSizeXY) - (*val2);
        double normx = nx1 + mu * (nx2 - nx1);
        double normy = ny1 + mu * (ny2 - ny1);
        double normz = nz1 + mu * (nz2 - nz1);
	double maginv = 0.5 / sqrt(normx * normx + normy * normy + normz * normz);
	p.u = (normx * maginv + 0.5);
	p.v = (normy * maginv + 0.5);
	return(p);
}


int Polygonize(int x, int y, int z, unsigned int where, int textured) {
	int ntriang, cubeindex, i;
        MTVertex vertlist[12];
        MTVertex Vertex1, Vertex2, Vertex3;
	
	cubeindex = 0;
    if (blob[z][y][x] < 1.0) cubeindex |= 1;
    if (blob[z][y][x+1] < 1.0) cubeindex |= 2;
    if (blob[z+1][y][x+1] < 1.0) cubeindex |= 4;
    if (blob[z+1][y][x] < 1.0) cubeindex |= 8;
    if (blob[z][y+1][x] < 1.0) cubeindex |= 16;
    if (blob[z][y+1][x+1] < 1.0) cubeindex |= 32;
    if (blob[z+1][y+1][x+1] < 1.0) cubeindex |= 64;
    if (blob[z+1][y+1][x] < 1.0) cubeindex |= 128;

	if (!EdgeTable[cubeindex]) return 0;
	
	if (EdgeTable[cubeindex] & 1) vertlist[0] = 
		Interpola(VertexPos[0], VertexPos[1], z, y, x, z, y, x+1);
	
	if (EdgeTable[cubeindex] & 2) vertlist[1] = 
		Interpola(VertexPos[1], VertexPos[2], z, y, x+1, z+1, y, x+1);
	
	if (EdgeTable[cubeindex] & 4) vertlist[2] = 
		Interpola(VertexPos[2], VertexPos[3], z+1, y, x+1, z+1, y, x);
	
	if (EdgeTable[cubeindex] & 8) vertlist[3] = 
		Interpola(VertexPos[3], VertexPos[0], z+1, y, x, z, y, x);
	
	if (EdgeTable[cubeindex] & 16) vertlist[4] = 
		Interpola(VertexPos[4], VertexPos[5], z, y+1, x, z, y+1, x+1);
	
	if (EdgeTable[cubeindex] & 32) vertlist[5] = 
		Interpola(VertexPos[5], VertexPos[6], z, y+1, x+1, z+1, y+1, x+1);
	
	if (EdgeTable[cubeindex] & 64) vertlist[6] = 
		Interpola(VertexPos[6], VertexPos[7], z+1, y+1, x+1, z+1, y+1, x);
	
	if (EdgeTable[cubeindex] & 128) vertlist[7] = 
		Interpola(VertexPos[7], VertexPos[4], z+1, y+1, x, z, y+1, x);
	
	if (EdgeTable[cubeindex] & 256) vertlist[8] = 
		Interpola(VertexPos[0], VertexPos[4], z, y, x, z, y+1, x);
	
	if (EdgeTable[cubeindex] & 512) vertlist[9] = 
		Interpola(VertexPos[1], VertexPos[5], z, y, x+1, z, y+1, x+1);
	
	if (EdgeTable[cubeindex] & 1024) vertlist[10] = 
		Interpola(VertexPos[2], VertexPos[6], z+1, y, x+1, z+1, y+1, x+1);
	
	if (EdgeTable[cubeindex] & 2048) vertlist[11] = 
		Interpola(VertexPos[3], VertexPos[7], z+1, y, x, z+1, y+1, x);


	ntriang = 0;
	for (i = 0; TriTable[cubeindex][i] != -1; i += 3) {
		Vertex1 = vertlist[TriTable[cubeindex][i]];
		Vertex2 = vertlist[TriTable[cubeindex][i+1]];
		Vertex3 = vertlist[TriTable[cubeindex][i+2]];
                if (((Vertex2.x2d - Vertex1.x2d) * (Vertex3.y2d - Vertex1.y2d)) <=
			((Vertex2.y2d - Vertex1.y2d) * (Vertex3.x2d - Vertex1.x2d))) {
                        if (textured) TTriangle(&Vertex1, &Vertex2, &Vertex3, (unsigned int)ENV12, where);
                        else {
                                CDDALine(Vertex1.x2d, Vertex1.y2d, Vertex2.x2d, Vertex2.y2d, 127, where);
                                CDDALine(Vertex2.x2d, Vertex2.y2d, Vertex3.x2d, Vertex3.y2d, 127, where);
                                CDDALine(Vertex3.x2d, Vertex3.y2d, Vertex1.x2d, Vertex1.y2d, 127, where);
                        }
			ntriang++;
		}
	}
	return ntriang;
}


void CalcBlobs1() {
	int x, y, z;
	double *bp = blobpos + bpos;
	double x0 = *bp++, y0 = *bp++, z0 = *bp++;
	double x1 = *bp++, y1 = *bp++, z1 = *bp++;
	double x2 = *bp++, y2 = *bp++, z2 = *bp++;
        double *b = (double *)blob;
        int ZLimit = GridSizeZ - ZSkip;  // SOLO SI ZSkip > 0  !!!!!
        for (z = 0; z <= ZLimit; z++)
		for (y = 0; y < GridSizeY; y++)
                        for (x = 0; x < GridSizeX; x++)                               
                        *b++ =  1.2 / sqrt((x-x0)*(x-x0)+(z-z0)*(z-z0)) +
                                1.3 / sqrt((y-y1)*(y-y1)+(z-z1)*(z-z1)) +
                                1.6 / sqrt((x-x2)*(x-x2)+(y-y2)*(y-y2)+(z-z2)*(z-z2));
}

void CalcBlobs2() {
	int x, y, z;
	double *bp = blobpos + bpos;
	double x0 = *bp++, y0 = *bp++, z0 = *bp++;
	double x1 = *bp++, y1 = *bp++, z1 = *bp++;
	double x2 = *bp++, y2 = *bp++, z2 = *bp++;
        double *b = (double *)blob;
        int ZLimit = GridSizeZ - ZSkip;  // SOLO SI ZSkip > 0  !!!!!
        for (z = 0; z <= ZLimit; z++)
		for (y = 0; y < GridSizeY; y++)
                        for (x = 0; x < GridSizeX; x++)
                                *b++ = radius / sqrt((x-x0)*(x-x0)+(y-y0)*(y-y0)+(z-z0)*(z-z0)) +
                                       radius / sqrt((x-x1)*(x-x1)+(y-y1)*(y-y1)+(z-z1)*(z-z1)) +
                                       radius / sqrt((x-x2)*(x-x2)+(y-y2)*(y-y2)+(z-z2)*(z-z2));
}


void MDrawLogo(int x, int y, unsigned int source, unsigned int dest);
#pragma aux MDrawLogo = \
"       imul ebx, 640"  \
"       add edi, eax"   \
"       mov edx, 100"   \
"       add edi, ebx"   \
"       push edi"       \
"       lp:     mov ecx, 40"    \
"               rep movsd"      \
"               add edi, 480"   \
"               dec edx"        \
"               jnz lp" \
"       pop edx"        \
"       xor eax, eax"   \
"       mov edi, edx"   \
"       mov ecx, 40"    \
"       rep stosd"      \
"       mov edi, edx"   \
"       mov ecx, 40"    \
"       add edi, 63360" \
"       rep stosd"      \
"       mov edi, edx"   \
"       mov ecx, 100"   \
"       lp2:    mov [edi], al"  \
"               mov [edi + 159], al"    \
"               add edi, 640"   \
"               dec ecx"        \
"               jnz lp2"        \
parm [eax] [ebx] [esi] [edi]    \
modify [ecx edx];


void MDrawBigFrame(unsigned int frame, unsigned int where);
#pragma aux MDrawBigFrame =     \
"       add edi, 89760" \
"       mov edx, 100"   \
"       ylp:    mov ecx, 160"   \
"       xlp:    mov al, [esi]"  \
"               inc esi"        \
"               mov ah, al"     \
"               mov [edi], ax"  \
"               mov [edi + 640], ax"    \
"               add edi, 2"     \
"               dec ecx"        \
"               jnz xlp"        \
"               add edi, 960"   \
"               dec edx"        \
"               jnz ylp"        \
parm [esi] [edi]        \
modify [eax ecx edx];


void ClearTopBottom(unsigned int where);
#pragma aux ClearTopBottom =    \
"       mov eax, 0x80808080"    \
"       mov ecx, 6400"  \
"       rep stosd"      \
"       add edi, 256000"        \
"       mov ecx, 6400"  \
"       rep stosd"      \
parm [edi]      \
modify [eax ecx];


void Blur(unsigned int where);
#pragma aux Blur =      \
"add edi, 320"  \
"mov ecx, 305920"       \
"xor ebx, ebx"  \
"bloop: movzx eax, byte ptr [edi+1]"      \
"       mov bl, [edi-1]"        \
"       add eax, ebx"   \
"       mov bl, [edi+640]"      \
"       add eax, ebx"   \
"       mov bl, [edi-640]"      \
"       add eax, ebx"   \
"       shr eax, 2"     \
"       mov [edi], al"  \
"       inc edi"        \
"       dec ecx"        \
"       jnz bloop"      \
parm [edi]      \
modify [eax ebx ecx];


void Metaball1() {
        unsigned int Sequence[30] = { (unsigned int)TRUSS01, (unsigned int)TRUSS02,
                                      (unsigned int)TRUSS03, (unsigned int)TRUSS04,  
                                      (unsigned int)TRUSS05, (unsigned int)TRUSS06,  
                                      (unsigned int)TRUSS07, (unsigned int)TRUSS08,  
                                      (unsigned int)TRUSS09, (unsigned int)TRUSS10,  
                                      (unsigned int)TRUSS11, (unsigned int)TRUSS12,  
                                      (unsigned int)TRUSS13, (unsigned int)TRUSS14,  
                                      (unsigned int)TRUSS15, (unsigned int)TRUSS16,  
                                      (unsigned int)TRUSS15, (unsigned int)TRUSS14,  
                                      (unsigned int)TRUSS13, (unsigned int)TRUSS12,  
                                      (unsigned int)TRUSS11, (unsigned int)TRUSS10,  
                                      (unsigned int)TRUSS09, (unsigned int)TRUSS08,  
                                      (unsigned int)TRUSS07, (unsigned int)TRUSS06,  
                                      (unsigned int)TRUSS05, (unsigned int)TRUSS04,  
                                      (unsigned int)TRUSS03, (unsigned int)TRUSS02 };  
        unsigned int Logo[19] = { (unsigned int)M1, (unsigned int)M2,
                                  (unsigned int)M3, (unsigned int)M4,
                                  (unsigned int)M5, (unsigned int)M6,
                                  (unsigned int)M7, (unsigned int)M8,
                                  (unsigned int)M9, (unsigned int)M10,
                                  (unsigned int)M11, (unsigned int)M12,
                                  (unsigned int)M13, (unsigned int)M14,
                                  (unsigned int)M15, (unsigned int)M16,
                                  (unsigned int)M17, (unsigned int)M18,
                                  (unsigned int)M19 };
        unsigned int LogoPos[7][2] = { {0, 40}, {160, 40}, {320, 40}, {480, 40},
                                        {0, 140}, {0, 240}, {0, 340} };
        unsigned int LogoPos2[12][2] = { {0, 40}, {160, 40}, {320, 40}, {480, 40},
                                        {0, 140}, {0, 240}, {480, 140}, {480, 240},
                                        {0, 340}, {160, 340}, {320, 340}, {480, 340} };
        unsigned int LogoPos3[4][2] = { {160, 140}, {320, 140}, {160, 240}, {320, 240} };
        TVirtual *vs = new TVirtual;
        int xx, yy, zz, flag = 1;
        TPalette pal;
	
        for (int n = 0; n < 16000; n++) {
                if (M1[n]) M1[n] = 128 + (M1[n] - 224) * 4; else M1[n] = 128;
                if (M2[n]) M2[n] = 128 + (M2[n] - 224) * 4; else M2[n] = 128;
                if (M3[n]) M3[n] = 128 + (M3[n] - 224) * 4; else M3[n] = 128;
                if (M4[n]) M4[n] = 128 + (M4[n] - 224) * 4; else M4[n] = 128;
                if (M5[n]) M5[n] = 128 + (M5[n] - 224) * 4; else M5[n] = 128;
                if (M6[n]) M6[n] = 128 + (M6[n] - 224) * 4; else M6[n] = 128;
                if (M7[n]) M7[n] = 128 + (M7[n] - 224) * 4; else M7[n] = 128;
                if (!M8[n]) M8[n] = 128;
                if (!M11[n]) M11[n] = 128;
                if (M13[n]) M13[n] = 128 + (M13[n] - 224) * 4; else M13[n] = 128;
                if (!M14[n]) M14[n] = 128;
                if (!M15[n]) M15[n] = 128;
                if (!M16[n]) M16[n] = 128;
                if (!M18[n]) M18[n] = 128;
                if (!M19[n]) M19[n] = 128;
        }
        HClearScreen(0, SCREEN_OFF);
        HClearScreen(0, (unsigned int)vs);
        PhongPal(0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1, pal, 0, 128);
        PhongPal(0.3, 0.5, 0.9, 0.1, 0.1, 0.9, 0.1, 0.2, 0.9, 20, pal, 128, 128);
//        CopyPalette(ENV12_PAL, pal, 0, 127);
        SetPalette(pal);
        XCBlob = 400; YCBlob = 290;

        GetMusicInfo();

        while (row < 32) {
                MDrawBigFrame(Sequence[((position) * 64 + row) % 30], (unsigned int)vs);

                srand(((position) * 64 + row) >> 3);
                for (n = 0; n < 12; n++)
                        MDrawLogo(LogoPos2[n][0], LogoPos2[n][1], Logo[rand() % 19], (unsigned int)vs);
                ClearTopBottom((unsigned int)vs);
		
                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
	}

        PhongPal(0.2, 0.6, 1.0, 0.1, 0.2, 1.0, 0.1, 0.1, 1.0, 40, pal, 0, 128);
        PhongPal(0.0, 0.0, 0.8, 0.3, 0.5, 1.0, 0.1, 0.3, 0.9, 20, pal, 128, 128);
        HClearScreen(0, SCREEN_OFF);
        SetPalette(pal);

        while (position < 22) {
//                bpos = (((position) * 64 + row) & 255) * 9;
                CalcBlobs1();

                flag = !((position == 21) && (row >= 32));
		
		PZ = StartPZ;
		for (zz = GZ; zz >= 0; zz--) {
			PY = -StartPY;
			for (yy = 0; yy < GY; yy++) {
				PX = -StartPX;
				for (xx = 0; xx < GX; xx++) {
                                        Polygonize(xx, yy, zz, (unsigned int)vs, flag);
					PX += CellSizeX;
				}
				PY += CellSizeY;
			}
			PZ -= CellSizeZ;
		}

                if (!flag) { Blur((unsigned int)vs); Blur((unsigned int)vs); }

                srand(((position) * 64 + row) >> 3);
                for (n = 0; n < 7; n++)
                        MDrawLogo(LogoPos[n][0], LogoPos[n][1], Logo[rand() % 19], (unsigned int)vs);
                ClearTopBottom((unsigned int)vs);
		
                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                if (bpos < 2286) bpos += 18; else bpos = 0;

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
	}

        PhongPal(0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1, pal, 0, 128);
        PhongPal(0.3, 0.5, 0.9, 0.1, 0.1, 0.9, 0.1, 0.2, 0.9, 20, pal, 128, 128);
        HClearScreen(0, SCREEN_OFF);
        SetPalette(pal);

        while (row < 32) {
                MDrawBigFrame(Sequence[((position) * 64 + row) % 30], (unsigned int)vs);

                srand(((position) * 64 + row) >> 3);
                for (n = 0; n < 12; n++)
                        MDrawLogo(LogoPos2[n][0], LogoPos2[n][1], Logo[rand() % 19], (unsigned int)vs);
                ClearTopBottom((unsigned int)vs);
		
                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
	}

        for (n = 0; n < 127; n++) {
                pal[n][0] = 63 - n / 4;
                pal[n][1] = 0;
                pal[n][2] = 63 - n / 2;
        }
        PhongPal(0.2, 0.6, 1.0, 0.1, 0.2, 1.0, 0.1, 0.1, 1.0, 40, pal, 0, 128);
        HClearScreen(0, SCREEN_OFF);
        SetPalette(pal);
        unsigned int frame;

        while (position < 23) {
                frame = ((position) * 64 + row) % 30;
                for (n = 0; n < 12; n++)
                        MDrawLogo(LogoPos2[n][0], LogoPos2[n][1], Sequence[frame], (unsigned int)vs);

                srand(((position) * 64 + row) >> 3);
                for (n = 0; n < 4; n++)
                        MDrawLogo(LogoPos3[n][0], LogoPos3[n][1], Logo[rand() % 19], (unsigned int)vs);
                ClearTopBottom((unsigned int)vs);
		
                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
	}

        PhongPal(0.2, 0.6, 1.0, 0.1, 0.2, 1.0, 0.1, 0.1, 1.0, 40, pal, 0, 128);
        PhongPal(0.0, 0.0, 0.8, 0.3, 0.5, 1.0, 0.1, 0.3, 0.9, 20, pal, 128, 128);
        HClearScreen(0, SCREEN_OFF);
        SetPalette(pal);

        while (row < 32) {
//                bpos = (((position) * 64 + row) & 255) * 9;
                CalcBlobs1();

                flag = (row >= 16);
		
		PZ = StartPZ;
		for (zz = GZ; zz >= 0; zz--) {
			PY = -StartPY;
			for (yy = 0; yy < GY; yy++) {
				PX = -StartPX;
				for (xx = 0; xx < GX; xx++) {
                                        Polygonize(xx, yy, zz, (unsigned int)vs, flag);
					PX += CellSizeX;
				}
				PY += CellSizeY;
			}
			PZ -= CellSizeZ;
		}

                if (!flag) { Blur((unsigned int)vs); Blur((unsigned int)vs); }

                srand(((position) * 64 + row) >> 3);
                for (n = 0; n < 7; n++)
                        MDrawLogo(LogoPos[n][0], LogoPos[n][1], Logo[rand() % 19], (unsigned int)vs);
                ClearTopBottom((unsigned int)vs);
		
                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                if (bpos < 2286) bpos += 18; else bpos = 0;

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
	}

        for (n = 0; n < 127; n++) {
                pal[n][0] = 63 - n / 4;
                pal[n][1] = 0;
                pal[n][2] = 63 - n / 2;
        }
        PhongPal(0.2, 0.6, 1.0, 0.1, 0.2, 1.0, 0.1, 0.1, 1.0, 40, pal, 0, 128);
        HClearScreen(0, SCREEN_OFF);
        SetPalette(pal);

        while (position < 24) {
                MDrawBigFrame(Sequence[((position) * 64 + row) % 30], (unsigned int)vs);

                srand(((position) * 64 + row) >> 3);
                for (n = 0; n < 12; n++)
                        MDrawLogo(LogoPos2[n][0], LogoPos2[n][1], Logo[rand() % 19], (unsigned int)vs);
                ClearTopBottom((unsigned int)vs);
		
                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
	}

        delete vs;
}


void Metaball2() {
        unsigned int Sequence[30] = { (unsigned int)TRUSS01, (unsigned int)TRUSS02,
                                      (unsigned int)TRUSS03, (unsigned int)TRUSS04,  
                                      (unsigned int)TRUSS05, (unsigned int)TRUSS06,  
                                      (unsigned int)TRUSS07, (unsigned int)TRUSS08,  
                                      (unsigned int)TRUSS09, (unsigned int)TRUSS10,  
                                      (unsigned int)TRUSS11, (unsigned int)TRUSS12,  
                                      (unsigned int)TRUSS13, (unsigned int)TRUSS14,  
                                      (unsigned int)TRUSS15, (unsigned int)TRUSS16,  
                                      (unsigned int)TRUSS15, (unsigned int)TRUSS14,  
                                      (unsigned int)TRUSS13, (unsigned int)TRUSS12,  
                                      (unsigned int)TRUSS11, (unsigned int)TRUSS10,  
                                      (unsigned int)TRUSS09, (unsigned int)TRUSS08,  
                                      (unsigned int)TRUSS07, (unsigned int)TRUSS06,  
                                      (unsigned int)TRUSS05, (unsigned int)TRUSS04,  
                                      (unsigned int)TRUSS03, (unsigned int)TRUSS02 };  
        unsigned int Logo[19] = { (unsigned int)M1, (unsigned int)M2,
                                  (unsigned int)M3, (unsigned int)M4,
                                  (unsigned int)M5, (unsigned int)M6,
                                  (unsigned int)M7, (unsigned int)M8,
                                  (unsigned int)M9, (unsigned int)M10,
                                  (unsigned int)M11, (unsigned int)M12,
                                  (unsigned int)M13, (unsigned int)M14,
                                  (unsigned int)M15, (unsigned int)M16,
                                  (unsigned int)M17, (unsigned int)M18,
                                  (unsigned int)M19 };
        unsigned int LogoPos[7][2] = { {0, 340}, {160, 340}, {320, 340}, {480, 340},
                                        {480, 40}, {480, 140}, {480, 240} };
        unsigned int LogoPos2[12][2] = { {0, 40}, {160, 40}, {320, 40}, {480, 40},
                                        {0, 140}, {0, 240}, {480, 140}, {480, 240},
                                        {0, 340}, {160, 340}, {320, 340}, {480, 340} };
        unsigned int LogoPos3[4][2] = { {160, 140}, {320, 140}, {160, 240}, {320, 240} };
        TVirtual *vs = new TVirtual;
        int xx, yy, zz, flag = 1, n;
        TPalette pal;
	
        HClearScreen(0, SCREEN_OFF);
        HClearScreen(0, (unsigned int)vs);
        PhongPal(0.2, 1.0, 1.0, 0.2, 1.0, 1.0, 0.0, 0.0, 1.0, 40, pal, 0, 128);
        PhongPal(0.3, 0.2, 0.8, 0.3, 0.2, 0.8, 0.4, 0.8, 1.0, 20, pal, 128, 128);
//        CopyPalette(ENV12_PAL, pal, 0, 127);
        SetPalette(pal);
        XCBlob = 240; YCBlob = 190;

        GetMusicInfo();
        while (position < 26) {
//                bpos = (((position) * 64 + row) & 255) * 9;
                CalcBlobs2();

                flag = !((position == 25) && (row < 32));
		
		PZ = StartPZ;
		for (zz = GZ; zz >= 0; zz--) {
			PY = -StartPY;
			for (yy = 0; yy < GY; yy++) {
				PX = -StartPX;
				for (xx = 0; xx < GX; xx++) {
                                        Polygonize(xx, yy, zz, (unsigned int)vs, flag);
					PX += CellSizeX;
				}
				PY += CellSizeY;
			}
			PZ -= CellSizeZ;
		}

                if (!flag) Blur((unsigned int)vs);

                srand(((position) * 64 + row) >> 3);
                for (n = 0; n < 7; n++)
                        MDrawLogo(LogoPos[n][0], LogoPos[n][1], Logo[rand() % 19], (unsigned int)vs);

                ClearTopBottom((unsigned int)vs);
		
                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                if (bpos < 2286) bpos += 18; else bpos = 0;

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
	}

        for (n = 0; n < 127; n++) {
                pal[n][0] = 63 - n / 2;
                pal[n][1] = 63 - n / 2;
                pal[n][2] = 0;
        }
        PhongPal(0.2, 0.4, 0.6, 0.3, 0.6, 0.9, 0.4, 0.8, 1.0, 40, pal, 0, 128);
        HClearScreen(0, SCREEN_OFF);
        SetPalette(pal);
        unsigned int frame;

        while (row < 32) {
                frame = ((position) * 64 + row) % 30;
                for (n = 0; n < 12; n++)
                        MDrawLogo(LogoPos2[n][0], LogoPos2[n][1], Sequence[frame], (unsigned int)vs);

                srand(((position) * 64 + row) >> 3);
                for (n = 0; n < 4; n++)
                        MDrawLogo(LogoPos3[n][0], LogoPos3[n][1], Logo[rand() % 19], (unsigned int)vs);
                ClearTopBottom((unsigned int)vs);
		
                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
	}

        PhongPal(0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1, pal, 0, 128);
        PhongPal(0.3, 0.5, 0.9, 0.1, 0.1, 0.9, 0.1, 0.2, 0.9, 20, pal, 128, 128);
        HClearScreen(0, SCREEN_OFF);
        SetPalette(pal);

        while (position < 27) {
                MDrawBigFrame(Sequence[((position) * 64 + row) % 30], (unsigned int)vs);

                srand(((position) * 64 + row) >> 3);
                for (n = 0; n < 12; n++)
                        MDrawLogo(LogoPos2[n][0], LogoPos2[n][1], Logo[rand() % 19], (unsigned int)vs);
                ClearTopBottom((unsigned int)vs);
		
                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
	}

        HClearScreen(0, SCREEN_OFF);
        PhongPal(0.2, 1.0, 1.0, 0.2, 1.0, 1.0, 0.0, 0.0, 1.0, 40, pal, 0, 128);
        PhongPal(0.3, 0.2, 0.8, 0.3, 0.2, 0.8, 0.4, 0.8, 1.0, 20, pal, 128, 128);
        SetPalette(pal);

        while (position < 28) {
//                bpos = (((position) * 64 + row) & 255) * 9;
                CalcBlobs2();

                flag = (row > 24);
		
		PZ = StartPZ;
		for (zz = GZ; zz >= 0; zz--) {
			PY = -StartPY;
			for (yy = 0; yy < GY; yy++) {
				PX = -StartPX;
				for (xx = 0; xx < GX; xx++) {
                                        Polygonize(xx, yy, zz, (unsigned int)vs, flag);
					PX += CellSizeX;
				}
				PY += CellSizeY;
			}
			PZ -= CellSizeZ;
		}

                if (!flag) Blur((unsigned int)vs);

                srand(((position) * 64 + row) >> 3);
                for (n = 0; n < 7; n++)
                        MDrawLogo(LogoPos[n][0], LogoPos[n][1], Logo[rand() % 19], (unsigned int)vs);

                ClearTopBottom((unsigned int)vs);
		
                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                if (bpos < 2286) bpos += 18; else bpos = 0;

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
	}

        delete vs;
}

