#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <math.h>
#include <ctype.h>
#include "clax.h"
#include "ie.hh"
#include "globals.hh"
#include "material.hh"

#define VESA

#ifdef VESA
#include "vesavbe.hh"
#endif


typedef struct {
  int    x, y;
  float  aspectRatio;
  int    bpp;
} ScreenMode;


//----------------------------
// time stamp counter


unsigned long	TSC;

void StartTSC(void);
#pragma aux StartTSC = \
  "pushad" \
  "popad" \
  "pushad"\
  "mov eax,TSC"\
  "imul TSC"\
   0xf 0x31 \
  "mov TSC,eax"\
  "popad";

void EndTSC(void);
#pragma aux EndTSC =\
  "pushad"\
  "imul edx"\
   0xf 0x31\
  "sub eax,27"\
  "sub eax,TSC"\
  "mov TSC,eax"\
  "popad";

//----------------------------

void
print_child( k_NODE* node, int ind )
{
  k_NODE      *child;
  c_OBJECT    *obj,*cobj;

  if ( node ) {
    obj = (c_OBJECT *)node->object;
    if ( obj->parent != -1 ) {
      for (child = node->child; child; child = child->brother) {
        if (child->type == clax_track_object) {
          cobj = (c_OBJECT *)child->object;
          for ( int i = 0; i < ind; i++ )
            printf( "  " );
          printf( "  %s\n", cobj->name );

          print_child( child, ind + 1 );
        }
      }
    }
  }
}


void
print_hierarchy( c_SCENE* scene )
{
  k_NODE      *node, *child;
  c_OBJECT    *obj,*cobj;

  printf( "\nHierarchy:\n" );

  for (node = scene->keyframer; node; node = node->next) {
    if (node->type == clax_track_object) {
      obj = (c_OBJECT *)node->object;
      if ( obj->parent == -1 ) { // root object
        printf( "%s\n", obj->name );
        for (child = node->child; child; child = child->brother) {
          if (child->type == clax_track_object) {

            cobj = (c_OBJECT *)child->object;
            printf( "  %s\n", cobj->name );

            print_child( child, 1 );

          }
        }
      }
    }
  }
  printf( "\n" );
}


void
copyScreen( char *dest, char *src, long len );
#pragma aux copyScreen = \
  " shr  ecx, 2         "\
  " cld                 "\
  " rep  movsd          "\
  parm [edi] [esi] [ecx] \
  modify exact [ecx esi edi];

void
setPalette()
{
  outp( 0x3c8, 0 );
  for ( int i = 0; i < 256; i++ ) {
    outp( 0x3c9, IE_globals.palette[i * 3 + 0] );
    outp( 0x3c9, IE_globals.palette[i * 3 + 1] );
    outp( 0x3c9, IE_globals.palette[i * 3 + 2] );
  }
}

void
clearScreen( char *dest, long len, long mask );
#pragma aux clearScreen = \
  " shr  ecx, 2          "\
  " cld                  "\
  " rep  stosd           "\
  parm [edi] [ecx] [eax]  \
  modify exact [ecx esi edi eax];


void
leave( c_SCENE *scene)
{
  printf("freeing world\n");
  clax_free_world(scene);
  printf("freeing motion\n");
  clax_free_motion(scene);
  closeIE();
  printf("OK!\n");
  exit(0);
}

#ifdef VESA
void error (char *msg, c_SCENE* scene)
{
  VBE_SetMode (3, 0, 1);
  printf ("Error: %s\n", msg);
  leave( scene );
}
#endif


void mode(int mode);
#pragma aux mode = \
 "int 10h" \
 parm [eax];


int
main( int argc, char *argv[] )
{
  c_SCENE  *scene;
  c_OBJECT *obj;
  w_NODE   *node;
  k_NODE   *kn;
  c_LIGHT  *lit;
  c_CAMERA *cam;
  c_VECTOR  vec;
  c_OBJECT *o1;
  int       err;
  int       i, j, x, y;
  float     frames, frame;
  
  int       IE_backgroundMask;

  char*       screen;
  ScreenMode  smode;

  unsigned long  tIn, tOut, frameCount;
  unsigned long* timer;

  unsigned long  updateTSC = 0;
  unsigned long  transformTSC = 0;
  unsigned long  processlightsTSC = 0;
  unsigned long  drawpolysTSC = 0;
  unsigned long  clearpageTSC = 0;
  unsigned long  copypageTSC = 0;
  unsigned long  sortTSC = 0;
  

  if ( argc < 2 ) {
    printf(" usage:\n");
    printf("   clax <filename.3ds> [-m<mode>] [-fog] [maxZ]\n");
    printf("   modes:  1  320x200x256\n");
    printf("           2  640x480x256\n");
    return -1;
  }

  IE_globals.maxZ = 1000.0;
  IE_globals.fogColor.r = 0.5;
   IE_globals.fogColor.b = 1.0;
  IE_globals.fogColor.g = 0.5;
  IE_globals.fogEnabled = 0;
  smode.x = 320;
  smode.y = 200;
  smode.bpp = 8;
  smode.aspectRatio = 0.82;
  IE_backgroundMask = 0x00000000;

  if ( argc > 2 ) {
    for ( i = 2; i < argc; i++ ) {
      if ( strcmp( argv[i], "-m2" ) == 0 || strcmp( argv[i], "/m2" ) == 0 ) {
        smode.x = 640;
        smode.y = 480;
        smode.bpp = 8;
        smode.aspectRatio = 1.0;
      } else if ( strcmp( argv[i], "-fog" ) == 0 || strcmp( argv[i], "/fog" ) == 0 ) {
        IE_globals.fogEnabled = 1;
      } else if ( isdigit( argv[i][0] ) )
        IE_globals.maxZ = atof( argv[i] );
    }
  }  

  IE_globals.depthCue = (3.0 / 4.0) * IE_globals.maxZ;
  IE_globals.fogDepth = (1.0 / 2.0) * IE_globals.maxZ;

  clax_init (clax_hierarchy | clax_domorph | clax_calcnorm);
  clax_alloc_scene (&scene);

  err = clax_load_world (argv[1],scene);
  if (err != clax_err_ok) {
    printf("error(after):%s\n",clax_geterror(err));
    return -1;
  }

  err = clax_load_motion (argv[1],scene);
  if (err != clax_err_ok) {
    printf("error(after): %s\n",clax_geterror(err));
    return -1;
  }
    
  clax_setactive_scene (scene);

  cam = 0;

  for (node = scene->world; node; node=node->next) {
    if (node->type == clax_obj_camera) {
      cam = (c_CAMERA *)node->object;
      break;
    }
  }

  if ( cam == 0 ) {
    printf( "No camera defined!\n");
    leave( scene );
  }
  printf( "Using camera: %s\n", cam->name );
  
  cam->sizeX = (float)smode.x;
  cam->sizeY = (float)smode.y;
  cam->aspectratio = smode.aspectRatio;
  clax_setactive_camera( cam );

  err = initIE();
  if ( err != clax_err_ok ) {
    printf("error(after): %s\n", clax_geterror(err));
    leave( scene );
  }


#ifdef VESA
  // set video mode
  VBE_Init();

  int mode = VBE_FindMode (smode.x, smode.y, smode.bpp);
  if ( mode == -1 ) error( "Screen mode not found", scene);
  if ( !VBE_IsModeLinear(mode)) error ("Mode is not linerar", scene);

  VBE_SetMode (mode, 1, 1);
  screen = VBE_GetVideoPtr (mode);
  if ( screen == 0 ) error ("LFB invalid", scene);
  VBE_ModeInfoBlock ModeInfo;
  VBE_Mode_Information (mode, &ModeInfo);

#else
  mode(0x13);
  screen = (char *)0xa0000;
#endif

  setPalette();

  if ( IE_globals.fogEnabled ) {
    char  c = bestMatch( IE_globals.fogColor.r * 62.5,
                         IE_globals.fogColor.g * 62.5,
                         IE_globals.fogColor.b * 62.5,
                         IE_globals.palette );
    IE_backgroundMask = (c << 24) | (c << 16) | (c << 8) | (c);
  }

  clearScreen( IE_globals.outBuffer, (int)cam->sizeY * IE_globals.outBufferWidth, IE_backgroundMask );

/*
  for ( i = 0; i < 64; i++ )
    for ( j = 0; j < 256; j++ ) {
      screen[i * smode.x + j] = IE_globals.shadeTable[j + i * 256];
    }

  for ( i = 0; i < 64; i++ )
    for ( j = 0; j < 256; j++ ) {
      screen[(i + 100) * smode.x + j] = IE_globals.fogTable[j + i * 256];
    }

  getch();
  
*/    

/*
  for (node = scene->world; node; node=node->next) {
    if ( node->type == clax_obj_material ) {
      char* ramp = ((c_MATERIAL *)(node->object))->color_ramp;
      for ( i = 0; i < 64; i++ ) {
        screen[0 * smode.x + i] = ramp[i];
        screen[1 * smode.x + i] = ramp[i];
        screen[2 * smode.x + i] = ramp[i];
        screen[3 * smode.x + i] = ramp[i];
        screen[4 * smode.x + i] = ramp[i];
      }
      getch();
    }
  }
*/

  frameCount = 0;
  timer = (unsigned long *) 0x046c;
  tIn = *timer;

  wah:
  clax_getframes(&frame, &frames);

  for ( ; frame < frames; frame += 1.0 ) {
    if ( inp( 0x60 ) == 1 ) {
#ifdef VESA
      VBE_SetMode (3, 0, 1);
#else
      mode( 0x03 );
#endif

//      print_hierarchy( scene );

      tOut = *timer;
      double  total;
      total = (double)(updateTSC + transformTSC + processlightsTSC + drawpolysTSC + clearpageTSC + copypageTSC);
//      printf( " %d materials\n", numMaterials );
      printf( " %d lights\n", numLights );
      printf( " %d faces, %d vertices\n", maxfaces, maxverts );
      printf( " cpu usage:\n" );
      printf( " - update:        %-3.1f%%\n", (double)updateTSC / total * 100 );
      printf( " - transform:     %-3.1f%%\n", (double)transformTSC / total * 100 );
      printf( " - radixsort:     %-3.1f%%\n", (double)sortTSC / total * 100 );
      printf( " - processlights: %-3.1f%%\n", (double)processlightsTSC / total * 100 );
      printf( " - drawpolys:     %-3.1f%%\n", (double)drawpolysTSC / total * 100 );
      printf( " - clearpage:     %-3.1f%%\n", (double)clearpageTSC / total * 100 );
      printf( " - copypage:      %-3.1f%%\n", (double)copypageTSC / total * 100 );
      printf( " fps %02.3f\n", ((float)(frameCount * 18.2) / (tOut - tIn)) );

      leave( scene );
    }

    StartTSC();
    clearScreen( IE_globals.outBuffer, (int)cam->sizeY * IE_globals.outBufferWidth, IE_backgroundMask );
    EndTSC(); clearpageTSC = TSC;

//    while ( (inp (0x3DA) & 8) == 8 );
//    while ( (inp (0x3DA) & 8) == 0 );

    clax_setframe( frame );

    StartTSC(); clax_update();        EndTSC(); updateTSC = TSC;
    StartTSC(); transform();          EndTSC(); transformTSC = TSC;
    StartTSC(); sort();               EndTSC(); sortTSC = TSC;
    StartTSC(); processLights();      EndTSC(); processlightsTSC = TSC;
    StartTSC(); drawPolys();          EndTSC(); drawpolysTSC = TSC;

    StartTSC();
    copyScreen( screen, IE_globals.outBuffer, (int)cam->sizeY * IE_globals.outBufferWidth );
    EndTSC(); copypageTSC = TSC;

    frameCount++;
  }
  goto wah;
}

