/* 256x256x32bits TEXTURE GENERATOR
 * fx routines - optimized for size
 * code by dake/calodox - July 99
 */

 //Y'a un bug grave dans le dilate.

#define uchar unsigned char 

#include <math.h>
 #include "nmldec.h"
 #include "nmlfx.h"
 #include "savehead.h"

/**************************************************************************/
void NML_FXSINUS(uchar *source, uchar *dest, float xamp, float xfreq,
                 float yamp, float yfreq)
     {
     float xn,yn;
     int   xf, yf;
     int  x,y;
     int off;

     for (x=0;x<256;x++)
         {
         for (y=0;y<256;y++)
             {
                xn=sin(y*xfreq*3.14/128.0)*xamp;
                yn=cos(x*yfreq*3.14/128.0)*yamp;
		xn+=(float) x;	
		yn+=(float) y;  
		xf=(int) xn;	xf&=255;
		yf=(int) yn;	yf&=255;

                off=xf+(yf<<8); off<<=2;
                *((long*) &dest[(x+(y<<8))<<2])=*((long*) &source[off]);
             }
        }
}

/**************************************************************************/

void NML_FXBUMP(uchar *source, uchar *dest, float bump_powaX,
                float bump_powaY, float bumplight)
     {
     int x,y;

     for (x=0;x<256;x++)
         {
         for (y=0;y<256;y++)
             {
             int n=(x+(y<<8))<<2;    //offset
             int nx,ny,i, col, difx, dify;

             for (i=0;i<3;i++)
		{
		int i1, i2, i3, i4;

                i1=i-4+n;       i1&=262143;
                i2=i+4+n;       i2&=262143;
		i3=i-1024+n;	i3&=262143;
		i4=i+1024+n;	i4&=262143;

                nx=source[i2]-source[i1];
                ny=source[i4]-source[i3];

		nx*=bump_powaX;
		ny*=bump_powaY;

                col=abs((x-128)-nx);    //merci fred pour ce code limpide =)
		if (col>127) col=127;		 
                difx=127-col;
		if (difx<0) difx=1;

                col=abs((y-128)-ny);
		if (col>127) col=127;
                dify=127-col;
		if (dify<0) dify=1;

                col=(difx+dify)*source[n+i]*bumplight;
		col>>=8;
		if (col>255) col=255;
                dest[n+i]=col;
		}
             }
         }
     }

/**************************************************************************/

void NML_FXDILATE(uchar *source, uchar *dest, float dilatepower)
     {
     int x,y;
     int nx,ny,i;
     float dist;


      for (x=0;x<256;x++)
          {
          for (y=0;y<256;y++)
              {
              int n=(x+(y<<8))<<2;    //offset

              for (i=0;i<3;i++)
                  {
                  int i1, i2, i3, i4;

                  i1=i-4+n;       i1&=262143;
                  i2=i+4+n;       i2&=262143;
                  i3=i-1024+n;    i3&=262143;
                  i4=i+1024+n;    i4&=262143;

                  nx=source[i1]-source[i2];
                  ny=source[i3]-source[i4];
                  dist=sqrt(nx*nx+ny*ny)*dilatepower;
                  dist+=source[n+i];
                  if (dist>255.0) dist=255.0;          
                  dest[n+i]=(uchar) dist;               
		}
             }
          }
       }

/**************************************************************************/

void NML_FXDISPLACE(uchar *source, uchar *dest, int dx, int dy)
     {
     int x,y;

      for (x=0;x<256;x++)
         {
         for (y=0;y<256;y++)
             { 
             int n=(x+(y<<8))<<2;    //offset
             int nx=x+dx; 
             int ny=y+dy; 

              ny&=255;
              nx&=255;
              *((long*) &dest[n])=*((long*) &source[(nx+(ny<<8))<<2]);
             }
         }
     }




