
 #include "main.h"
#include "matvect.h"
#include "vectors.h"
#include <math.h>



void MAT_ident(Matrix mat)
      {
       long a,b;

       for (b=0;b<4;b++)
           {
           for (a=0;a<4;a++)
               {
               if (a==b) {mat[a][b]=1;}
                    else {mat[a][b]=0;}
               }
           }
     }

void MAT_ident_scale(float xscale, float yscale, float zscale, Matrix mat)
      {
       long a,b;

       for (b=0;b<4;b++)
           {
           for (a=0;a<4;a++)
               {
               if (a==b) {mat[a][b]=1;}
                    else {mat[a][b]=0;}
               }
           }

	   mat[0][0]=xscale;
	   mat[1][1]=yscale;
	   mat[2][2]=zscale;
     }


void MAT_rot_cam(float a,  float b, float c,  Matrix mat)
      {
      Matrix rots, temp;
      long   i,j;
      float  ca=cos((float)a*3.14/128.0), cb=cos((float)b*3.14/128.0), cc=cos((float)c*3.14/128.0);
      float  sa=sin((float)a*3.14/128.0), sb=sin((float)b*3.14/128.0), sc=sin((float)c*3.14/128.0);
                                     
        rots[0][0]=cc*cb;
        rots[0][1]=sc*cb;
        rots[0][2]=-sb;
        rots[0][3]=0;

        rots[1][0]=cc*sb*sa-sc*ca;
        rots[1][1]=sc*sb+sa*ca*cc;
        rots[1][2]=sa*cb;
        rots[1][3]=0;

        rots[2][0]=cc*sb*ca+sc*sa;
        rots[2][1]=sc*sb*ca-cc*sa;
        rots[2][2]=ca*cb;
        rots[2][3]=0;

        rots[3][0]=0;
        rots[3][1]=0;
        rots[3][2]=0;
        rots[3][3]=1;

        MAT_mul(mat,rots, temp);                       // rots, mat

        for (i=0;i<4;i++)
            {
            for (j=0;j<4;j++)
                {
                 mat[i][j]=temp[i][j];
                }
             }
      }




void MAT_obj_mat(float a, float b, float c, Vect3D trans, Matrix rots)
      {
      float  ca=cos(a*3.14/128.0), cb=cos(b*3.14/128.0), cc=cos(c*3.14/128.0);
      float  sa=sin(a*3.14/128.0), sb=sin(b*3.14/128.0), sc=sin(c*3.14/128.0);

        rots[0][0]=cc*cb;
        rots[0][1]=sc*cb;
        rots[0][2]=-sb;
        rots[0][3]=0;

        rots[1][0]=cc*sb*sa-sc*ca;
        rots[1][1]=sc*sb*sa+ca*cc;
        rots[1][2]=sa*cb;
        rots[1][3]=0;

        rots[2][0]=cc*sb*ca+sc*sa;
        rots[2][1]=sc*sb*ca-cc*sa;
        rots[2][2]=ca*cb;
        rots[2][3]=0;

        rots[3][0]=trans.x;
        rots[3][1]=trans.y;
        rots[3][2]=trans.z;
        rots[3][3]=1;

      }


 void MAT_mul(Matrix mat1, Matrix mat2, Matrix res)
      {
      long i, j, k;
  
        for(i = 0; i < 4; i++) for(j = 0; j < 4; j++)
        for(k = 0, res[i][j] = 0; k < 4; k++)
        res[i][j] += mat1[i][k] * mat2[k][j];
      }


 void MAT_cam_matrix(Matrix m, Vect3D source, Vect3D target, unsigned char roll)
      {
      Vect3D C;
      float axexx, axexy, axexz;

	    C=Vect3D_Sub(target, source);
        C=Vect3D_Normalize(C);

        m[0][2]=C.x;                     
        m[1][2]=C.y;
        m[2][2]=C.z;

        axexx= -(C.z/sqrt(C.z*C.z + C.x*C.x));
        axexy=0.0;
        if (C.z==0.0) C.z=1.0;
        axexz= -((C.x*axexx)/C.z);

        m[0][0]=-axexx;
        m[1][0]=-axexy;
        m[2][0]=-axexz;
        m[0][1]=(axexy*C.z - axexz*C.y);
        m[1][1]=(axexz*C.x - axexx*C.z);
        m[2][1]=(axexx*C.y - axexy*C.x);
    
        m[0][3]=0;
        m[1][3]=0;
        m[2][3]=0;
        m[3][3]=1;

		m[3][0]=(source.x*m[0][0] + source.y*m[1][0] + source.z*m[2][0]);
		m[3][1]=( source.x*m[0][1] + source.y*m[1][1] + source.z*m[2][1]);
        m[3][2]=( source.x*m[0][2] + source.y*m[1][2] + source.z*m[2][2]);

        //MAT_rot_cam(0,0, roll, m);         // roll
      } 




void KF_Prout_Cam_Matrix( float roll, Vect3D r, Matrix mat ) {
    /* once again, thanx walken ;-) */
    float sa = sin(roll);
    float ca = cos(roll);
    float mca = 1-ca;

   mat[0][0]=r.x*r.x*mca + ca;
   mat[1][0]=r.x*r.y*mca + sa*r.z;
   mat[2][0]=r.x*r.z*mca - sa*r.y;

   mat[0][1]=r.x*r.y*mca - sa*r.z;
   mat[1][1]=r.y*r.y*mca + ca;
   mat[2][1]=r.z*r.y*mca + sa*r.x;

   mat[0][2]=r.z*r.x*mca + sa*r.y;
   mat[1][2]=r.z*r.y*mca - sa*r.x;
   mat[2][2]=r.z*r.z*mca + ca;


}



/*
 Ŀ
  Multiply a vector by a matrix                                            
 
*/

 void MAT_rotate_pt(Vect3D v, Vect3D *res, Matrix e)
      {
       res->x=e[0][0]*v.x + e[1][0]*v.y + e[2][0]*v.z + e[3][0];
       res->y=e[0][1]*v.x + e[1][1]*v.y + e[2][1]*v.z + e[3][1];
       res->z=e[0][2]*v.x + e[1][2]*v.y + e[2][2]*v.z + e[3][2];
      }

