
 #ifndef _3D_H_
 #define _3D_H_


 #include "main.h"
#include "matvect.h"

 #define uchar unsigned char 

 #define ulong unsigned long 


 /*----------------------------------------------------------------------*/
 /*----------------------------------------------------------------------*/
 /*                                                                      */
 /* R E N D E R I N G  structures - used by fillers                      */
 /*                                                                      */
 /*----------------------------------------------------------------------*/
 /*----------------------------------------------------------------------*/


  typedef struct
         {
           Vect3D       pos;          //position in float (for subpixel)
                                      //!!!! Z is 1/Z !!!!!!
           short        g;            //light at corner
           float        u,v,w;        //coord/z !!!!!
         } TRIG_vtx;

  typedef struct
         {

           uchar        rendering;    //rendering attrib. check 3dspc.txt
           uchar        side_attrib;  //side attribut (visible, d-sided)
           long         idx_vtx[3];
           TRIG_vtx     *vtx_list;
           uchar        *texture;
           FLOATcolor   wire_color;   //color if wireframe. 
           FLOATcolor   flat_color;   //color if flat 
         } TRIG_face;

 /*----------------------------------------------------------------------*/
 /*----------------------------------------------------------------------*/
 /*                                                                      */
 /* G E O M E T R Y  structures                                          */
 /*                                                                      */
 /*----------------------------------------------------------------------*/
 /*----------------------------------------------------------------------*/


  typedef struct
          {

            ulong   idx[3];                //indexes that points onto v_rotated and v_original  - on 'uv' too
            Vect3D  nrm; 
			Vect3D  trmnrm;					//transformed normal
          } Face_Data;

 /*----------------------------------------------------------------------*/


  typedef struct
          {

            Face_Data *f;                 //list of faces

            Vect3D      *v_original;
			Vect3D      *v_intermed;	  //an extra buffer..not always used but must be the link must be done between v_original and v_rotated.
            Vect3D      *v_rotated;    
			Vect3D      *uvw;			  // UV coords - used if needed
                                          
            Matrix    m;                  //matrix (must be filled)
            uchar     flag;               //flags 
            long      nbfaces;
            long      nbvtx;

          } Object_Data;


 /*----------------------------------------------------------------------*/

  #define MAX_LIGHTS    10

  typedef struct
         {

           uchar nb_l;                   //number of lights
           Vect3D  pos_l[MAX_LIGHTS];      //position of lights
           Vect3D  color_l[MAX_LIGHTS];    //color of lights
           float intens_l[MAX_LIGHTS];   //intensity between 0 and 1                         

         } OmniLight_Data;


   /*----------------------------------------------------------------------*/
  
   extern Object_Data SCN_SphereLow;
   extern Object_Data SCN_SphereMiddle;
   extern Object_Data SCN_SphereHigh;

   extern Object_Data sublandscape;


   void SPLINES_generate_points(Vect3D p1, Vect3D p2, Vect3D p3, Vect3D p4, int steps, Vect3D *result);

   void H3D_precalc();
   void H3D_allocate_obj(Object_Data *o, int nbfaces, int nbvtx);
   void H3D_transform_obj_matrix(Object_Data *o, Matrix m);
   void H3D_transform_intermed_obj_matrix(Object_Data *o, Matrix m);
   void H3D_render_object(Object_Data *o, long rendering_flags, GLuint texture_id, float alpha);
   void H3D_transform_blobby_obj(Object_Data *o, int fxtype, float scale, float param1);


    void H3D_transform_normal(Object_Data *o, Matrix m, unsigned char active);
	void H3D_render_volumetric(Object_Data *o, Vect3D color);

	void H3D_render_tv(Object_Data *o, float alpha, GLuint texture_id);
	void H3D_render_sea(Object_Data *o, float alpha, GLuint texture_id);

	void COMPUTE_sublandscape();

	void MEDUSE_put_bulles(float scalefactor, float t1, Matrix mfinal, Vect3D translate);


	void TESLA_do(float alpha, float size, float numberscale);
 #endif

               
