#ifndef _FLIB_H_
#define _FLIB_H_

#define F_COMPRESSED 1
#define F_OWNPACKED 2
#define F_OWNUNPACKED 4

struct direntry
{
	char name[32];
	int comp;
	int time;
	int len;
	int clen;
	int ofs;
};

extern direntry *libdir;
extern char *libdata;
extern int numlib;

int	openlib(char *fname);
void closelib();


struct FILE_
{
	int		open(char *fname, int comp=0); // comp is used in single file mode only
	int		read(void *buf, int c);
	void	close();
	int		seek(int pos);
	int		tell();
	char*	getbuf();

	FILE_()
	{
		mode=pos=0;
		packed=unpacked=unpackedbase=NULL;
	}
	~FILE_()
	{
		if (mode) close();
	}
	
	int mode;	// file mode
	int pos;	// position in file
	int len;	// length
	int clen;	// compressed length
	char *packed; // pointer to packed buffer
	char *unpacked; // pointer to unpacked buffer (not always valid)	
	char *unpackedbase; // virtual pointer to beginning of file
};



#endif