#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <bios.h>
#include <math.h>
#include <time.h>
#include "fixed.h"
#include "tri.h"
#include "vbe.h"
#include "print_v.h"

#define	PI			3.1415926535897932384626433832795
#define	WIDTH			320
#define	HEIGHT			200
#define	FOV			18.0f

#define	FALSE			0
#define	TRUE			1

#define	CULL_BACK		0		// cull methods
#define	CULL_FRONT		1

#define	FACE_CULL		TRUE
#define	FACE_CULL_METHOD	CULL_BACK

typedef struct _vector {
	float	x, y, z;
} vector;

typedef struct _tex_coord {
	float	pu, pv;
	float	tu, tv;
} tex_coord;

typedef struct _mesh {
	int		n_verts;
	int		n_faces;
	vector *	verts;
	vector *	norms;
	int *		faces;
	tex_coord *	texuv;
} mesh;

LPVBECLS	lpVBE;
unsigned long	video_lfb;
long *		back;
fixed *		zbuff;
long *		texture;
char		fps_buff[64];

clock_t		time0;
clock_t		time1;
clock_t		time2		= 0;

int		fps;
int		frame	= 0;

mesh		torus_low;
mesh		torus;

float		xr	= 0.0f;
float		yr	= 0.0f;

void free_mesh( mesh *m )
{
	if ( m->verts ) delete [] m->verts;
	if ( m->norms ) delete [] m->norms;
	if ( m->texuv ) delete [] m->texuv;
	if ( m->faces ) delete [] m->faces;
	m->n_verts = 0;
	m->n_faces = 0;
}

int alloc_mesh( mesh *m, int n_verts, int n_faces )
{
	free_mesh( m );
	m->n_verts = n_verts;
	m->n_faces = n_faces;
	m->verts = new vector [n_verts];  if ( !m->verts ) return FALSE;
	m->norms = new vector [n_verts];  if ( !m->norms ) return FALSE;
	m->texuv = new tex_coord [n_verts];  if ( !m->texuv ) return FALSE;
	m->faces = new int [n_faces * 3];  if ( !m->faces ) return FALSE;
	return TRUE;
}

void generate_normals( mesh *m, int flip )
{
	int	i;
	int	j0, j1, j2;
	float	ax, ay, az;
	float	bx, by, bz;
	float	nx, ny, nz, nl;
	for ( i = 0; i < m->n_verts; i++ ) {
		m->norms[i].x = 0;
		m->norms[i].y = 0;
		m->norms[i].z = 0;
	}
	for ( i = 0; i < m->n_faces; i++ ) {
		j0 = i * 3;
		j1 = j0 + 1;
		j2 = j0 + 2;
		ax = m->verts[m->faces[j2]].x - m->verts[m->faces[j0]].x;
		ay = m->verts[m->faces[j2]].y - m->verts[m->faces[j0]].y;
		az = m->verts[m->faces[j2]].z - m->verts[m->faces[j0]].z;
		bx = m->verts[m->faces[j1]].x - m->verts[m->faces[j0]].x;
		by = m->verts[m->faces[j1]].y - m->verts[m->faces[j0]].y;
		bz = m->verts[m->faces[j1]].z - m->verts[m->faces[j0]].z;
		nx = ay * bz - az * by;
		ny = az * bx - ax * bz;
		nz = ax * by - ay * bx;
		nl = sqrt( nx * nx + ny * ny + nz * nz );
		nx /= nl;
		ny /= nl;
		nz /= nl;
		m->norms[m->faces[j0]].x += nx;
		m->norms[m->faces[j0]].y += ny;
		m->norms[m->faces[j0]].z += nz;
		m->norms[m->faces[j1]].x += nx;
		m->norms[m->faces[j1]].y += ny;
		m->norms[m->faces[j1]].z += nz;
		m->norms[m->faces[j2]].x += nx;
		m->norms[m->faces[j2]].y += ny;
		m->norms[m->faces[j2]].z += nz;
	}
	for ( i = 0; i < m->n_verts; i++ ) {
		nx = m->norms[i].x;
		ny = m->norms[i].y;
		nz = m->norms[i].z;
		nl = sqrt( nx * nx + ny * ny + nz * nz );
		m->norms[i].x /= nl;
		m->norms[i].y /= nl;
		m->norms[i].z /= nl;
		if ( flip ) {
			m->norms[i].x = -m->norms[i].x;
			m->norms[i].y = -m->norms[i].y;
			m->norms[i].z = -m->norms[i].z;
		}
	}
}

int generate_torus( mesh *m, int segments, int sides, float radius1, float radius2 )
{
	float	a1, a2;
	int	i, j, k, n;
	if ( segments < 3 ) segments = 3;
	if ( sides < 3 ) sides = 3;
	if ( !alloc_mesh( m, segments * sides, (segments * sides) * 2 ) ) return FALSE;
	for ( k = 0, i = 0; i < segments; i++ ) {
		for ( j = 0; j < sides; j++ ) {
			a1 = i * (PI * 2.0f / segments);
			a2 = j * (PI * 2.0f / sides);
			m->verts[k].x = (cos( a2 ) * radius2 + radius1) * cos( a1 );
			m->verts[k].y = (cos( a2 ) * radius2 + radius1) * sin( a1 );
			m->verts[k].z = radius2 * sin( a2 );
			k++;
		}
	}
	for ( k = 0, n = 0, i = 0; i < segments; i++ ) {
		for ( j = 0; j < sides; j++ ) {
			m->faces[k * 3] = n + j;
			m->faces[k * 3 + 1] = (n + ((j + 1) % sides)) % m->n_verts;
			m->faces[k * 3 + 2] = (n + ((j + 1) % sides) + sides) % m->n_verts;
			k++;
			m->faces[k * 3] = (n + ((j + 1) % sides) + sides) % m->n_verts;
			m->faces[k * 3 + 1] = (n + j + sides) % m->n_verts;
			m->faces[k * 3 + 2] = n + j;
			k++;
		}
		n += sides;
	}
	return 1;
}

void project_2d( tri_vertex *p, vector *v )
{
	p->x = FLT_FIX( v->x * (FOV / (1.0f - v->z / FOV)) +  (WIDTH >> 1) );
	p->y = FLT_FIX( v->y * (FOV / (1.0f - v->z / FOV)) + (HEIGHT >> 1) );
	p->z = FLT_FIX( v->z * 10.0f );
}

void normalize( vector *v )
{
	float	vl;
	vl = sqrt( v->x * v->x + v->y * v->y + v->z * v->z );
	v->x /= vl;
	v->y /= vl;
	v->z /= vl;
}

float dot_product( vector *a, vector *b )
{
	return a->x * b->x + a->y * b->y + a->z * b->z;
}

void vertex_x_rotate( vector *v, float angle )
{
	vector	d;
	float	_sin, _cos;
	_sin = sin( angle );
	_cos = cos( angle );
	d.x = v->x;
	d.y = v->y *  _cos + v->z * _sin;
	d.z = v->y * -_sin + v->z * _cos;
	*v = d;
}

void vertex_y_rotate( vector *v, float angle )
{
	vector	d;
	float	_sin, _cos;
	_sin = sin( angle );
	_cos = cos( angle );
	d.x = v->x * _cos + v->z * -_sin;
	d.y = v->y;
	d.z = v->x * _sin + v->z *  _cos;
	*v = d;
}

void vertex_z_rotate( vector *v, float angle )
{
	vector	d;
	float	_sin, _cos;
	_sin = sin( angle );
	_cos = cos( angle );
	d.x = v->x *  _cos + v->y * _sin;
	d.y = v->x * -_sin + v->y * _cos;
	d.z = v->z;
	*v = d;
}

void rotate_mesh( mesh *m, float xa, float ya, float za )
{
	for ( int i = 0; i < m->n_verts; i++ ) {
		vertex_x_rotate( &m->verts[i], xa );
		vertex_y_rotate( &m->verts[i], ya );
		vertex_z_rotate( &m->verts[i], za );
		vertex_x_rotate( &m->norms[i], xa );
		vertex_y_rotate( &m->norms[i], ya );
		vertex_z_rotate( &m->norms[i], za );
	}
}

void draw_mesh( mesh *m )
{
	int		i, i3;
	tri_vertex	verts_2d[3];
	vector		light_dir	= { -1.0f, -1.0f, 2.0f };
	int		v0, v1, v2;
	float		s0, s1, s2;

	normalize( &light_dir );

	for ( i = 0; i < m->n_faces; i++ ) {
		i3 = i * 3;
		v0 = m->faces[i3];
		v1 = m->faces[i3 + 1];
		v2 = m->faces[i3 + 2];

		project_2d( &verts_2d[0], &m->verts[v0] );
		project_2d( &verts_2d[1], &m->verts[v1] );
		project_2d( &verts_2d[2], &m->verts[v2] );

		// backface-cull
		if ( FACE_CULL ) {
			float	v1, w1, v2, w2, o;
			v1 = FIX_FLT( verts_2d[2].x ) - FIX_FLT( verts_2d[1].x );
			w1 = FIX_FLT( verts_2d[0].x ) - FIX_FLT( verts_2d[1].x );
			v2 = FIX_FLT( verts_2d[2].y ) - FIX_FLT( verts_2d[1].y );
			w2 = FIX_FLT( verts_2d[0].y ) - FIX_FLT( verts_2d[1].y );
			o = v1 * w2 - v2 * w1;
			if ( FACE_CULL_METHOD == CULL_BACK ) {
				if ( o > 0.0f ) continue;
			} else if ( FACE_CULL_METHOD == CULL_FRONT ) {
				if ( o <= 0.0f ) continue;
			}
		}

		verts_2d[0].pu = FLT_FIX( m->texuv[v0].pu );
		verts_2d[0].pv = FLT_FIX( m->texuv[v0].pv );
		verts_2d[1].pu = FLT_FIX( m->texuv[v1].pu );
		verts_2d[1].pv = FLT_FIX( m->texuv[v1].pv );
		verts_2d[2].pu = FLT_FIX( m->texuv[v2].pu );
		verts_2d[2].pv = FLT_FIX( m->texuv[v2].pv );

		verts_2d[0].tu = FLT_FIX( m->texuv[v0].tu );
		verts_2d[0].tv = FLT_FIX( m->texuv[v0].tv );
		verts_2d[1].tu = FLT_FIX( m->texuv[v1].tu );
		verts_2d[1].tv = FLT_FIX( m->texuv[v1].tv );
		verts_2d[2].tu = FLT_FIX( m->texuv[v2].tu );
		verts_2d[2].tv = FLT_FIX( m->texuv[v2].tv );

		tri_z_texbl_phong( &verts_2d[0], &verts_2d[1], &verts_2d[2] );
	}
}

void scale_mesh( mesh *m, float sx, float sy, float sz )
{
	for ( int i = 0; i < m->n_verts; i++ ) {
		m->verts[i].x *= sx;
		m->verts[i].y *= sy;
		m->verts[i].z *= sz;
	}
}

void generate_chrome_uv( mesh *m, float max_u, float max_v )
{
	for ( int i = 0; i < m->n_verts; i++ ) {
		m->texuv[i].tu = (m->norms[i].x * 0.5f + 0.5f) * max_u;
		m->texuv[i].tv = (m->norms[i].y * 0.5f + 0.5f) * max_v;
	}
}

void generate_phong_uv( mesh *m )
{
	vector	n;
	for ( int i = 0; i < m->n_verts; i++ ) {
		n = m->norms[i];
		vertex_x_rotate( &n, PI / 8.0f );
		vertex_y_rotate( &n, -PI / 8.0f );
		m->texuv[i].pu = (n.x + 1.0f) * 128.0f;
		m->texuv[i].pv = (n.y + 1.0f) * 128.0f;
	}
}

void main( void )
{
	int	page256k;
	int	vbe_ver;
	int	i, j, key;
	float	a = 0.0f;

	vbe_ver = CreateVBEClass( &lpVBE );

	// allocate z-buffer
	zbuff = new fixed [WIDTH * HEIGHT];
	if ( !zbuff ) return;

	texture = new long [256 * 256];
	for ( int vv = 0; vv < 256; vv++ )
	for ( int uu = 0; uu < 256; uu++ ) {
//		texture[(vv << 8) + uu] = (((vv >> 3) + (uu >> 3)) & 1) ? 0x00ffff : 0;
		texture[(vv << 8) + uu] = ((long)(rand() % 200) << 8) | 0xff0000;
	}

	if ( !generate_torus( &torus, 16, 8, 3.0f, 1.5f ) ) return;
//	if ( !generate_torus( &torus, 32, 16, 3.0f, 2.0f ) ) return;
	scale_mesh( &torus, 1.5f, 1.5f, 1.5f );
	generate_normals( &torus, FALSE );

	lpVBE->InitMode( 0x410f, &video_lfb );
	print_v_set_back( (long *)video_lfb );
	tri_init();
	tri_set_clip( 0, 0, WIDTH, HEIGHT );
	tri_set_back( (long *)video_lfb );
	tri_set_zbuff( zbuff );
	tri_set_texture( texture );

	time0 = clock();
	while ( 1 )
	{
		page256k = (lpVBE->GetCurrentPage() ^ 1) * (WIDTH * HEIGHT * 4);
		back = (unsigned long *)(video_lfb + page256k);
		tri_set_back( back );
		print_v_set_back( back );

		if ( _bios_keybrd( _KEYBRD_READY ) ) {
			key = _bios_keybrd( _KEYBRD_READ ) >> 8;
		} else key = 0;
		if ( key == 1 ) break;
		else {
			switch ( key ) {
				case 0x39: xr = 0.0f; yr = 0.0f; break;
				case 0x48: xr -= 0.05f; break;
				case 0x50: xr += 0.05f; break;
				case 0x4b: yr -= 0.05f; break;
				case 0x4d: yr += 0.05f; break;
			}
		}
		rotate_mesh( &torus, xr, yr, 0.0f );
		xr /= 1.005f;
		yr /= 1.005f;

		for ( int i = 0; i < 64000; i++ ) {
			back[i] = 0xaabbccdd;
			zbuff[i] = 0x8fffffff;
		}

		generate_chrome_uv( &torus, 31.0f, 31.0f );
		generate_phong_uv( &torus );
		draw_mesh( &torus );

		// Show FPS
		time1 = clock();
		time2 += time1 - time0;
		fps = (int)((float)frame / ((float)time2 / (float)CLOCKS_PER_SEC));
		time0 = time1;
		if ( fps < 0 ) fps = 0;
		itoa( fps, fps_buff, 10 );
		print_v( 10, 5, "FPS: ", 0xff, 0, 1 );
		print_v( 40, 5, fps_buff, 0xff, 0, 1 );

		lpVBE->SwapPages();
		lpVBE->WaitVSync();

		a += PI / 1000.0f;
		frame++;
	}
	lpVBE->InitMode( 0, 0 );
	printf( "VBE Version: %d.%d\n", vbe_ver >> 8, vbe_ver & 0xff );
	printf( "LFB at: %#10x\n", lpVBE->GetPhysBase() );
}
