#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include <dos.h>
#include <mem.h>
#include "fixed.h"

#define		PI		3.1415926535897932384626433832795

#define		WIDTH		320
#define		HEIGHT		200
#define		WIDTH_1		0xcc		// 1 / WIDTH (fixed)
#define		HEIGHT_1	0x147		// 1 / HEIGHT (fixed)

char *		back;
char *		video		= (char *)0xa0000;
char		texture[64 * 64];

inline int my_abs( register int a ) { return (a > 0 ? a : -a); }

inline fixed cubic( fixed a )
{
	return FixMul( FixMul( a, a ), INT_FIX( 3 ) - FixMul( INT_FIX( 2 ), a ) );
}

// new
void bump_fx( int xlight, int ylight )
{
	int	off, c;
	int	xp, yp, i, j, nx, ny;
	fixed	fnx, fny;
	off = 321;
	yp = -ylight;
	for ( i = 1; i < 199; i++ ) {
		xp = -xlight;
		for ( j = 1; j < 319; j++ ) {
			nx = back[off +   1] - back[off -   1];
			ny = back[off + 320] - back[off - 320];
			xp++;
			nx = 63 - my_abs( nx - xp ); if ( nx < 0 ) nx = 0;
			ny = 63 - my_abs( ny - yp ); if ( ny < 0 ) ny = 0;
			fnx = cubic( INT_FIX( nx ) >> 6 );
			fny = cubic( INT_FIX( ny ) >> 6 );
			c = FIX_INT( FixMul( FixMul( fnx, fny ), INT_FIX( 70 ) ) );
			if ( c > 255 ) c = 255;
			video[off] = c;
			off++;
		}
		yp++;
		off += 2;
	}
}

// old
/*void bump_fx( int xlight, int ylight )
{
	int	off, c;
	int	xp, yp, i, j, nx, ny;
	off = 321;
	yp = -ylight;
	for ( i = 1; i < 199; i++ ) {
		xp = -xlight;
		for ( j = 1; j < 319; j++ ) {
			nx = back[off +   1] - back[off -   1];
			ny = back[off + 320] - back[off - 320];
			xp++;
			nx = 110 - my_abs( nx - xp ); if ( nx < 0 ) nx = 0;
			ny = 110 - my_abs( ny - yp ); if ( ny < 0 ) ny = 0;
			c = (nx * ny) >> 7;
			if ( c > 255 ) c = 255;
			video[off] = c;
			off++;
		}
		yp++;
		off += 2;
	}
}*/

void filter_texture( fixed us, fixed vs )
{
	int	x, y, j;
	fixed	u0, v0, u1, v1;
	fixed	u, v, du, dv;

	u0 = (INT_FIX( 63 ) - us) >> 1; u1 = INT_FIX( 63 ) - u0;
	v0 = (INT_FIX( 63 ) - vs) >> 1; v1 = INT_FIX( 63 ) - v0;

	du = FixMul( u1 - u0, WIDTH_1 );
	dv = FixMul( v1 - v0, HEIGHT_1 );

	j = 0;
	for ( y = 0, v = v0; y < HEIGHT; y++, v += dv )
	for ( x = 0, u = u0; x < WIDTH; x++, u += du ) {
		int	i;
		fixed	fu, fv;
		fixed	c0, c1, c2, c3;
		i = ((v >> 10) & 0xfc0) + (u >> 16);
		fu = u & 0xffff;
		fv = v & 0xffff;
		c0 = INT_FIX( texture[i] );
		c1 = INT_FIX( texture[i + 1] );
		c2 = INT_FIX( texture[i + 64] ) - c0;
		c3 = INT_FIX( texture[i + 65] ) - c1;
		c2 = c0 + FixMul( cubic( fv ), c2 );
		c3 = c1 + FixMul( cubic( fv ), c3 );
		back[j] = FIX_INT( c2 + FixMul( cubic( fu ), c3 - c2 ) );
		j++;
	}
}

void fade_pal( char r0, char g0, char b0, char r1, char g1, char b1, int c0, int c1 )
{
	int	i;
	long	dr, dg, db, dc, r, g, b;
	r = r0 << 8;
	g = g0 << 8;
	b = b0 << 8;
	dc = c1 - c0;
	dr = ((r1 - r0) << 8) / dc;
	dg = ((g1 - g0) << 8) / dc;
	db = ((b1 - b0) << 8) / dc;
	for ( i = c0; i <= c1; i++ ) {
		outp( 0x3c8, i );
		outp( 0x3c9, r >> 8 );
		outp( 0x3c9, g >> 8 );
		outp( 0x3c9, b >> 8 );
		r += dr;
		g += dg;
		b += db;
	}
}

void main( void )
{
	float	a = 0.0f;
	float	b = 0.0f;

	back = new char [WIDTH * HEIGHT];
	if ( !back ) return;

	__asm {	mov	ax, 0x13
		int	0x10
	}

	for ( int y = 0; y < 64; y++ )
	for ( int x = 0; x < 64; x++ )
	texture[64 * y + x] = rand() % 128;

	// Nice spec. pal.
	fade_pal(  0,  0,  0,  24, 53, 44,   0,  63 );
	fade_pal( 24, 53, 44,  63, 63, 63,  64, 127 );

	while ( !kbhit() ) {
		filter_texture( FLT_FIX( sin( a ) * 15.0f + 38.0f ),
				FLT_FIX( cos( a ) * 15.0f + 38.0f ) );

		bump_fx( sin( a + cos( a * 0.31f ) ) * 60.0f + 160.0f,
			 cos( a + sin( a * 0.33f ) ) * 50.0f + 100.0f );

//		memcpy( video, back, 64000 );

		a += 0.02f;
		b += 0.1f;
	}

	__asm {	mov	ax, 3
		int	0x10
	}
}
