#include "ZipFile.h"
#include <io.h>
#include <malloc.h>


CZipFile::CZipFile(const char *filename) :
	CCompressedFile(filename, "zip"),
	m_unzFile(0)
{

	if (m_filename) {
		
		m_unzFile = unzOpen(m_filename);
		resetFileList();
	}

	m_filenameBuffer = new char[1000];
}


CZipFile::~CZipFile() {

	if (m_unzFile) {
		unzClose(m_unzFile);
	}

	delete [] m_filenameBuffer;
}
 

void CZipFile::resetFileList() {

	if (m_unzFile)
		unzGoToFirstFile(m_unzFile);
}

int	CZipFile::getFile(void *output, unsigned long *size, const char *filename) {

	strcpy(m_filenameBuffer, filename);
	int len = strlen(m_filenameBuffer);
	//reverse all backward slashes to forward
	for (int i=0; i<len; i++)
			m_filenameBuffer[i] = m_filenameBuffer[i]=='\\' ? '/' : m_filenameBuffer[i];

	int success = unzLocateFile(m_unzFile, m_filenameBuffer, 2);
	if (success==UNZ_OK) {

		unz_file_info info;		
		unzGetCurrentFileInfo(m_unzFile, &info, 0, 0, 0, 0, 0, 0);
		unzOpenCurrentFile(m_unzFile);

		void **bla   = (void **)output;
//		bla  		= new char[info.uncompressed_size];
		*bla        = malloc(info.uncompressed_size);
		*size		= info.uncompressed_size;

		unsigned int a = *size;
		int numBytes = unzReadCurrentFile(m_unzFile, *bla, a);
		unzCloseCurrentFile(m_unzFile);
		if (numBytes==(int)*size)
			return 0;
		else 
			return numBytes;
	}

	return 1;
}


bool CZipFile::getNextFile() {

	int i = unzGoToNextFile(m_unzFile);
	if (i==UNZ_END_OF_LIST_OF_FILE) {
		return false;
	} else {
		return true;
	}
}

char *CZipFile::getFilename() {

	unzGetCurrentFileInfo(m_unzFile, 0, m_filenameBuffer, 1000, 0, 0, 0, 0);
	int len = strlen(m_filenameBuffer);
	//reverse all forward slashes to backward 
	for (int i=0; i<len; i++)
		m_filenameBuffer[i] = m_filenameBuffer[i]=='/' ? '\\' : m_filenameBuffer[i];

	return m_filenameBuffer;
}

bool CZipFile::isDirectory() {
	unz_file_info info;		
	unzGetCurrentFileInfo(m_unzFile, &info, 0, 0, 0, 0, 0, 0);
	return ((info.external_fa&_A_SUBDIR)!=0);
}

bool CZipFile::isHidden() {
	unz_file_info info;		
	unzGetCurrentFileInfo(m_unzFile, &info, 0, 0, 0, 0, 0, 0);
	return ((info.external_fa&_A_HIDDEN)!=0);
}

bool CZipFile::fileExists(const char *filename) {
	int success = unzLocateFile(m_unzFile, filename, 2);
	return (success==UNZ_OK);		
}	