#pragma once


#include "ansifont.h"
#include "ImageRenderer.h"
#include "ImageData.h"
#include "ImageContext.h"
#include "StdAfx.h"


class CTextRenderer : public CImageRenderer {

private:
	CSize			m_lineBufferSize;
	unsigned int	*m_lineBufferUI;
	BITMAPINFO		*m_lineBufferBI;
	int				m_lastTopLine, m_lastBottomLine, m_lastRightCol, m_lastLeftCol;

	void		renderChars(CImageContext *, CAnsiFont *, ANSIPalette *, char, const char *, int, int, unsigned int *);
	/*! render the line with 9 pixel width, two different procs because the functionality is in the inner loop */
	void		renderChars9(CImageContext *, CAnsiFont *, ANSIPalette *, char, const char *, int, int, unsigned int *);

public:

	CTextRenderer();
	~CTextRenderer();

	void	setImage(CImageContext *, CImageData *);
	int		invalidateRect(CImageContext *, CImageData *, CRect, int &, int &);
	int		invalidateRectAnimation(CImageContext *, CImageData *, CRect, int &, int &);
	int		getWidth(CImageContext *context, CImageData *);
	int		getHeight(CImageContext *context, CImageData *);
};