// LeftView.cpp : implementation of the CLeftView class
//

#include "stdafx.h"
//#include "DirTreeDemo.h"

#include "AcidViewDoc.h"
#include "LeftView.h"
#include "resource.h"
#include "fileextdlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLeftView

IMPLEMENT_DYNCREATE(CLeftView, CView)

BEGIN_MESSAGE_MAP(CLeftView, CView)
	//{{AFX_MSG_MAP(CLeftView)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLeftView construction/destruction

CLeftView::CLeftView() {
}

CLeftView::~CLeftView() {
	AfxGetApp()->WriteProfileString(_T("Settings"), _T("fileMask"), GetFileMask());
}

BOOL CLeftView::PreCreateWindow(CREATESTRUCT& cs) {
	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CLeftView drawing

void CLeftView::OnDraw(CDC* pDC) {
	CAcidViewDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
}

/////////////////////////////////////////////////////////////////////////////
// CLeftView printing


void CLeftView::OnInitialUpdate() {
	CView::OnInitialUpdate();
}

/////////////////////////////////////////////////////////////////////////////
// CLeftView diagnostics

#ifdef _DEBUG
void CLeftView::AssertValid() const {
	CView::AssertValid();
}

void CLeftView::Dump(CDumpContext& dc) const {
	CView::Dump(dc);
}

CAcidViewDoc* CLeftView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CAcidViewDoc)));
	return (CAcidViewDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CLeftView message handlers

BOOL CLeftView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	BOOL bRet = CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);

	// this part creates the TreeCtrl and use the CLeftView
	// as his parent Window
	if (m_DirTree.m_hWnd == NULL && bRet)
	{
		bRet = m_DirTree.Create( WS_CHILD | TVS_LINESATROOT | TVS_HASBUTTONS | WS_VISIBLE | TVS_HASLINES, 
			                     CRect(0, 0, 0, 0), this, ID_TREECTRL );

		if ( bRet ) {

			m_DirTree.m_fileMask = AfxGetApp()->GetProfileString(_T("Settings"), _T("fileMask"), _T("*.*"));
			DWORD length = GetCurrentDirectory(0, NULL);
			char *s = new char[length+1];
			GetCurrentDirectory(length+1, s);
			m_DirTree.DisplayTree( s, TRUE );
			delete [] s;
		}
	}

	return bRet;
}

void CLeftView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	if ( m_DirTree.m_hWnd )
		m_DirTree.SetWindowPos( NULL, 0, 0, cx, cy, SWP_NOZORDER | SWP_NOMOVE );
}

int CLeftView::JumpToDir(LPCTSTR dir, BOOL setSel) {
	return m_DirTree.JumpToDir(dir, setSel);
}

void CLeftView::OpenNext() {
	m_DirTree.OpenNext();
}

void CLeftView::OpenPrevious() {
	m_DirTree.OpenPrevious();
}

void CLeftView::SetFileMask()
{
	
	CFileExtDlg dlg;
	dlg.loadRegistryValues(AfxGetApp());
	dlg.m_mask = GetFileMask();

	if (dlg.DoModal()==IDOK) {
		dlg.m_mask.MakeLower();
		CString ext = dlg.m_mask;

		CString s[6];
		s[0] = ext;
		int numFound = 1;
		for (int i=0; i<dlg.m_numExtensions; i++) {
			s[i+1] = "*.*";
			if (dlg.m_extensions[i]!="*.*" && 
				dlg.m_extensions[i]!=ext)
				s[numFound++] = dlg.m_extensions[i];
		}

		for (i=0; i<5; i++) {
			dlg.m_extensions[i] = s[i];
		}

		dlg.setRegistryValues(AfxGetApp());

		m_DirTree.SetFileMask(ext);
	} 	
}

CString CLeftView::GetFileMask() {
	return m_DirTree.m_fileMask;
}

BOOL CLeftView::SetSelPath(LPCTSTR strPath) {
	return m_DirTree.SetSelPath(strPath);
}

CString CLeftView::GetSelected() {
	return m_DirTree.GetSelected();
}

CString CLeftView::GetRoot() {
	return m_DirTree.m_strRoot;
}