#include "GifLoader.h"

extern "C" {
#include <gif_lib/gif_lib.h>
}

CGifLoader::CGifLoader(CImageRenderer *renderer) :
	CBinaryLoader(renderer)
{
	
}


CGifLoader::~CGifLoader() {
	
}


bool CGifLoader::isFileType(const char *signature, const char *filename) {
	
	if (strnicmp(signature,"gif",3)==0) {
		return true;
	}
	return false;
}


static int
InterlacedOffset[] = { 0, 4, 2, 1 }, /* The way Interlaced image should. */
InterlacedJumps[] = { 8, 8, 4, 2 };    /* be read - offsets and jumps... */


const char *g_data;
int   g_offset;

extern "C" {
int readFunc(GifFileType *GifFile, unsigned char *buf, int length) {

	memcpy(buf, g_data+g_offset, length);
	g_offset+=length;
	return length;
}
}

void CGifLoader::loadFileFromDataImp(const char *data, const int length, CImageData *imageData) {
	
	CBinaryData *binaryData = (CBinaryData *)imageData;
	binaryData->m_fileType  = JPEG;

	g_offset = 0;
	g_data   = data;

	GifFileType *gif = DGifOpen((void *)data, &readFunc);
	if (!gif) 
		return;
	int code = DGifSlurp(gif);
	if (code!=GIF_OK) 
		return;
	
	if (!gif->SColorMap) {
		return;
	}
	
	unsigned char *dst = new unsigned char[gif->SWidth*gif->SHeight*4];
	/*! \todo check about the interlacing */
	/*! \todo check setting the background color */
	int res     = gif->SColorResolution;
	int interlace = gif->Image.Interlace;
	
	char *src = gif->SavedImages[0].RasterBits;
	if (interlace==0) {
		
		unsigned char *dst2 = dst;
		for (int i=0; i<gif->SWidth*gif->SHeight; i++, dst2+=4, src++) {
			
			GifColorType col = gif->SColorMap->Colors[(unsigned char)*src];
			
			dst2[2] = col.Red;
			dst2[1] = col.Green;
			dst2[0] = col.Blue;
			dst2[3] = 0xFF;
		}
	} else {
		
		//for each image pass
		for (int k=0; k<4; k++) {
			for (int i=InterlacedOffset[k]; i<gif->SHeight; i+=InterlacedJumps[k]) {
				unsigned char *dst2 = dst+i*gif->SWidth*4;
				for (int j=0; j<gif->SWidth; j++, src++, dst2+=4) {
					
					GifColorType col = gif->SColorMap->Colors[(unsigned char)*src];
					
					dst2[2] = col.Red;
					dst2[1] = col.Green;
					dst2[0] = col.Blue;
					dst2[3] = 0xFF;
				}
			}
		}
	}
	
	binaryData->m_width  = gif->SWidth;
	binaryData->m_height = gif->SHeight;


	unsigned char *line = new unsigned char[binaryData->m_width*4];
	int offset  = 0;
	int offset2 = (binaryData->m_height-1)*binaryData->m_width*4; 
	for (int i=0; i<binaryData->m_height/2; i++) {
		memcpy(line,		dst+offset,		binaryData->m_width*4);
		memcpy(dst+offset,	dst+offset2,	binaryData->m_width*4);
		memcpy(dst+offset2,	line,			binaryData->m_width*4);
		offset  += binaryData->m_width*4;
		offset2 -= binaryData->m_width*4;
	}
	delete [] line;
	
	BITMAPINFO bi;
	bi.bmiHeader.biSize			= sizeof(BITMAPINFOHEADER);
	bi.bmiHeader.biPlanes		= 1;
	bi.bmiHeader.biBitCount		= 32;
	bi.bmiHeader.biCompression	= BI_RGB;
	bi.bmiHeader.biSizeImage	= 0;
	bi.bmiHeader.biXPelsPerMeter= 1;
	bi.bmiHeader.biXPelsPerMeter= 1;
	bi.bmiHeader.biClrUsed		= 0;
	bi.bmiHeader.biClrImportant	= 0;
	bi.bmiHeader.biWidth		= binaryData->m_width;
	bi.bmiHeader.biHeight		= binaryData->m_height;

	CDC dc;
	dc.CreateCompatibleDC(NULL); 
	binaryData->m_bitmap = new CBitmap();
	binaryData->m_bitmap->CreateBitmap(binaryData->m_width, binaryData->m_height, dc.GetDeviceCaps(PLANES), dc.GetDeviceCaps(BITSPIXEL), NULL);
	::SetDIBits(dc.GetSafeHdc(), *binaryData->m_bitmap, 0, binaryData->m_height, dst, &bi, DIB_RGB_COLORS);
	
	delete [] dst;
	DGifCloseFile(gif);
} 

