#include "CompressedFileFactory.h"
#include "ZipFile.h"
#include "RarFile.h"
#include <string.h>

//Max size of the openedFiles deque
#define MAX_OPENED_FILES	10
using namespace std;


CCompressedFileFactory *CCompressedFileFactory::m_factory = 0;


CCompressedFileFactory *CCompressedFileFactory::getFactory() {

	if (!m_factory) {
		m_factory = new CCompressedFileFactory();
	}
	
	return m_factory;
}


CCompressedFileFactory::CCompressedFileFactory() {


}


CCompressedFileFactory::~CCompressedFileFactory() {

	for(deque<CCompressedFile *>::iterator i=m_openedFiles.begin(); i!=m_openedFiles.end(); i++) {
		delete (*i);
	}
}


CCompressedFile *CCompressedFileFactory::loadFileImp(const char *filename) {

	//seek the period from the back
	int i = strlen(filename);
	do {

		do {
			i--;
		} while(i>=0 && filename[i]!='.');

		/*! going by extensions because this is called a lot... for every file listed */
		if (strnicmp(filename+i,".zip",4)==0) {
			return new CZipFile(filename);
		} else if (strnicmp(filename+i,".rar",4)==0) {
			return new CRarFile(filename);
		} 	

	} while(i>0);

	return 0;
}


CCompressedFile *CCompressedFileFactory::loadFile(const char *filename) {
	
	//Check to see if the file is already loaded
	for(deque<CCompressedFile *>::iterator i=m_openedFiles.begin(); i!=m_openedFiles.end(); i++) {

		//if found to be already opened
		if (strcmp(filename, (*i)->getCompressedFilename())==0) {
			CCompressedFile *cfile = (*i);

			//if this is not the last file in the deque, erase it and add it to the end
			//so it will be popped later
			if ((i+1)!=m_openedFiles.end()) {
				m_openedFiles.erase(i);
				m_openedFiles.push_back(cfile);
			} 

			return cfile;
		}
	}

	//Else load up the new file
	CCompressedFile *cfile = loadFileImp(filename);

	//If valid add to the deque
	if (cfile) {
		m_openedFiles.push_back(cfile);

		//if too many opened files, pop the least recently used
		if (m_openedFiles.size()>MAX_OPENED_FILES)
			m_openedFiles.pop_front();
	}

	return cfile;
}


inline bool isCompressedExtension(const char *ext) {

	/*! going by extensions because this is called a lot... for every file listed */
	if (strnicmp(ext, "zip", 3)==0) {
		return true;
	} else if (strnicmp(ext, "rar", 3)==0) {
		return true;
	}

	return false;
}


bool CCompressedFileFactory::containsCompressedFile(const char *filename) {

	//Seek the period from the back working through the entire path name because
	//	of subdirs in compressed files
	int i = strlen(filename);
	do {

		do {
			i--;
		} while(i>=0 && filename[i]!='.');
		
		if (isCompressedExtension(filename+i+1))
			return true;

	} while(i>0);

	return false;
}

bool CCompressedFileFactory::isCompressedFile(const char *filename) {

	//Seek the period from the back working through the entire path name because
	//	of subdirs in compressed files
	int i = strlen(filename);
	do {
		i--;
	} while(i>=0 && filename[i]!='.' && filename[i]!='\\');
		
	return isCompressedExtension(filename+i+1);
}


int CCompressedFileFactory::getFile(void *buffer, unsigned long *size, const char *filename) {

	int i=0;
	int len = strlen(filename);
	CCompressedFile *cfile = 0;
	/*! \note max path 200 chars */
	static char temp[200];

	//Seek the compressed file that has the file
	/*! \todo implement ability to open compressed files inside compressed files */	
	do {

		//Seek an extension
		while(i<(len+1) && filename[i]!='.') {
			i++;
		}

		//If the extension of a compressed file  
		if (isCompressedExtension(filename+i+1)) {

			//Seek the backslash to get the name of the compressed file
			while(i<(len+1) && filename[i]!='\\') {
				i++;
			}
			
			//If reached the end of the filename, return 0;
			if (i==(len+1))
				return -1;

			memcpy(temp, filename, i+1);
			temp[i] = '\0';

			cfile = loadFile(temp);
			if (!cfile) 				
				return -1;
			
			cfile->getFile(buffer, size, filename+i+1);
			return 0;
		}

		i++;
	} while(i<(len+1));

	return -1;
}

bool CCompressedFileFactory::fileExists(const char *filename) {


	int i=0;
	int len = strlen(filename);
	CCompressedFile *cfile = 0;
	/*! \note max path 200 chars */
	static char temp[200];

	//Seek the compressed file that has the file
	/*! \todo implement ability to open compressed files inside compressed files */	
	do {

		//Seek an extension
		while(i<(len+1) && filename[i]!='.') {
			i++;
		}

		//If the extension of a compressed file  
		if (isCompressedExtension(filename+i+1)) {

			//Seek the backslash to get the name of the compressed file
			while(i<(len+1) && filename[i]!='\\') {
				i++;
			}
			
			//If reached the end of the filename, return 0;
			if (i==(len+1))
				return false;

			memcpy(temp, filename, i+1);
			temp[i] = '\0';

			cfile = loadFile(temp);
			if (!cfile) 				
				return false;
						
			return cfile->fileExists(filename+i+1);
		}

		i++;
	} while(i<(len+1));

	return false;

}