/*
  Based on:
  PSX VAG-Packer, hacked by bITmASTER@bigfoot.com
*/

//#include <tamtypes.h>
//#include <math.h>

static inline float fabs(float x)
{
  if(x>=0)return x;
  else return -x;
}

#include "vag.h"

#define BUFFER_SIZE 20000*28

short wave[BUFFER_SIZE];

static double f[5][2] =
  {	{    0.0 , 0.0	},
   	{  -60.0 / 64.0, 0.0  },
   	{ -115.0 / 64.0, 52.0 / 64.0 },
   	{  -98.0 / 64.0, 55.0 / 64.0 },
   	{ -122.0 / 64.0, 60.0 / 64.0 } };

void find_predict( short *samples, double *d_samples, int *predict_nr, int *shift_factor )
{
  int i, j;
  double buffer[28][5];
  double min = 1e10;
  double max[5];
  double ds;
  int min2;
  int shift_mask;
  static double _s_1 = 0.0;                            // s[t-1]
  static double _s_2 = 0.0;                            // s[t-2]
  double s_0, s_1, s_2;

  for ( i = 0; i < 5; i++ ) 
    {
      max[i] = 0.0;
      s_1 = _s_1;
      s_2 = _s_2;
      for ( j = 0; j < 28; j ++ ) 
	{
	  s_0 = (double) samples[j];                      // s[t-0]
	  if ( s_0 > 30719.0 )
	    s_0 = 30719.0;
	  if ( s_0 < - 30720.0 )
	    s_0 = -30720.0;
	  ds = s_0 + s_1 * f[i][0] + s_2 * f[i][1];
	  buffer[j][i] = ds;
	  if ( fabs( ds ) > max[i] )
	    max[i] = fabs( ds );
	  s_2 = s_1;                                  // new s[t-2]
	  s_1 = s_0;                                  // new s[t-1]
	}
      
      if ( max[i] < min ) 
	{
	  min = max[i];
	  *predict_nr = i;
	}
      if ( min <= 7 ) 
	{
	  *predict_nr = 0;
	  break;
	}
    }
  
  // store s[t-2] and s[t-1] in a static variable
  // these than used in the next function call
  
  _s_1 = s_1;
  _s_2 = s_2;
  
  for ( i = 0; i < 28; i++ )
    d_samples[i] = buffer[i][*predict_nr];
  
  min2 = ( int ) min;
  shift_mask = 0x4000;
  *shift_factor = 0;
  
  while( *shift_factor < 12 ) 
    {
      if ( shift_mask  & ( min2 + ( shift_mask >> 3 ) ) )
        break;
      (*shift_factor)++;
      shift_mask = shift_mask >> 1;
    }
}


static void pack( double *d_samples, short *four_bit, int predict_nr, int shift_factor )
{
  double ds;
  int di;
  double s_0;
  static double s_1 = 0.0;
  static double s_2 = 0.0;
  int i;

  for ( i = 0; i < 28; i++ ) 
	{
    s_0 = d_samples[i] + s_1 * f[predict_nr][0] + s_2 * f[predict_nr][1];
    ds = s_0 * (double) ( 1 << shift_factor );

    di = ( (int) ds + 0x800 ) & 0xfffff000;

    if ( di > 32767 )
        di = 32767;
    if ( di < -32768 )
        di = -32768;
        
    four_bit[i] = (short) di;

    di = di >> shift_factor;
    s_2 = s_1;
    s_1 = (double) di - s_0;
  }
}


int pcm2vag(u8 *vag, short *wave, int sample_len)
{
  char *p;
  short *ptr;
  double d_samples[28];
  short four_bit[28];
  int predict_nr;
  int shift_factor;
  int flags=0;
  int size;
  int i, j, k;    
  unsigned char d;
  unsigned char *vag_ptr = vag;
  char s[4];
  int chunk_data;
  short e;

  sample_len = sample_len>>1;
  
  for( i = 0; i < 16; i++ )
    {
      *vag_ptr = 0; vag_ptr++;
    }
  
  while( sample_len > 0 ) 
    {
      size = ( sample_len >= BUFFER_SIZE ) ? BUFFER_SIZE : sample_len; 
      
      i = size / 28;
      if ( size % 28 )
	{
	  for ( j = size % 28; j < 28; j++ )
	    wave[28*i+j] = 0;
	  i++;
	}
      
      for ( j = 0; j < i; j++ )                                      // pack 28 samples
	{
	  ptr = wave + j * 28;
	  find_predict( ptr, d_samples, &predict_nr, &shift_factor );
	  pack( d_samples, four_bit, predict_nr, shift_factor );
	  d = ( predict_nr << 4 ) | shift_factor;
	  
	  *vag_ptr++ = d;
	  *vag_ptr++ = flags;
	  
	  for ( k = 0; k < 28; k += 2 ) 
	    {
	      d = ( ( four_bit[k+1] >> 8 ) & 0xf0 ) | ( ( four_bit[k] >> 12 ) & 0xf );
	      *vag_ptr++ = d;
	    }
	  sample_len -= 28;
	  if ( sample_len < 28 )
	    flags = 1;
	}
    }
  
  *vag_ptr++ = ( predict_nr << 4 ) | shift_factor;
  *vag_ptr++ = 7;
  
  for ( i = 0; i < 14; i++ )
    {
      *vag_ptr++ = 0;
    }
  
  return (vag_ptr-vag);
}
