#include "timing.h"

#include <kernel.h>

#include "math.h"
#include "myassert.h"

//#define TDEBUG

static char *f;

//instrument timing::instruments[TIMING_MAXINSTR];
//patternitem timing::patternitems[TIMING_MAXPATTERNITEMS];
static instrument instruments[TIMING_MAXINSTR];
static patternitem patternitems[TIMING_MAXPATTERNITEMS];
int timing::nextfreepatternitem;
float timing::time;
int timing::voice98map;


static void skipuntil2(char c)
{
  while((*f!=c)&&(*f!='!'))
    {
      f++;
    }
  f++;
}

static char nextchar()
{
  return *f;
}
static char nextnbchar()
{
  while(*f!='!')
    {
      if((*f==' ')||(*f=='\t')||(*f=='\n')||(*f==13)||(*f==10))*f++;
      else
	if(*f=='/')
	  {
	    //			skipuntil2('\n');
	    skipuntil2(10);
	  }
	else
	  if(*f!='!')return *f;
    }
  if(*f=='!')return 0;	
  return *f;
}

static bool iscif(char c)
{
  return (c>='0')&&(c<='9');
}

static float getfloat()
{
  float r=0;
  
  nextnbchar();
  while(iscif(nextchar()))
    {
      //		printf("- %f\n",r);
      r*=10;
      r+=nextchar()-'0';
      f++;
    }
  if(nextchar()=='.')
    {
      float a=0.1;
      
      f++;
      
      while(iscif(nextchar()))
	{
	  r+=a*(nextchar()-'0');
	  a*=0.1;
	  f++;
	}
    }
  return r;
}

static int getint()
{
  return (int)getfloat();
}

static patternitem** findend(patternitem **p)
{
  if(*p)
    {
      return findend(&((*p)->next));
    }
  return p;
}

pattern::pattern()
{
	list=0;
}

timing::timing()
{
}


/*
mf2t parser (midi to text)
*/

static int parseNumber(char *s, char *pre)
{
  int i=0;
  while(*s!=0 && pre[i]!=0)if(pre[i]==*s){i++;s++;}else s++;
  int ret=0;
  while(*s>='0' && *s<='9')ret=ret*10+(*(s++)-'0'); 
  return ret;
}

timing::midiLineEnum timing::parseMidiLine(char **midiFile, int &time1, int &time2, int &time3, int &ch, int &n, int &v)
{
  midiLineEnum ret;
  char temp[128];
  int i=0;
  while((*midiFile)[i]!='\n' && (*midiFile)[i]!=0xd)temp[i++]=(*midiFile)[i];
  temp[i]=0;
  i++;
  if((*midiFile)[i]!='\n' || (*midiFile)[i]!=0xd)i++;
  *midiFile+=i;

  if(temp[0]=='M' && temp[1]=='T' && temp[2]=='r' && temp[3]=='k')
    {
      ret=midiTrackBegin;
    }
  else
    if(temp[0]=='T' && temp[1]=='r' && temp[2]=='k' && temp[3]=='E')
      {
	ret=midiTrackEnd;
      }
    else
      {
	int j=0;
	while(temp[j]!=' '&& temp[j]!=0)j++;
	j++;
	if(temp[j]=='O' && temp[j+1]=='n')
	  {
	    ret=midiOn;
	    //	    printf("on\n");
	    time1=parseNumber(temp,"");
	    time2=parseNumber(temp,":");
	    time3=parseNumber(temp,"::");
	    ch=parseNumber(temp,"ch=");
	    n=parseNumber(temp,"n=");
	    v=parseNumber(temp,"v=");
	    //printf("pos1 %i pos2 %i pos3 %i ch %i n %i v %i\n",time1,time2,time3,ch,n,v);
	  }
	else
	  ret=midiUnknown;
      }
  //  printf("Line parsed %i %i: %s\n",temp[0],i,temp);
  return ret;
}

patternitem *timing::newpatternitem(int t1, int t2, int t3, int t4, int instr, float p1, float p2, float p3)
{
  myassert(t1>=0 && t1<=256);
  myassert(t2>=0 && t2<=255);
  myassert(t3>=0 && t3<=255);
  myassert(t4>=0 && t4<=255);
  myassert(instr>=0 && instr<=255);
  myassert(p1>=0 && p1<=255);
  myassert(p2>=0 && p2<=255);
  myassert(p3>=0 && p3<=255);


  myassert(nextfreepatternitem<TIMING_MAXPATTERNITEMS);
  patternitem *p=patternitems+nextfreepatternitem;
  nextfreepatternitem++;
  
  p->t1=t1;
  p->t2=t2;
  p->t3=t3;
  p->t4=t4;
  p->instr=instr;
  p->p1=(unsigned char)p1;
  p->p2=(unsigned char)p2;
  p->p3=(unsigned char)p3;
  
  return p;
}

void timing::load(char *mem, char *midiFile)
{
  f=mem;
  
  
  while(nextnbchar())
	{
#ifdef TDEBUG
	  printf("fandt noget\n");
#endif
	  switch(nextnbchar())
	    {
	    case 'p':
	      {
#ifdef TDEBUG
		printf("et pattern\n");
#endif
		skipuntil2(':');
#ifdef TDEBUG
		printf("skip til : nste tegn %c\n",*f);
#endif
		int index=getint();
		int offset=getint();
#ifdef TDEBUG
		printf("pattern index %i\n",index);
#endif
		patterns[index].length=getint();
		patterns[index].list=0;
		while(iscif(nextnbchar()))
		  {
		    int t1=getint()-offset;
		    int t2=getint()-1;
		    int t3=getint()-1;
		    int t4=getint()-1;
		    int instr=getint();
		    float p1=getfloat();
		    float p2=getfloat();
		    float p3=getfloat();
		    *findend(&(patterns[index].list))=newpatternitem(t1,t2,t3,t4,instr,p1,p2,p3);
		  }
	      }
	      break;
	    case 't':
#ifdef TDEBUG
	      printf("et track\n");
#endif
	      skipuntil2(':');
	      bpm=getfloat();				
	      length=getint();
	      ntrackitems=0;
	      while(iscif(nextnbchar()))
		{
#ifdef TDEBUG
		  printf("reading trackitem\n");
#endif
		  track[ntrackitems].t=getint()-1;
		  track[ntrackitems].pnum=getint();
		  track[ntrackitems].rep=getint();
		  ntrackitems++;
		}				
	      break;
		}
	}
  
  int index=TIMING_MAXPATTERNS-1;
  if(midiFile)
    {
      int t;
      int time1,time2,time3,ch,n,v;
      patterns[index].length=10000;
      patterns[index].list=0;
      while((t=parseMidiLine(&midiFile,time1,time2,time3,ch,n,v))!=midiTrackEnd)
	{
	  
	  if(t==midiOn)
	    {
	      if(v!=0)
		*findend(&(patterns[index].list))=newpatternitem(time1,time2,time3/120,0,ch,v,n,0);
	    }
	}
      //remember to turn this pattern on in the track list!
    }
  else
    {
      patterns[index].length=10000;
      patterns[index].list=0;
    }
}

void timing::mapvoice98(int voicenum)
{
  voice98map=voicenum;
}

void timing::clear()
{
  //slet instrumenter
  //nulstil position
  time=0;
  nexttrackitem=0;
  activefirst=0;
  activefree=activelist;
  for(int t=0;t<TIMING_MAXACTIVE;t++)
    {
      activelist[t].next=activelist+t+1;
    }
  activelist[TIMING_MAXACTIVE-1].next=0;
  voice98map=0;
  
  for(int t=0;t<TIMING_MAXINSTR;t++)
    {
      instruments[t].time=0;
      instruments[t].p1=0;
      instruments[t].p2=0;
      instruments[t].p3=0;
    }
}

float timing::toms(int t)
{
  //	return ((16*t)/bpm*60.0*1000.0);
  return ((16*t)/bpm*60.0*1000.0)/4;
}

static float toms4(int t1, int t2, int t3, int t4, float bpm)
{
//	return ((16*t1+4*t2+t3+t4/240.0)/bpm*60.0*1000.0);
  return ((16*t1+4*t2+t3+t4/240.0)/bpm*60.0*1000.0)/4;
}

int timing::currentpos()
{
  return (int)(time/(60.0*1000.0)*bpm);
}

void timing::step(float t)
{
  //step t ms
  time+=t;
  
  //if t>length 
  
  while((nexttrackitem<ntrackitems)&&(toms(track[nexttrackitem].t)<=time))
    {
#ifdef TDEBUG
      printf("pattern aktiveres\n");
#endif
      activeitem *a=activefree;
      //assert a
      activefree=a->next;
      a->next=activefirst;
      activefirst=a;
      
      a->item=track+nexttrackitem;
      a->current=patterns[track[nexttrackitem].pnum].list;
      a->rep=0;
      
      nexttrackitem++;
#ifdef TDEBUG
      printf("pattern er indsat i liste\n");
#endif
    }
#ifdef TDEBUG
  printf("nste pattern blev ikke aktiveret\n");
#endif
  
  activeitem *a=activefirst;
  activeitem **A=&activefirst;
  
  
  while(a)
    {
      bool remove=false;
      
#ifdef TDEBUG
      printf("tester tider: %f, %f \n",toms4(a->current->t1+a->item->t+patterns[a->item->pnum].length*a->rep,a->current->t2,a->current->t3,a->current->t4,bpm),time);	
#endif
      while(toms4(a->current->t1+a->item->t+patterns[a->item->pnum].length*a->rep,a->current->t2,a->current->t3,a->current->t4,bpm)<time)
	{
#ifdef TDEBUG
	  printf("stter instrument %i  , time:%f\n",a->current->instr,time);
#endif
	  
	  //			if(time==0 || instruments[a->current->instr].time!=time || instruments[a->current->instr].p1<a->current->p1)
	  {
	    instruments[a->current->instr].time=time;
		    instruments[a->current->instr].p1=a->current->p1;
		    instruments[a->current->instr].p2=a->current->p2;
		    instruments[a->current->instr].p3=a->current->p3;
	  }
	  a->current=a->current->next;
	  if(a->current==0)
	    {
#ifdef TDEBUG
	      printf("tester for gentagelse\n");
#endif
	      a->current=patterns[a->item->pnum].list;
	      a->rep++;
	      if(a->rep==a->item->rep)
		{
#ifdef TDEBUG
		  printf("skal slettes fra aktivlisten\n");
#endif
		  remove=true;
		  break;
		}
	    }
#ifdef TDEBUG
	  printf("tester tider: %f, %f \n",toms4(a->current->t1+a->item->t+patterns[a->item->pnum].length*a->rep,a->current->t2,a->current->t3,a->current->t4,bpm),time);		
#endif
	}
      
      if(remove)
	{
	  *A=a->next;
	  a->next=activefree;
	  activefree=a;
	}
      else
	A=&((*A)->next);
      a=(*A);
    }
}

static float g(float x)
{
  if(x<0)return 0;
  if(x>1)return 0;
  return sin(3.141592658979*((1-x)*(1-x)*(1-x)*(1-x)));
}

float timing::get(int instr)
{
  if(instr==98)instr=voice98map;
  instrument *i=instruments+instr;
	
#ifdef TDEBUG
  printf("get: %f, %f \n",time,instruments[instr].time);		
#endif
  /*
    if(time-i->time<200)return 1;
    else return 0;
  */
  return (2*(i->p1)/100)*g((time-i->time)/400);
}

int timing::getval(int instr)
{
  if(instr==98)instr=voice98map;
  instrument *i=instruments+instr;
  
#ifdef TDEBUG
  printf("get: %f, %f \n",time,instruments[instr].time);		
#endif
/*
	if(time-i->time<200)return 1;
	else return 0;
*/
	return (int)(i->p1);
}

int timing::getval2(int instr)
{
  if(instr==98)instr=voice98map;
  instrument *i=instruments+instr;
  
#ifdef TDEBUG
  printf("get: %f, %f \n",time,instruments[instr].time);		
#endif
  /*
    if(time-i->time<200)return 1;
    else return 0;
  */
  return (int)(i->p2);
}

int timing::getval3(int instr)
{
  if(instr==98)instr=voice98map;
  instrument *i=instruments+instr;
  
#ifdef TDEBUG
  printf("get: %f, %f \n",time,instruments[instr].time);		
#endif
  /*
    if(time-i->time<200)return 1;
	else return 0;
  */
  return (int)(i->p3);
}

int timing::gettime(int instr)
{
  if(instr==98)instr=voice98map;
  instrument *i=instruments+instr;
  
#ifdef TDEBUG
  printf("get: %f, %f \n",time,instruments[instr].time);		
#endif
  /*
    if(time-i->time<200)return 1;
    else return 0;
*/
  return (int)(i->time);
}

void printpattern(pattern *p)
{
  if(p)
    {
      printf("printing pattern\n");
      printf("length %i\n",p->length);
      patternitem *l=p->list;
      while(l)
	{
	  printf("%i %i %i %i, %i, %f %f %f\n",l->t1,l->t2,l->t3,l->t4,l->instr,l->p1,l->p2,l->p3);
	  l=l->next;
	}
		
    }
}


#ifdef TDEBUG
void printactivelist(timing *t)
{
  activeitem* p=t->activefirst;
  
  printf("printing activelist\n");
  while(p)
    {
      printf("%i/%i starttid:%i pnum:%i\n",p->rep,p->item->rep,p->item->t,p->item->pnum);
      p=p->next;
    }
}

void printtrack(timing *t)
{
  printf("Printing track\n");
  for(int i=0;i<t->ntrackitems;i++)
    {
      printf("%i %i %i\n",t->track[i].t,t->track[i].pnum,t->track[i].rep);
    }
}

void printpattern(pattern *p)
{
  if(p)
    {
      printf("printing pattern\n");
      printf("length %i\n",p->length);
      patternitem *l=p->list;
      while(l)
	{
	  printf("%i %i %i %i, %i, %f %f %f\n",l->t1,l->t2,l->t3,l->t4,l->instr,l->p1,l->p2,l->p3);
	  l=l->next;
	}
      
    }
}

void main()
{
  static char *f=
    "pattern:																\n"
    "8 1 2				//(nummer,startinterval,lngde)                                                                         \n"
    "1 1 1 1		0 123 0 0	//(pos,pos,pos,pos,instrument,styrke,par,par) // pos 1: 1-4 pos 2: 1-4 pos 3: 1-4 pos 4: 1-240  \n"
    "1 1 2 1		1 80 0 0                                                                                                        \n"
    "1 2 1 1 	0 120 0 0                                                                                                               \n"
    "1 2 1 1 	1 50 0 0                                                                                                                \n"
    "pattern:                                                                                                                               \n"
    "9 17 2                                                                                                                                 \n"
    "17 1 1 1	0 123 0 0	// dsdfgsdfsd                                                                                           \n"
    "17 1 2 1	1 80 0 0                                                                                                                \n"
    "17 2 1 1 	0 120 0 0                                                                                                               \n"
    "17 2 1 1 	1 50 0 0                                                                                                                \n"
    "track:                                                                                                                                 \n"
    "101.67 91 			//(bpm,length)				\n"
    "1 8 10				//(pos,patternnum,antalgentagelser)     \n"
    "2 9 5                                                                  \n"
    "                                                                       \n"
    "pattern:                                                               \n"
    "0 1 4                                                                  \n"
    "1 1 1 1		0 50 0 0	// kick                         \n"
    "1 1 3 11	0 50 0 0                                                \n"
    "1 2 1 1		1 90 0 0	// snare                        \n"
    "1 2 4 69	2 48 0 0	// hihat                                \n"
    "1 3 1 33	2 40 0 0                                                \n"
    "1 3 2 99	2 20 0 0                                                \n"
    "1 3 3 32	3 75 0 0	// crash                                \n"
    "1 3 3 32	0 50 0 0	// kick		\n"
    "1 4 4 97	0 30 0 0                        \n"
    "2 1 1 1		0 50 0 0                \n"
    "2 1 3 21	0 50 0 0                        \n"
    "2 2 1 19	1 95 0 0	// snare        \n"
    "2 2 3 27	0 50 0 0	// kick         \n"
    "2 2 4 77	0 40 0 0                        \n"
    "2 3 1 23	2 25 0 0	// hihat        \n"
    "2 3 2 89	0 20 0 0	// kick         \n"
    "2 3 5 15	2 20 0 0	// hihat        \n"
    "2 3 4 78	0 18 0 0	// kick         \n"
    "2 4 1 23	0 50 0 0                        \n"
    "2 4 1 23	3 50 0 0	// crash        \n"
    "2 4 3 21	2 20 0 0	// hihat	\n"
    "2 4 4 86	0 20 0 0	// kick		\n"
    "3 1 1 14	0 50 0 0\n"
    "!"
    ;
  
  timing t;
  printf("klar\n");
  t.load(f);
  printpattern(&t.patterns[8]);
  printpattern(&t.patterns[9]);
  printpattern(&t.patterns[0]);

  printtrack(&t);
  t.clear();
  for(int i=0;i<1000;i++)
    {
      
      t.step(20);
      printactivelist(&t);
      printf("\t\t\t\tINST(0):%f\n",timing::get(0));
    }
}
#endif
