#ifndef __TEXTURE_H
#define __TEXTURE_H

#include "types.h"

class texture
{
 public:
  void init();
  void load(char *file);
  void swapClutColors();
  void upload(int addr);
  void download();
  void uploadclut();	//upload clut only
  void loadalpha(char *file);
  int64 TEX0();
  int64 TEX1();
  int64 TEX2();
  void memallocclut();	//allocate in main memory
  void allocclut();	//allocate in video ram
  void alloc();
  void allocupload();
  
  void dmalistframe1(int interlaceframe);
  int dmalistframe1(int interlaceframe, int128 *l);
  void dmalistframe2(int interlaceframe);
  int dmalistframe2(int interlaceframe, int128 *l);
  void setcurrent_vif(int interlace=0);
  void setcurrent_vif2(int interlace=0);
  void clear_vif(int col, int context=0);
  void upload_vif(int addr);
  void setSourceContext1_vif();
  void setSourceContext2_vif();
  
  void box(int x1, int y1, int x2, int y2, int color);
  static void boxNoTexture(int x1, int y1, int x2, int y2, int color, int64 alphareg=0);
  static void boxNoTexture_vif(int x1, int y1, int x2, int y2, int color, int64 alphareg=0);
  void boxuv(int x1, int y1, int x2, int y2, int uv1, int uv2, int64 alphareg=0x4000000044, int color=0x80808080);
  void boxuv_vif(int x1, int y1, int x2, int y2, int uv1, int uv2, int64 alphareg=0x4000000044, int64 tex1=1<<5, int color=0x808080);
  void boxuv(int x, int y);
  void boxuv_vif(int x, int y);
  void boxuvargb(int x1, int y1, int x2, int y2, int uv1, int uv2, int argb);
  
  int	bitsperpixel;
  int 	width,height;
  int32	*image;
  int	*clut;
  int	addr,clutaddr,zbufaddr;
  int64	TW,TH;
};

void texture_cleartexturemem(int color);
int texture_allocinit(int start);
int texture_allocvideomem(int size);

#endif
