/* SuperDuper texture handler */
/* SoopaDoopa 2001 */

#include <kernel.h>
#include "texture.h"
#include "malloc.h"
#include "gif.h"
#include "dma.h"
#include "main.h"
#include "myassert.h"

static char *filestart,*filepos;

typedef struct texture_pcxheader
{
  int encoding;
  int bitsperpixel;
  int minx,maxx,miny,maxy;
  int nplanes;
  int bytesperline;
  int sizex;
  int sizey;
}texture_pcxheader;

static texture_pcxheader header; 

void texture_pcxreadinit(char *file)
{
  filestart=file;
  filepos=file;
}

void texture_pcxreadreset()
{
  filepos=filestart;
}

int texture_pcxreadbyte()
{
  filepos++;
  
  return (*(filepos-1))&255;
}

int texture_pcxreadword()
{
  int lo,hi;
  
  lo=255&(texture_pcxreadbyte());
  hi=255&(texture_pcxreadbyte());
  
  return (hi<<8)+lo;
}

void texture_pcxreadheader()
{
  int t;
	
  texture_pcxreadreset();
  
  texture_pcxreadbyte();
  texture_pcxreadbyte();
  header.encoding=texture_pcxreadbyte();
  header.bitsperpixel=texture_pcxreadbyte();
  header.minx=texture_pcxreadword();
  header.miny=texture_pcxreadword();
  header.maxx=texture_pcxreadword();
  header.maxy=texture_pcxreadword();
  
  for(t=0;t<53;t++)texture_pcxreadbyte();
  
  header.nplanes=texture_pcxreadbyte();
  header.bytesperline=texture_pcxreadword();

  header.sizex=header.maxx-header.minx+1;
  header.sizey=header.maxy-header.miny+1;
}

static int64 log(int a)
{
  int r=0;
  
  a--;
  while(a>0)
    {
      a=a>>1;
      r++;
    }
  
  return r;
}

static void texture_update(texture *tex)
{
  tex->TH=log(tex->height);
  tex->TW=log(tex->width);
}

int64 texture::TEX0()
{
  texture* tex=this;
  
  texture_update(tex);
  
  if(tex->bitsperpixel==32)
    return ((int64)1<<34)+((int64)tex->TH<<30)+(tex->TW<<26)+(0<<20)+(((tex->width/64)&63)<<14)+(tex->addr/256);
  return ((int64)1<<61)+(((int64)tex->clutaddr/256)<<37)+((int64)1<<34)+((int64)tex->TH<<30)+(tex->TW<<26)+(0x13<<20)+(((tex->width/64)&63)<<14)+(tex->addr/256);
}

int64 texture::TEX1()
{
  texture* tex=this;
  
  return 0;
}

int64 texture::TEX2()
{
  texture* tex=this;
  
  return tex->TEX0();
}

void texture_pcxreaddata(char *dest, int skip)
{
  int t,x,y;
  
  static char line[4096*4];
  
  texture_pcxreadreset();
  
  for(t=0;t<128;t++)texture_pcxreadbyte();
  
  for(y=0;y<header.sizey;y++)
    {
      x=0;
      while(x<header.bytesperline*header.nplanes)
	{
	  int b=texture_pcxreadbyte();

	  if((b&0xc0)==0xc0)
	    {
	      int b2=texture_pcxreadbyte();
	      b-=192;
	      while(b>0)
		{
		  line[x]=b2;
		  x++;
		  b--;
		}
	    }
	  else
	    {
	      line[x]=b;
	      x++;
	    }
	}
      
      for(x=0;x<header.sizex;x++)
	{
	  if(skip==-1) //alpha
	    {
	      dest[(y*header.sizex+x)*(4)+3]=((255&(int)(line[x]))>>1);
	    }
	  else
	    {
	      for(t=0;t<header.nplanes;t++)
		dest[(y*header.sizex+x)*(header.nplanes+skip)+t]=line[x+t*header.bytesperline];
	      for(;t<header.nplanes+skip;t++)
		dest[(y*header.sizex+x)*(header.nplanes+skip)+t]=127;
	    }
	}
    }
}


void texture_pcxreadpal(int *dest)
{
  int t;
  
  texture_pcxreadbyte();
  
  for(t=0;t<256;t++)
    {
      int r=texture_pcxreadbyte();
      int g=texture_pcxreadbyte();
      int b=texture_pcxreadbyte();
      dest[t]=rgb(r,g,b)+0x7f000000;
    }
}

void texture::load(char *file)
{
  printf("Loading texture: ");
  
  texture* tex=this;
  
  texture_pcxreadinit(file);
  
  texture_pcxreadheader();
  
  
  printf("Texture size: x:%i y:%i planes:%i bitsperpixel: %i\n",header.sizex,header.sizey,header.nplanes,	header.bitsperpixel);
  
  if(header.nplanes==3)
    {
      tex->bitsperpixel=32;
      tex->width=header.sizex;
      tex->height=header.sizey;
      tex->image=(int32*)malloc((tex->width*tex->height*tex->bitsperpixel)/8);
      myassert(tex->image);
      tex->clut=0;
      texture_pcxreaddata((char*)tex->image,1);
    }
  else
    {
      tex->bitsperpixel=8;
      tex->width=header.sizex;
      tex->height=header.sizey;
      
      tex->image=(int32*)malloc((tex->width*tex->height*tex->bitsperpixel)/8);
      myassert(tex->image);
      tex->clut=(int32*)malloc(4*256);
      myassert(tex->clut);
      texture_pcxreaddata((char*)tex->image,0);
      texture_pcxreadpal((int*)tex->clut);
      
      swapClutColors();
    }
}

void texture::loadalpha(char *file)
{
  texture *tex=this;
  
  texture_pcxreadinit(file);
  
  texture_pcxreadheader();
  
  texture_pcxreaddata((char*)tex->image,-1);
}

void texture::init()
{
  texture *tex=this;
  
  tex->bitsperpixel=32;
  tex->width=256;
  tex->height=256;
  tex->image=0;//malloc((tex->width*tex->height*tex->bitsperpixel)/8);
  tex->clut=0;
  tex->zbufaddr=0;
}

static int128	list[40];
//volatile static int128	list[40];

#define MAXTRANSFER (128*128)

static void send(int128 *p, int length)
{
  while(length>0)
    {
      gif_env;
      
      int thislength;
      
      if(length>MAXTRANSFER)
	{
	  thislength=MAXTRANSFER;
	  length-=MAXTRANSFER;
	}
      else
	{
	  thislength=length;
	  length=0;
	}
      
      gif_begin(list);
      gif_tag(0,0,2,0,0);
      gif_endimagemode(thislength);
      
      FlushCache(0);
      dma02_wait();
      
      dma02_send(list,gif_length,0x101);
      
      dma02_wait();
      dma02_send(p,thislength,0x101);
      dma02_wait();
      
      p+=MAXTRANSFER;
    }
}

void texture::upload(int addr)
{
  texture *tex=this;
  int t;
  int width=tex->width,height=tex->height;

  
  FlushCache(0);

  dma02_wait();
  
  if(tex->bitsperpixel==32)
    {
      gif_env;
		
      gif_begin(list);
      gif_tag(0xe,1,0,0,0);
      gVEC(0x50,wwd(0x0000000,0x000000+addr/256+(width<<10)));
      gVEC(0x51,wwd(0,hhw(0,0)));
      gVEC(0x52,wwd(width,height));
      gVEC(0x53,0);
      gif_endfinal();
      
      FlushCache(0);
      dma02_wait();
      
      dma02_send(list,gif_length,0x101);
      
      dma02_wait();
      
      send((int128*)(tex->image),(height*width)/4);
    }
  else
    {
      gif_env;
		
      gif_begin(list);
      gif_tag(0xe,1,0,0,0);
      gVEC(0x50,wwd(0x0000000,0x13000000+addr/256+(width<<10)));
      gVEC(0x51,wwd(0,hhw(0,0)));
      gVEC(0x52,wwd(width,height));
      gVEC(0x53,0);
      gif_endfinal();
      
      FlushCache(0);
      dma02_wait();
      
      dma02_send(list,gif_length,0x101);

      dma02_wait();
      
      send((int128*)(tex->image),(height*width)/16);
      //tag();//send((int128*)(tex->image),(height*width)/4);
      
      uploadclut();
    }
  
  tex->addr=addr;
}

void texture::upload_vif(int addr)
{
//the texture size must be less than 0.5MB
  gif_env;
  texture *tex=this;
  int t;
  int width=tex->width,height=tex->height;
  
  if(tex->bitsperpixel==32)
    {
      for(int h=0;h<height;h+=128)//should fix size limit?
	{
	  int h2=h+128;
	  if(h2>height)h2=height;

	  dma01_beginp();
	  vif_nop();
	  vif_nop();
	  vif_nop();
	  vif_direct_begin();
	  gif_tag(0xe,1,0,0,0);
	  gVEC(0x50,wwd(0x0000000,0x000000+addr/256+(width<<10)));
	  gVEC(0x51,wwd(hhw(0,0),hhw(0,h)));
	  gVEC(0x52,wwd(width,(h2-h)));
	  gVEC(0x53,0);
	  gif_endfinal();//
	  gif_tag(0,0,2,0,0);
	  gif_endimagemode(((width*(h2-h))/4));
	  vif_direct_end();
	  dma01_endp();
	  dma01_beginp();
	  vif_nop();
	  vif_nop();
	  vif_nop();
	  vif_directhl((((h2-h)*width)/4));
	  
	  dma01_endp();
	  dma01_ref((((unsigned int*)image)+(width*(h))),(((unsigned int*)image)+(width*(h2))));
	  
	  dma01_endchain();
	}
    }
  else
    {
      dma01_beginp();
      vif_nop();
      vif_nop();
      vif_nop();
      vif_direct_begin();
      gif_tag(0xe,1,0,0,0);
      gVEC(0x50,wwd(0x0000000,0x13000000+addr/256+(width<<10)));
      gVEC(0x51,wwd(0,hhw(0,0)));
      gVEC(0x52,wwd(width,height));
      gVEC(0x53,0);
      gif_endfinal();
      gif_tag(0,0,2,0,0);
      gif_endimagemode(width*height/16);
      vif_direct_end();
      dma01_endp();
      dma01_beginp();
      vif_nop();
      vif_nop();
      vif_nop();
      vif_directhl(((height*width)/16));
      
      dma01_endp();
      dma01_ref(image,((unsigned int*)((((char*)image)+width*height))));
      
      //	myassert("uploadclut_vif not implemented"==0);
      //		uploadclut();
    }
  
  tex->addr=addr;
}


void texture_cleartexturemem(int color)
{
  int t;
  static int bitmap[32*32];
  texture tex;
  
  for(t=0;t<32*32;t++)bitmap[t]=color;
  tex.init();
  
  tex.width=32;
  tex.height=32;
  tex.image=(int32*)(void*)bitmap;
  
  for(t=0;t<1024;t++)tex.upload(t*32*4*32);
}

static int nextfree=0;
#define BLOCKSIZE 8192
#define BLOCKSIZEW 64
#define BLOCKSIZEH 32

int texture_allocinit(int start)
{
  start=(-BLOCKSIZE)&(start+BLOCKSIZE-1);
  
  nextfree=start;
}


int texture_allocvideomem(int size)
{
  size=(-BLOCKSIZE)&(size+BLOCKSIZE-1);
  
  nextfree+=size;
  
  //  printf("texture_allocvideomem ------------------------------- $%x\n",nextfree-size);
  return nextfree-size;
}


void texture::allocclut()
{
  static int clutSpaceLeft;
  static int currentClutSlot;

  if(clutSpaceLeft==0)
    {
      currentClutSlot=texture_allocvideomem(8*16*16*4);
      clutSpaceLeft+=8;
    }
  clutaddr=currentClutSlot+(8-clutSpaceLeft)*16*16*4;
  clutSpaceLeft--;
  //	clutaddr=texture_allocvideomem(16*16*4);
}


void texture::memallocclut()
{
  clut=(int32*)malloc(4*256);
  myassert(clut);
}


void texture::swapClutColors()
{
  if(bitsperpixel==8)
    if(clut)
      {
	for(int t=0;t<256;t++)
	  {		
	    if((t&0x18)==8)
	      {
		int temp;
		
		temp=clut[t];
		clut[t]=clut[t+8];
		clut[t+8]=temp;
	      }
	  }
      }
}

void texture::uploadclut()
{
  gif_env;
  texture *tex=this;
  int t;
  int width=tex->width,height=tex->height;
  
  //Swap the colors in the clut to CSM1 format
  //	swapClutColors();
  gif_begin(list);
  gif_tag(0xe,1,0,0,0);
  gVEC(0x50,wwd(0x0000000,0x00000000+tex->clutaddr/256+(16<<10)));
  gVEC(0x51,wwd(0,hhw(0,0)));
  gVEC(0x52,wwd(16,16));
  gVEC(0x53,0);
  gif_endfinal();
  
  FlushCache(0);
  dma02_wait();
  
  dma02_send(list,gif_length,0x101);
  
  dma02_wait();
  
  send((int128*)(tex->clut),(16*16)/4);
  
  //Swap the colors back to normal format
  //		swapClutColors();
}


void texture::allocupload()
{
  texture *tex=this;
  
  allocclut();
  //	tex->clutaddr=texture_allocvideomem(16*16*4);
  upload(texture_allocvideomem(tex->width*(((-BLOCKSIZEH)&(tex->height-1))+BLOCKSIZEH)*(tex->bitsperpixel/8)));
}


void texture::alloc()
{
  texture *tex=this;
  
  //	tex->clutaddr=texture_allocvideomem(16*16*4);
  tex->addr=texture_allocvideomem(tex->width*(((-BLOCKSIZEH)&(tex->height-1))+BLOCKSIZEH)*(tex->bitsperpixel/8));
}


void texture::dmalistframe1(int interlaceframe)
{
  dma_endgp_(dmalistframe1(interlaceframe, dma_chainnext+1));
}


int texture::dmalistframe1(int interlaceframe, int128 *l)
{
  texture *tex=this;
  gif_env;
  
  gif_begin(l);
  
  gif_tag(0xe,1,0,0,0);
  
  gFRAME_1(0x0000000+((width/64)<<16)+tex->addr/2048/4);	// framebuffer width = 640/64
  if(tex->zbufaddr)
    gZBUF_1(tex->zbufaddr/2048/4);				// 0-8 Zbuffer base, 24-27 Z format (32bit)
  //  gXYOFFSET_1(wwd(32000,32008-1*interlaceframe*8));	// X,Y offset
  gXYOFFSET_1(wwd(32000,32008-1*interlaceframe*8));	// X,Y offset
  gSCISSOR_1(wwd(hhw(0,tex->width-1),hhw(0,tex->height-1)));			// x1,y1,x2,y2 - scissor window
  gTEST_1(0x30000);
  
  gPRMODECONT(1);						// refer to prim attributes
  gCOLCLAMP(1);
  gDTHE(0);						// Dither off
  
  gSCANMSK(0);
  
  gif_endfinal();
  
  return gif_length;
}


void texture::dmalistframe2(int interlaceframe)
{
  dma_endgp_(dmalistframe2(interlaceframe, dma_chainnext+1));
}


int texture::dmalistframe2(int interlaceframe, int128 *l)
{
  texture *tex=this;
  gif_env;
  
  gif_begin(l);
  
  gif_tag(0xe,1,0,0,0);
  
  gFRAME_2(0x0000000+((width/64)<<16)+tex->addr/2048/4);	// framebuffer width = 640/64
  if(tex->zbufaddr)
    gZBUF_2(tex->zbufaddr/2048/4);				// 0-8 Zbuffer base, 24-27 Z format (32bit)
  //  gXYOFFSET_2(wwd(32000,32008-1*interlaceframe*8));	// X,Y offset
  gXYOFFSET_2(wwd(32000,32008-1*interlaceframe*8));	// X,Y offset
  gSCISSOR_2(wwd(hhw(0,tex->width-1),hhw(0,tex->height-1)));			// x1,y1,x2,y2 - scissor window
  gTEST_2(0x30000);
  
  gPRMODECONT(1);						// refer to prim attributes
  gCOLCLAMP(1);
  gDTHE(0);						// Dither off
  
  gSCANMSK(0);
  
  gif_endfinal();
  
  return gif_length;
}

void texture::setcurrent_vif(int interlace)
{
  gif_env;
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  vif_direct_end_(dmalistframe1(interlace,(int128*)dma01_currentpos));
  dma01_endp();
}

void texture::setcurrent_vif2(int interlace)
{
  gif_env;
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  vif_direct_end_(dmalistframe2(interlace,(int128*)dma01_currentpos));
  dma01_endp();
}


void texture::setSourceContext1_vif()
{
  gif_env;
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  
  {
    gif_tag(0xe,1,0,0,0);
    gTEX0_1(TEX0());
    gTEX1_1(1<<5);				//bilinear
    gif_endfinal();
  }
  vif_direct_end();
  
  dma01_endp();
}


void texture::setSourceContext2_vif()
{
  gif_env;
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  
  {
    gif_tag(0xe,1,0,0,0);
    gTEX0_2(TEX0());
    gTEX1_2(1<<5);				//bilinear
    gif_endfinal();
  }
  vif_direct_end();
  
  dma01_endp();
}


void texture::clear_vif(int col, int context)
{
// inserts a clearscreen command to the viflist. the current texture (set by setcurrent) is cleared with color col
// using env(context+1)!
  gif_env;
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  
  {
    gif_tag(0xe,1,0,0,0);
    if(context==0)
      {
	gTEST_1(0x30000);
      }
    else
      {
	gTEST_2(0x30000);
      }
    gPRIM(6+(context<<9));
    gRGBAQ(0x3F80000000000000+col);
    gXYZ2(hhw(32000+0*16,32000));
    gXYZ2(hhw(32000+16*width,32000+16*height));
    if(context==0)
      {
	gTEST_1(0x70000);
      }
    else
      {
	gTEST_2(0x70000);
      }
    
    gif_endfinal();
	}
  vif_direct_end();

  dma01_endp();
}


void texture::box(int x1, int y1, int x2, int y2, int color)
{
  gif_env;
  
  y1/=2;
  y2/=2;
  
  x1+=32000;
  y1+=32000;
  x2+=32000;
  y2+=32000;
	
  dma_begingp();
  gif_tag(0xe,1,0,0,0);
  
  gPRMODECONT(1);				// refer to prim attributes
  gCOLCLAMP(1);
  //	gCLAMP_1(0x1000010005);
//	gALPHA_1(0x4000000044);
  gDTHE(0);				// Dither off
  
  gCLAMP_1(0);
  //	gALPHA_1(0x4000000048);
  gALPHA_1(0x4000000044);
  
  gTEX0_1(TEX0());
	
  gTEX1_1(1<<5);				//bilinear
  gTEST_1(0x30000);
  
  gPRIM(PRIMsprite+PRIMtexture+PRIMuv);
  gPABE(0);
  gRGBAQ(0x3F80000080000000+color);		// Background RGBA
  gUV(hhw(0,0));
  gXYZ2(hhw(x1,y1));
  gUV(hhw(width*16,height*16));
  gXYZ2(hhw(x2,y2));
  
  gif_endfinal();
  dma_endgp();
}


void texture::boxNoTexture(int x1, int y1, int x2, int y2, int color, int64 alphareg)
{
  gif_env;
  
  y1/=2;
  y2/=2;
  
  x1+=32000;
  y1+=32000;
  x2+=32000;
  y2+=32000;
	
  dma_begingp();
  gif_tag(0xe,1,0,0,0);
  
  gPRMODECONT(1);				// refer to prim attributes
  gCOLCLAMP(1);
  //	gCLAMP_1(0x1000010005);
  //	gALPHA_1(0x4000000044);
  gDTHE(0);				// Dither off
  
  gCLAMP_1(0);
  //	gALPHA_1(0x4000000048);
  gALPHA_1(alphareg);
  
  //gTEX0_1(TEX0());
  
  //  gTEX1_1(1<<5);				//bilinear
  gTEST_1(0x30000);
  
  gPRIM(PRIMsprite+PRIMuv+PRIMalpha);
  gPABE(0);
  //  gRGBAQ(0x3F80000080000000+color);
  gRGBAQ(0x3F80000000000000+color);
  gXYZ2(hhw(x1,y1));
  gXYZ2(hhw(x2,y2));
  
  gif_endfinal();
  dma_endgp();
}

void texture::boxNoTexture_vif(int x1, int y1, int x2, int y2, int color, int64 alphareg)
{
  gif_env;
    
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  {  
    y1/=2;
    y2/=2;
    
    x1+=32000;
    y1+=32000;
    x2+=32000;
    y2+=32000;
    
    gif_tag(0xe,1,0,0,0);
    
    gPRMODECONT(1);				// refer to prim attributes
    gCOLCLAMP(1);
    //	gCLAMP_1(0x1000010005);
    //	gALPHA_1(0x4000000044);
    gDTHE(0);				// Dither off
    
    gCLAMP_2(0);
    //	gALPHA_1(0x4000000048);
    gALPHA_2(alphareg);
    
  //gTEX0_1(TEX0());
    
  //  gTEX1_1(1<<5);				//bilinear
    gTEST_2(0x30000);
    
    gPRIM(PRIMsprite+PRIMalpha+PRIMcontext2);
    gPABE(0);
    //  gRGBAQ(0x3F80000080000000+color);
    gRGBAQ(0x3F80000000000000+color);
    gXYZ2(hhw(x1,y1));
    gXYZ2(hhw(x2,y2));
    
    gif_endfinal();
  }
  vif_direct_end();
  dma01_endp();
}

void texture::boxuv(int x1, int y1, int x2, int y2, int uv1, int uv2, int64 alphareg, int color)
{
  gif_env;

  y1/=2;
  y2/=2;

  x1+=32000;
  y1+=32000;
  x2+=32000;
  y2+=32000;
	
  dma_begingp();
  gif_tag(0xe,1,0,0,0);
	
  gPRMODECONT(1);				// refer to prim attributes
  gCOLCLAMP(1);
  //	gCLAMP_1(0x1000010005);
  //	gALPHA_1(0x4000000044);
  gDTHE(0);				// Dither off
  
  gCLAMP_1(0);
  //	gALPHA_1(0x4000000048);
  gALPHA_1(alphareg);
  
  gTEX0_1(TEX0());
  
  gTEX1_1(1<<5);				//bilinear
  gTEST_1(0x30000);
  gPRIM(0x116+0x40);
  gPABE(0);
  gRGBAQ(0x3F80000000000000+color);
  gUV(uv1);
  gXYZ2(hhw(x1,y1));
  gUV(uv2);
  gXYZ2(hhw(x2,y2));
  
  gif_endfinal();
  dma_endgp();
}

void texture::boxuv_vif(int x1, int y1, int x2, int y2, int uv1, int uv2, int64 alphareg, int64 tex1, int color)
{
  gif_env;
  
  y1/=2;
  y2/=2;
  
  x1+=32000;
  y1+=32000;
  x2+=32000;
  y2+=32000;
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  
  {
    gif_tag(0xe,1,0,0,0);
    
    gPRMODECONT(1);				// refer to prim attributes
    gCOLCLAMP(1);
    gDTHE(0);				// Dither off
    
    gCLAMP_2(0);
    gALPHA_2(alphareg);
    
    gTEX0_2(TEX0());
    
    gTEX1_2(tex1);				//bilinear
		//gTEST_1(0x30000);
    //    gTEST_2(0x20000);
    gTEST_2(0x30000);
    gPRIM(PRIMalpha+PRIMsprite+PRIMuv+PRIMtexture+PRIMcontext2);
    gPABE(0);
    gRGBAQ(0x3F80000080000000+color);
    gUV(uv1);
    gXYZ2(hhw(x1,y1));
    gUV(uv2);
    gXYZ2(hhw(x2,y2));
    
    gif_endfinal();
  }
  vif_direct_end();
  dma01_endp();
}

void texture::boxuvargb(int x1, int y1, int x2, int y2, int uv1, int uv2, int argb)
{
  gif_env;
  
  y1/=2;
  y2/=2;
  
  x1+=32000;
  y1+=32000;
  x2+=32000;
  y2+=32000;
  
  dma_begingp();
  gif_tag(0xe,1,0,0,0);
  
  gPRMODECONT(1);				// refer to prim attributes
  gCOLCLAMP(1);
  gDTHE(0);				// Dither off
  
  gCLAMP_1(0);
  //	gALPHA_1(0x4000000048);
  gALPHA_1(0x4000000044);
  
  gTEX0_1(TEX0());
  
  gTEX1_1(1<<5);				//bilinear
  gTEST_1(0x30000);
  gPRIM(0x116+0x40);
  gPABE(0);
  gRGBAQ(0x3F80000000000000+argb);	// Background RGBA
  gUV(uv1);
  gXYZ2(hhw(x1,y1));
  gUV(uv2);
  gXYZ2(hhw(x2,y2));
  
  gif_endfinal();
  dma_endgp();
}

void texture::boxuv(int x, int y)
{
#ifdef NOSKIP
  boxuv(x,y,x+width*16,y+height*16,hhw(0,0),hhw(width*16,height*16));
#else
  boxuv(x+16,y+16,x+width*16-16,y+height*16-16,hhw(16,16),hhw(width*16-16,height*16-16));
#endif
}

void texture::boxuv_vif(int x, int y)
{
#ifdef NOSKIP
  boxuv_vif(x,y,x+width*16,y+height*16,hhw(0,0),hhw(width*16,height*16));
#else
  boxuv_vif(x+16,y+16,x+width*16-16,y+height*16-16,hhw(16,16),hhw(width*16-16,height*16-16));
#endif
}

void wait_ms(int msec)
{
  volatile int a;
  
  for(int s=0;s<msec;s++)
    {
      for(int t=0;t<70000;t++)a=t;
    }
}

static void waitfifoempty()
{
  //	while((VIF1_STAT&(0xf000000)));
  while((VIF1_STAT&(0x1f000000)));
}

void texture::download()
{
// Der m ikke vre overfrsler til GIF mens denne rutine kaldes
// Der m heller ikke vre dma01 lister under opbygning
//...ellers hber jeg den virker
  gif_env;

  //1 vent p vif
  
  FlushCache(0);
  dma01_wait();
  dma02_wait();
  
  //2 skriv finish og transmission parameters
  setbgcolor(0x000080);
  dma01_beginchain(list);
  
  dma01_beginp();
  
  vif_nop();
  vif_nop();
  vif_nop();
  
  vif_flush();
  vif_flushe();
  vif_flusha();
  vif_flush();
  
  vif_direct_begin();
  
  {
    gif_tag(0xe,1,0,0,0);
    
    gVEC(0x50,wwd(0x000000+addr/256+(width<<10),0x0000000));
    gVEC(0x51,wwd(hhw(0,0),0));
    gVEC(0x52,wwd(width,height));
    gFINISH();
    gVEC(0x53,1);
    gif_endfinal();
  }
  vif_direct_end();
  
  dma01_endpchainend();
  
  FlushCache(0);
  
  
  setbgcolor(0x008000);
  setbgcolor(0x808080);

  GIF_vsyncreg=2;

  dma01_wait();

  D1_MADR=((int32)dma01_chainmem)+16;
  D1_TADR=((int32)dma01_chainmem)+16;
  D1_QWC=8;
  D1_CHCR=0x101;//+64;
  

  dma01_wait();
  dma01_wait();

  while(!(GIF_vsyncreg&2));
  while(!(GIF_vsyncreg&2));
  
  GIF_vsyncreg=2;//clear event?
  
  setbgcolor(0x800000);
  
  //3 vent p finish event
  
  dma01_wait();
  waitfifoempty();
  //4 clear event?
  
  //5 set bus direction
  setbgcolor(0x808000);
  GIF_BUSDIR=1;
  VIF1_STAT=0x800000;
  //6 read
  
  D1_MADR=(int32)image;
  D1_TADR=(int32)image;
  D1_QWC=height*width/4;
  D1_CHCR=0x100;//+64;
  

  //7 set bus direction
  wait_ms(2);
  
  GIF_BUSDIR=0;
  VIF1_STAT=0;
  

  setbgcolor(0x808000);
  
  dma01_wait();
  setbgcolor(0xf0f0f0);
  
  setbgcolor(0xf08080);
}


