//#include <tamtypes.h>
//#include "gustavo.h"

#ifdef __cplusplus
extern "C" {
#endif

  extern int GetThreadID(void);
  //void *sif_register_rpc(struct t_rpc_server_data *srv,u32 cmd,void *hand1( u32, void *, int),u8 *buff1,void *hand2( u32, void *, int),u8 *buff2,struct t_rpc_data_queue *q);

#ifndef _SPU_H_
#define _SPU_H_

#define SPU_OFF		0
#define SPU_ON		1
#define SPU_CLEAR	2
#define SPU_RESET	3
#define SPU_ALL		0

#define SPU_TRANSFER_BY_DMA 0
#define SPU_TRANSFER_BY_IO 1

#define SPU_VOICE_00 (1<<0)
#define SPU_VOICE_01 (1<<1)
#define SPU_VOICE_02 (1<<2)
#define SPU_VOICE_03 (1<<3)
#define SPU_VOICE_04 (1<<4)
#define SPU_VOICE_05 (1<<5)
#define SPU_VOICE_06 (1<<6)
#define SPU_VOICE_07 (1<<7)
#define SPU_VOICE_08 (1<<8)
#define SPU_VOICE_09 (1<<9)
#define SPU_VOICE_10 (1<<10)
#define SPU_VOICE_11 (1<<11)
#define SPU_VOICE_12 (1<<12)
#define SPU_VOICE_13 (1<<13)
#define SPU_VOICE_14 (1<<14)
#define SPU_VOICE_15 (1<<15)
#define SPU_VOICE_16 (1<<16)
#define SPU_VOICE_17 (1<<17)
#define SPU_VOICE_18 (1<<18)
#define SPU_VOICE_19 (1<<19)
#define SPU_VOICE_20 (1<<20)
#define SPU_VOICE_21 (1<<21)
#define SPU_VOICE_22 (1<<22)
#define SPU_VOICE_23 (1<<23)

#define SPU_VOICE_X(x) (1<<(x))

#define SPU_VOICE_ALL 0xFFFFFF

  /* used to mask valid parts of spu_common_attr */
#define	SPU_COMMON_MASTER_VOL_LEFT	      (1<<0)
#define	SPU_COMMON_MASTER_VOL_RIGHT	      (1<<1)
#define	SPU_COMMON_MASTER_VOL_MODE_LEFT 	(1<<2)
#define	SPU_COMMON_MASTER_VOL_MODE_RIGHT	(1<<3)

  /* used to mask valid parts of spu_voice_attr */
#define	SPU_VOICE_VOL_LEFT				        (1<<0)
#define	SPU_VOICE_VOL_RIGHT               (1<<1)
#define	SPU_VOICE_VOL_MODE_LEFT           (1<<2)
#define	SPU_VOICE_VOL_MODE_RIGHT          (1<<3)
#define	SPU_VOICE_PITCH				            (1<<4) 
#define	SPU_VOICE_NOTE				            (1<<5)
#define	SPU_VOICE_SAMPLE_NOTE	            (1<<6)
#define	SPU_VOICE_SAMPLE_ADDR	            (1<<7)
#define	SPU_VOICE_ATTACK_MODE	            (1<<8)
#define	SPU_VOICE_SUSTAIN_MODE            (1<<9)
#define	SPU_VOICE_RELEASE_MODE            (1<<10)
#define	SPU_VOICE_ATTACK_RATE             (1<<11)
#define	SPU_VOICE_DEDCAY_RATE             (1<<12)
#define	SPU_VOICE_SUSTAIN_RATE            (1<<13)
#define	SPU_VOICE_RELEASE_RATE            (1<<14)
#define	SPU_VOICE_SUSTAIN_LEVEL           (1<<15)
#define	SPU_VOICE_LOOP_ADDR               (1<<16)
#define	SPU_VOICE_UNKN1                   (1<<17)
#define	SPU_VOICE_UNKN2                   (1<<18)

  struct spu_volume
  {
    short left;
    short right;	
  };

  struct spu_common_attr{
    u32			mask;	 								 	    /* mask for valid attributes */
    struct 	spu_volume		vol;
    struct 	spu_volume		vol_mode; 
    struct 	spu_volume		vol_current;
  };

  struct spu_voice_attr{
    u32			voice;									    /* wich voice to set */
    u32			mask;									    	/* mask for valid attributes */
    struct 	spu_volume		vol;		
    struct 	spu_volume		vol_mode;	
    struct 	spu_volume		vol_current;
    u16			pitch;						    			/* pitch = (freq<<12)/44100; */
    u16			note;										
    u16			sample_note;						
    short		envelopevalue_current;
    u32			sample_addr;								/* startaddress of sample data in spu mem */
    u32			loop_addr;							
    long		attack_mode;
    long		sustain_mode;
    long		release_mode;	
    u16			attack_rate;	
    u16			decay_rate;
    u16			sustain_rate;
    u16			release_rate;
    u16			sustain_level;
    u16			unkn1;
    u16			unkn2;
  };


  /* common functions (found in hanimars disassembler package)*/
#define spuInit	0x0001
#define spuSetCore	0x0002
#define spuSetKey	0x0005
#define spuSetReverb	0x0006
#define spuClearReverbWorkArea	0x0007
#define spuSetReverbEndAddr	0x0008
#define spuSetReverbModeDepth	0x000a
#define spuSetReverbVoice	0x000b
#define spuSetIRQ	0x000c
#define spuSetIRQAddr	0x000d
#define spuSetTransferMode	0x000e
#define spuSetTransferStartAddr	0x0010
#define spuWrite	0x0011
#define spuWrite0	0x0012
#define spuIsTransferCompleted	0x0013
#define spuGetReverbEndAddr	0x0017
#define spuWritePartly	0x0018
#define spuInitHot	0x0019
#define spuIsReverbWorkAreaReserved	0x001a
#define spuMallocWithStartAddr	0x001b
#define spuRead	0x001c
#define spuReadDecodedData	0x001d
#define spuReserveReverbWorkArea	0x001e
#define spuSetMute	0x0020
#define spuSetNoiseClock	0x0021
#define spuSetNoiseVoice	0x0022
#define spuSetPitchLFOVoice	0x0023
#define spuStGetStatus	0x0024
#define spuStGetVoiceStatus	0x0025
#define spuInitMalloc	0x0100
#define spuMalloc	0x0101
#define spuStInit	0x0200
#define spuStQuit	0x0201
#define spuStTransfer	0x0202
#define spuStSetCore	0x0203
#define spuGetIRQAddr	0x100c
#define spuFlush	0x1010
#define spuFree	0x1011
#define spuGetIRQ	0x1013
#define spuGetMute	0x1014
#define spuGetNoiseClock	0x1015
#define spuGetNoiseVoice	0x1016
#define spuGetPitchLFOVoice	0x1017
#define spuGetReverb	0x1018
#define spuGetReverbVoice	0x1019
#define spuGetTransferMode	0x101a
#define spuGetTransferStartAddr	0x101b
#define spuGetKeyStatus	0x101c
#define spuAutoDMAWrite	0x1020
#define spuAutoDMAStop	0x1021
#define spuAutoDMAGetStatus	0x1022
#define spuSetAutoDMAAttr	0x1023
#define spuSetSerialInAttr	0x1024
#define setMultiVoiceNum	0x1030
#define spuSetDigitalOut	0x1031
#define ssBlockVoiceAllocation	0x4001
#define ssEnd	0x4002
#define ssChannelMute	0x4003
#define ssGetActualProgFromProg	0x4004
#define ssGetChannelMute	0x4005
#define ssGetCurrentPoint	0x4006
#define ssGetVoiceMask	0x4007
#define ssInit	0x4008
#define ssIsEos	0x4009
#define ssAllocateVoices	0x400a
#define ssPitchCorrect	0x4010
#define ssPitchFromNote	0x4011
#define ssPlayBack	0x4012
#define ssQueueKeyOn	0x4013
#define ssQueueReverb	0x4014
#define ssQuit	0x4015
#define ssSetTableSize	0x4017
#define ssSetTickMode	0x4018
#define ssSepClose	0x4019
#define ssSepOpen	0x4020
#define ssSepPause	0x4021
#define ssSepPlay	0x4022
#define ssSepReplay	0x4023
#define ssSepSetAccelerando	0x4024
#define ssSepSetCrescendo	0x4025
#define ssSepSetDecrescendo	0x4026
#define ssSepSetRitardando	0x4027
#define ssSepSetVol	0x4028
#define ssSepStop	0x4029
#define ssSeqGetVol	0x4030
#define ssSeqOpen	0x4031
#define ssSeqPause	0x4032
#define ssSeqPlayPtoP	0x4033
#define ssSeqReplay	0x4034
#define ssSeqSetAccelerando	0x4035
#define ssSeqSetCrescendo	0x4036
#define ssSeqSetDecrescendo	0x4037
#define ssSeqSetRitardando	0x4038
#define ssSeqSetNext	0x4039
#define ssSeqCalledTbyT	0x4040
#define ssSeqClose	0x4041
#define ssSeqPlay	0x4042
#define ssSeqSetVol	0x4043
#define ssSeqSkip	0x4044
#define ssSeqStop	0x4045
#define ssSetAutoKeyOffMode	0x4046
#define ssSetCurrentPoint	0x4047
#define ssSetLoop	0x4048
#define ssSetMono	0x4049
#define ssSetMVol	0x404a
#define ssSetNext	0x4050
#define ssSetReservedVoice	0x4051
#define ssSetStereo	0x4052
#define ssSetTempo	0x4053
#define ssSetVoiceMask	0x4054
#define ssStart	0x4055
#define ssStart2	0x4056
#define ssUnBlockVoiceAllocation	0x4057
#define ssUtFlush	0x4058
#define ssUtGetVagAddr	0x4059
#define ssUtGetVagAddrFromTone	0x4060
#define ssUtGetVBaddrInSB	0x4061
#define ssVabClose	0x4062
#define ssVabOpenHead	0x4063
#define ssVabTransBodyPartly	0x4064
#define ssVabTransCompleted	0x4065
#define ssVabTransBody	0x4066
#define ssVoiceCheck	0x4067
#define ssVoKeyOff	0x4068
#define ssVoKeyOn	0x4069
#define ssVabOpenHeadSticky	0x4070
#define stInit	0x5001
#define stQuit	0x5002
#define stCalledVSync	0x5003
#define stVabOpen	0x5005
#define stVabOpenFakeBody	0x5006
#define stVabOpenCompleted	0x5007
#define stVabClose	0x5008
#define stBgmOpen	0x5009
#define stSetTickMode	0x500a
#define stBgmClose	0x500b
#define stSetReverbType	0x500c
#define stSetReverbDepth	0x500d
#define stSetReverbDelaytime	0x500e
#define stSetReverbFeedback	0x500f
#define stGetSlotStatus	0x5010
#define stSetSbClear	0x5011
#define stSetMasterVol	0x5012
#define stSetBgmVol	0x5013
#define stBgmPlay	0x5014
#define stBgmStop	0x5015
#define stSetBgmTempo	0x5016
#define stGetBgmTempo	0x5017
#define stGetBgmStatus	0x5018
#define stGetBgmChStatus	0x5019
#define stDmaWrite	0x501a
#define stDmaRead	0x501b
#define setTimer	0x5100
#define releaseTimer	0x5101
#define stSePlay	0x5200
#define stSetSeVol	0x5201
#define spuGetCommonAttr	0x6128
#define spuGetVoiceAttr	0x6240
#define spuGetReverbModeParam	0x6314
#define spuGetAllKeysstatus	0x6418
#define spuSetCommonAttr	0x7128
#define spuSetVoiceAttr	0x7240
#define spuSetReverbModeParam	0x7314
#define spuSetKeyOnWithAttr	0x7440
#define spuSetEnv	0x7508
#define spuSetVoiceAttr_	0x7600
#define spuSetTransferCallback	0x8100
#define spuSetIRQCallback	0x8200
#define spuAutoDMASetCallback	0x8600
#define _spu_start_thread	0xe621

  /* prototypes */
  int spu_init();
  int spu_remote(u32 mode, u32 function, u32 param1, u32 param2, u32 param3, u32 param4, u32 param5, u32 param6);
  int spu_remote_callback_init(int priority);
  void spu_callback(void *ptr);

#endif


#ifdef __cplusplus
}
#endif
