//----------------------------------------------
// Sample player based on Icewatus' sample code
//----------------------------------------------


#include <tamtypes.h>
#include <kernel.h>
#include <sifrpc.h>
#include <loadfile.h>

#include <sifcmd.h>
#include <kernel.h>
#include <sifrpc.h>
#include <compat.h>

#include "myassert.h"

#include <iopheap.h>

#include "main.h"
#include "sound.h"
#include "vag.h"
#include "gif.h"
#include "spu.h"

#include "math.h"
#include "string.h"

#include "iopupload.h"

#ifndef bzero
#define bzero( _str, _n )            memset( _str, '\0', _n )
#endif


#define SAMPLE_BUFF_SIZE  1024*64*4*2
#define SAMPLE_FREQ       (2*22050)

static char *soundLeft;
static char *soundLeftEnd;
static char *soundRight;
static char *soundRightEnd;

static int packetoffset; // used for fast forwarding

#define packetlength (128) 
#define samplesperpacket (28*packetlength)
#define npackets 32
static float samplefreq=SAMPLE_FREQ;//44100;
static float screenfreq=50;
static int pos;
static int time;
static int posoffset=22;
static int packetModulo;
#define maxpos ((soundLeftEnd-soundLeft)/16/packetlength)

static short pcm[SAMPLE_BUFF_SIZE] __attribute__((aligned(128)));
static u8 vag[SAMPLE_BUFF_SIZE] __attribute__((aligned(128)));

static int    				_init_check = 0;
static struct t_rpc_client_data 	_fio;

static	u8				_send_data[2048] __attribute__((aligned(16)));
static	u8				_recv_data[2048];
static  u8				_intr_data[128];

u32 thread_id;

static int
fileio_init()
{
  sif_rpc_init( 0);
  
  bzero((char*) &_fio, sizeof(_fio));
  if (sif_bind_rpc( &_fio, 0x80000001, 0) < 0)
    return -1;
  if (!_fio.server)
    return -1;
  
  _init_check = 1;
}

static	u32 iop_buffer,spuBufferLeft,spuBufferRight;


int sound_packetsperseconds(float sec)
{
  return (int)(sec*(samplefreq/(float)samplesperpacket));
}

float sound_setpacketoffset(int offset)
{
  packetoffset=offset;
  return offset/(samplefreq/(float)samplesperpacket);
}

float sound_addpacketoffset(int offset)
{
  packetoffset+=offset;
  return offset/(samplefreq/(float)samplesperpacket);
}

static void uploadloop(u32 spu_buffer)
{
  static vec v;
  //extern void PRINT(char *, int, int*);
  
  for(int t=0;t<16;t++)((char*)(&v))[t]=3*(t==1);
  iop_dma_upload((void*)&v,iop_buffer,16);
  tag();
  console_show(5);
  //	PRINT("pitch1 set",(int)spu_buffer,0);
  spu_remote(1,spuSetTransferStartAddr, spu_buffer+16*packetlength*npackets,0,0,0,0,0);
  //	PRINT("pitch2 set",(int)spu_buffer,0);
  tag();
  console_show(5);
  spu_remote(1,spuWrite,iop_buffer,16,0,0,0,0);
}

static void uploadfirstpart(char *sound, int spuBuffer)
{
  //extern void PRINT(char *, int, int*);
  
  iop_dma_upload((void*)(((char*)sound)+64+16*packetlength*(pos)),iop_buffer,16*posoffset*packetlength);
  //	PRINT("pitch1 set",(int)spu_buffer,0);
  tag();
  console_show(5);
  spu_remote(1,spuSetTransferStartAddr, spuBuffer,0,0,0,0,0);
  //	PRINT("pitch2 set",(int)spu_buffer,0);
  tag();
  console_show(5);
  spu_remote(1,spuWrite,iop_buffer,16*packetlength*posoffset,0,0,0,0);
}

void sound_play()
{
  screenfreq=PAL?50:60;
  static int step;
  time++;
  
  switch(step)
    {
    case 0:
      {
	float expectedpos=time/screenfreq*samplefreq/(float)samplesperpacket;
	if(expectedpos>pos)
	  {
	    int pos2=pos+posoffset;
	    pos2%=maxpos;
	    iop_dma_upload((void*)(((char*)soundLeft)+64+16*packetlength*((pos2+packetoffset)%packetModulo)),iop_buffer,packetlength*16);
	    step++;
	  }
      }
      break;
    case 1:
      {
	int pos2=pos+posoffset;
	pos2%=npackets;
	
	spu_remote(1,spuSetTransferStartAddr, spuBufferLeft+16*packetlength*pos2,0,0,0,0,0);
	spu_remote(1,spuWrite,iop_buffer,packetlength*16,0,0,0,0);
	
	step++;
      }
      break;
    case 2:
      {
	float expectedpos=time/screenfreq*samplefreq/(float)samplesperpacket;
	if(expectedpos>pos)
	  {
	    int pos2=pos+posoffset;
	    pos2%=maxpos;
	    iop_dma_upload((void*)(((char*)soundRight)+64+16*packetlength*((pos2+packetoffset)%packetModulo)),iop_buffer,packetlength*16);
	    //	    step++;
	  }
      }
      step++;
      break;
    case 3:
      {
	int pos2=pos+posoffset;
	pos2%=npackets;
	
	spu_remote(1,spuSetTransferStartAddr, spuBufferRight+16*packetlength*pos2,0,0,0,0,0);
	spu_remote(1,spuWrite,iop_buffer,packetlength*16,0,0,0,0);
	
	step++;
      }
      pos++;
      step=0;
      break;
    }
}

//void sound_init(char *left, char *right, int length, float samplefreq, float framespersec)
void sound_init(char *left, char *leftEnd, char *right, char *rightEnd){
  soundLeft=left;
  soundLeftEnd=leftEnd;
  soundRight=right;
  soundRightEnd=rightEnd;

  packetModulo=(leftEnd-left)/(16*packetlength);
  myassert(packetModulo*16*packetlength==rightEnd-right);

  struct spu_common_attr 	common_att __attribute__((aligned(64)));
  struct spu_voice_attr 	voice_att __attribute__((aligned(64)));
  int ret;
  int pcm_size=SAMPLE_BUFF_SIZE,vag_size=0;
  
  //	sif_rpc_init(0); //already done in paduse.c
  
  
  
  
  console_printshow("sound.cpp Loading module");
  ret = SifLoadModule("rom0:OSDSND", 0, 0);
  
  console_printshow("Initialising IOP heap");
  //	iop_heap_init();
  SifInitIopHeap();
  
  tag();
  
  //	setbgcolor(RGB(255,0,0));
  
  
  
  
  
  extern void PRINT(char *, int, int*);

  
  vag_size=2*4*64*1024;
  
  // iop_buffer = iop_heap_alloc(vag_size);
  iop_buffer = (u32) SifAllocIopHeap(vag_size);
  
  tag();

  extern char send_buffer[];
  //	PRINT("UPS",(int)send_buffer);
  console_show(5);
  
  //  binary_soundtrack_start[64+npackets*packetlength*16+1]=3;
  //  binary_soundtrack_start[64+8*16*4096+1-16]=3;
  iop_dma_upload((void*)(((char*)soundLeft)+64),iop_buffer,vag_size);
  
  tag();
  
  // init spu
  spu_init();

  tag();
  
/*
	// init spu callback with thread priority 5
	spu_remote_callback_init(5);
*/
  // make sure this thread has lower priority than callback thread

  tag();
  
  thread_id = k_GetThreadID();
  k_ChangeThreadPriority(thread_id,10);
  
  tag();
  
//	PRINT("UPS",(int)((void*)vag),(int*)send_buffer);
  
//	PRINT("UPS",(int)iop_buffer,0);
  

  console_show(5);
  

  // set spu transfer mode
  spu_remote(1,spuSetTransferMode,SPU_TRANSFER_BY_DMA,0,0,0,0,0);
  
  tag();
  console_show(5);
  // clear all (2MB) spu mem just for showing howto
  spu_remote(1,spuSetTransferStartAddr, 0x5010,0,0,0,0,0);
  tag();
  console_show(5);
  spu_remote(1,spuWrite0, 2*1024*1024-0x5010,0,0,0,0,0);
  tag();
  console_show(5);
	
  // setup malloc and malloc some mem
  spu_remote(1,spuInitMalloc,15,0,0,0,0,0);
  tag();
  console_show(5);
  spuBufferLeft = spu_remote(1,spuMalloc,vag_size,0,0,0,0,0);
  spuBufferRight = spu_remote(1,spuMalloc,vag_size,0,0,0,0,0);
  tag();
  
  //	PRINT("spubuffer",(int)spu_buffer,0);
  tag();
  console_show(5);
  
  //  printf("pass it on to spu by dma transfer...\n");
  
  // transfer sample from iop to spu and sleep while iop dmac does the work for you
  tag();
  spu_remote(1,spuSetTransferStartAddr, spuBufferLeft,0,0,0,0,0);
  tag();
  spu_remote(1,spuWrite,iop_buffer,vag_size,0,0,0,0);
  tag();

  tag();
  uploadfirstpart(soundLeft,spuBufferLeft);
  uploadloop(spuBufferLeft);
  uploadfirstpart(soundRight,spuBufferRight);
  uploadloop(spuBufferRight);
  int i;
  // Turn up master volume
  for( i = 0; i < 2; i++ )
    {
      spu_remote(1,spuSetCore,i,0,0,0,0,0);
      common_att.mask = SPU_COMMON_MASTER_VOL_LEFT | SPU_COMMON_MASTER_VOL_RIGHT;
      common_att.vol.left  = (1)*0x3fff;
      common_att.vol.right = (1)*0x3fff;
      spu_remote(1,spuSetCommonAttr,(u32)&common_att,sizeof(struct spu_common_attr),0,0,0,0);
    }
  
  console_show(5);
  //	PRINT("volume set",(int)spu_buffer,0);
  
  // Set correct pitch for voice
  for( i = 0; i < 2; i++ )
    {
      spu_remote(1,spuSetCore,i,0,0,0,0,0);
      voice_att.mask = SPU_VOICE_PITCH | SPU_VOICE_VOL_LEFT | SPU_VOICE_VOL_RIGHT | SPU_VOICE_SAMPLE_ADDR |SPU_VOICE_LOOP_ADDR;
      voice_att.voice = SPU_VOICE_00+SPU_VOICE_01;//(i)?SPU_VOICE_01:SPU_VOICE_00;
      //		voice_att.pitch = (SAMPLE_FREQ<<12)/44100;    
      voice_att.pitch = (SAMPLE_FREQ<<12)/48000;    
      voice_att.vol.left  = (1-i)*0x3fff;
      voice_att.vol.right = (i)*0x3fff;
      voice_att.sample_addr = (i)?spuBufferRight:spuBufferLeft;
      voice_att.loop_addr = (i)?spuBufferRight:spuBufferLeft;
      //		voice_att.sample_addr = spuBufferRight;
      spu_remote(1,spuSetVoiceAttr,(u32)&voice_att,sizeof(struct spu_voice_attr),0,0,0,0);
    }
  
  console_show(5);
  //	PRINT("pitch set",(int)spu_buffer,0);
  
  // play sample at last
  spu_remote(1,spuSetCore,0,0,0,0,0,0);
  spu_remote(1,spuSetKey,SPU_ON,SPU_VOICE_00,0,0,0,0);
  spu_remote(1,spuSetCore,1,0,0,0,0,0);
  spu_remote(1,spuSetKey,SPU_ON,SPU_VOICE_01,0,0,0,0);
}


void sound_deinit()
{
  spu_remote(1,spuInit,0,0,0,0,0,0);
//	spu_init();
//	spu_remote(1,spuSetKey,SPU_OFF,SPU_VOICE_00,0,0,0,0);
}














