/* RADIAL BLUR */
/* SoopaDoopa 2002 */

#include "radial.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"
#include "vu.h"
#include "matrix.h"
#include "malloc.h"

static int128	list[40];

extern char binary_tex1_start[];

static texture tex1;
static texture tracescreen;

extern int PAL;

static texture *tempscreen;
static texture *screen;
static int iframe;
static float timing;

static void setcurrent(texture *screen, int interlace)
{
  screen->dmalistframe1(interlace);
  /*	gif_env;
	
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  vif_direct_end_(screen->dmalistframe2(interlace,(int128*)dma01_currentpos));
  dma01_endp();
  */
}


static void puttexture(texture *tex, float posx, float posy, float width, float height)
{
  int x1=(int)(32000+(posx-width*0.5)*16);
  int y1=(int)(32000+(posy-height*0.5)*16);
  int x2=(int)(32000+(posx+width*0.5)*16);
  int y2=(int)(32000+(posy+height*0.5)*16);
  
  gif_env;
  
  dma_begingp();
  gif_tag(0xe,1,0,0,0);
  
  gPRMODECONT(1);				// refer to prim attributes
  gCOLCLAMP(1);
  gCLAMP_1(0x1000010005);
  gALPHA_1(0x4000000044);
  gDTHE(0);				// Dither off
  gTEX0_1(tex->TEX0());
  gTEX1_1(1<<5);				//bilinear
  gTEST_1(0x30000);
  gPRIM(0x116+0x40);
  gPRIM(0x116);
  gPABE(0);
  gRGBAQ(0x3F80000080808080);		// Background RGBA
  gUV(hhw(0,0));
  gXYZ2(hhw(x1,y1));
  gUV(hhw((tex->width)*16,(tex->height)*16));
  gXYZ2(hhw(x2,y2));
  gif_endfinal();
  
  dma_endgp();
}

static void puttexture_nobil(texture *tex, float posx, float posy, float width, float height)
{
  int x1=(int)(32000+(posx-width*0.5)*16);
  int y1=(int)(32000+(posy-height*0.5)*16);
  int x2=(int)(32000+(posx+width*0.5)*16);
  int y2=(int)(32000+(posy+height*0.5)*16);
  
  gif_env;
  
  dma_begingp();
  gif_tag(0xe,1,0,0,0);
  
  gPRMODECONT(1);				// refer to prim attributes
  gCOLCLAMP(1);
  gCLAMP_1(0x1000010005);
  gALPHA_1(0x4000000044);
  gDTHE(0);				// Dither off
  gTEX0_1(tex->TEX0());
  gTEX1_1(0<<5);				//bilinear
  gTEST_1(0x30000);
  gPRIM(0x116+0x40);
  gPRIM(0x116);
  gPABE(0);
  gRGBAQ(0x3F80000080808080);		// Background RGBA
  gUV(hhw(0,0));
  gXYZ2(hhw(x1,y1));
  gUV(hhw((tex->width)*16,(tex->height)*16));
  gXYZ2(hhw(x2,y2));
  gif_endfinal();

  dma_endgp();
}

static void magnify(texture *tex)
{
  tex->dmalistframe1(0);
  
  int x1=(int)(32000+320*16);
  int y1=(int)(32000+128*16);
  int x2=(int)(32000+640*16);
  int y2=(int)(32000+256*16);
	
  gif_env;
	
  dma_begingp();
  gif_tag(0xe,1,0,0,0);

  gPRMODECONT(1);				// refer to prim attributes
  gCOLCLAMP(1);
  gCLAMP_1(0x1000010005);
  gALPHA_1(0x4000000044);
  gDTHE(0);				// Dither off
  gTEX0_1(tex->TEX0());
  gTEX1_1(0<<5);				//bilinear
  gTEST_1(0x30000);
  gPRIM(0x116+0x40);
  gPRIM(0x116);
  gPABE(0);
  gRGBAQ(0x3F80000080808080);		// Background RGBA
  gUV(hhw(0,0));
  gXYZ2(hhw(x1,y1));
  gUV(hhw(2*40*16,2*16*16));
  gXYZ2(hhw(x2,y2));
  gif_endfinal();

  dma_endgp();
}

static void puttexture2(texture *tex, float posx, float posy, float width, float height)
{
  int x1=(int)(32000+(posx-width*0.5)*16);
  int y1=(int)(32000+(posy-height*0.5)*16);
  int x2=(int)(32000+(posx+width*0.5)*16);
  int y2=(int)(32000+(posy+height*0.5)*16);
	
  gif_env;
	
  dma_begingp();
  gif_tag(0xe,1,0,0,0);

  gPRMODECONT(1);				// refer to prim attributes
  gCOLCLAMP(1);
  gCLAMP_1(0x1000010005);
  gALPHA_1(0x4000000044);
  gDTHE(0);				// Dither off
  gTEX0_1((tex->TEX0())+((20-8)<<14));
  gTEX1_1(0<<5);				//bilinear
  gTEST_1(0x30000);
  gPRIM(0x116+0x40);
  gPRIM(0x116);
  gPABE(0);
  gRGBAQ(0x3F80000080808080);		// Background RGBA
  gUV(hhw(0,0));
  gXYZ2(hhw(x1,y1));
  gUV(hhw((tex->width)*16,(tex->height)*16));
  gXYZ2(hhw(x2,y2));
  gif_endfinal();

  dma_endgp();
}

static void puttexture_alpha(texture *tex, float posx, float posy, float width, float height)
{
  int x1=(int)(32000+(posx-width*0.5)*16);
  int y1=(int)(32000+(posy-height*0.5)*16);
  int x2=(int)(32000+(posx+width*0.5)*16);
  int y2=(int)(32000+(posy+height*0.5)*16);
	
  gif_env;
	
  dma_begingp();
  gif_tag(0xe,1,0,0,0);

  gPRMODECONT(1);				// refer to prim attributes
  gCOLCLAMP(1);
  gCLAMP_1(0x1000010005);
  gALPHA_1(0x4000000044);
  gALPHA_1(0x4000000064);
  gDTHE(0);				// Dither off
  gTEX0_1(tex->TEX0());
  gTEX1_1(1<<5);				//bilinear
  gTEST_1(0x30000);
  gPRIM(0x116+0x40);
  gPABE(0);
  gRGBAQ(0x3F80000080808080);		// Background RGBA
  gUV(hhw(0,0));
  gXYZ2(hhw(x1,y1));
  gUV(hhw((tex->width)*16,(tex->height)*16));
  gXYZ2(hhw(x2,y2));
  gif_endfinal();

  dma_endgp();
}

texture scr8;

void radial_getredcolor(texture *source, texture *dest)
{
  dest->dmalistframe1(0);
  scr8.addr=source->addr;
	
  for(int x=0;x<160;x++)
    {
      int x1=(int)(32000+(x*8)*16);
      int y1=(int)(32000+(0)*16);
      int x2=(int)(32000+(x*8+8)*16);
      int y2=(int)(32000+(127)*16);
	
      gif_env;
	
      dma_begingp();
      gif_tag(0xe,1,0,0,0);

      gSCANMSK(3);


      //	gFRAME_1(0x0000000+((dest->width/64*2)<<16)+dest->addr/2048/4);	// framebuffer width = 640/64

      gPRMODECONT(1);				// refer to prim attributes
      gCOLCLAMP(1);
      gCLAMP_1(0x1000010005);
      gALPHA_1(0x4000000044);
      gDTHE(0);				// Dither off
      gTEX0_1((scr8.TEX0())+((20-8)<<14));
      gTEX1_1(0<<5);				//bilinear
      gTEST_1(0x30000);
      gPRIM(0x116+0x40);
      gPRIM(0x116);
      gPABE(0);
      gRGBAQ(0x3F80000080808080);		// Background RGBA
      gUV(hhw(x*16*16,0));
      gXYZ2(hhw(x1,y1));
      gUV(hhw((x*16+8)*16,2*254*16));
      gXYZ2(hhw(x2,y2));

      gSCANMSK(2);
      gCLAMP_1(3+((1023-8)<<4));
      gUV(hhw(x*16*16+64,0));
      gXYZ2(hhw(x1,y1));
      gUV(hhw((x*16+8)*16+64,2*254*16));
      gXYZ2(hhw(x2,y2));
      gCLAMP_1(0);

      gif_endfinal();

      dma_endgp();
    }
}


void radial_getbluecolor(texture *source, texture *dest)
{
  dest->dmalistframe1(0);
  scr8.addr=source->addr;
	
  for(int x=0;x<160;x++)
    {
      int x1=(int)(32000+(x*8)*16);
      int y1=(int)(32000+(0)*16);
      int x2=(int)(32000+(x*8+8)*16);
      int y2=(int)(32000+(127)*16);
	
      gif_env;
	
      dma_begingp();
      gif_tag(0xe,1,0,0,0);

      gSCANMSK(3);


      //	gFRAME_1(0x0000000+((dest->width/64*2)<<16)+dest->addr/2048/4);	// framebuffer width = 640/64

      gPRMODECONT(1);				// refer to prim attributes
      gCOLCLAMP(1);
      gCLAMP_1(0x1000010005);
      gALPHA_1(0x4000000044);
      gDTHE(0);				// Dither off
      gTEX0_1((scr8.TEX0())+((20-8)<<14));
      gTEX1_1(0<<5);				//bilinear
      gTEST_1(0x30000);
      gPRIM(0x116+0x40);
      gPRIM(0x116);
      gPABE(0);
      gRGBAQ(0x3F80000080808080);		// Background RGBA
      gUV(hhw(x*16*16+128,0));
      gXYZ2(hhw(x1,y1));
      gUV(hhw((x*16+16)*16,2*254*16));
      gXYZ2(hhw(x2,y2));

      gSCANMSK(2);
      gCLAMP_1(3+((1023-8)<<4)+((8)<<14));
      gUV(hhw(x*16*16+64,0));
      gXYZ2(hhw(x1,y1));
      gUV(hhw((x*16+8)*16+64,2*254*16));
      gXYZ2(hhw(x2,y2));
      gCLAMP_1(0);

      gif_endfinal();

      dma_endgp();
    }
}

void radial_getbluecolorny(texture *source, texture *dest)
{
  dest->dmalistframe1(0);
  scr8.addr=source->addr;
	
  for(int x=0;x<160;x++)
    {
      int x1=(int)(32000+(x*8)*16);
      int y1=(int)(32000+(0)*16);
      int x2=(int)(32000+(x*8+8)*16);
      int y2=(int)(32000+(63)*16);
	
      gif_env;
	
      dma_begingp();
      gif_tag(0xe,1,0,0,0);

      //	gSCANMSK(3);


      //	gFRAME_1(0x0000000+((dest->width/64*2)<<16)+dest->addr/2048/4);	// framebuffer width = 640/64

      gPRMODECONT(1);				// refer to prim attributes
      gCOLCLAMP(1);
      gCLAMP_1(0x1000010005);
      gALPHA_1(0x4000000044);
      gDTHE(0);				// Dither off
      gTEX0_1((scr8.TEX0())+((20-8)<<14));
      gTEX1_1(0<<5);				//bilinear
      gTEST_1(0x30000);
      gPRIM(0x116+0x40);
      gPRIM(0x116);
      gPABE(0);
      gRGBAQ(0x3F80000080808080);		// Background RGBA
      gUV(hhw(x*16*16+128,0));
      gXYZ2(hhw(x1,y1));
      gUV(hhw((x*16+16)*16,252*8));
      gXYZ2(hhw(x2,y2));

      /*	gSCANMSK(2);
		gCLAMP_1(3+((1023-8)<<4)+((8)<<14));
		gUV(hhw(x*16*16+64,0));
		gXYZ2(hhw(x1,y1));
		gUV(hhw((x*16+8)*16+64,2*254*16));
		gXYZ2(hhw(x2,y2));
		gCLAMP_1(0);
      */
      gif_endfinal();

      dma_endgp();
    }
}


void radial_init()
{
  tex1.init();
  tex1.load(binary_tex1_start);

  /*	for(int t=0;t<65536;t++)((int32*)tex1.image)[t]=0x0;
	for(int y=0;y<256;y++)
	{
	for(int t=0;t<y;t++)((int32*)tex1.image)[t+0*8*1024+y*256]=0x00ffffff;
	}
	for(int t=0;t<65536;t++)((int32*)tex1.image)[t]=0x03020100+(((int32*)tex1.image)[t]&0xfcfcfcfc);
  */
  scr8.init();
  scr8.width=256*2;
  scr8.height=256*2;
  scr8.bitsperpixel=8;
  scr8.allocclut();
  scr8.memallocclut();
  for(int t=0;t<256;t++)scr8.clut[t]=rgb(t*((t&3)==0)+t*((t&3)==3),t*((t&3)==1)+t*((t&3)==3),t*((t&3)==2)+t*((t&3)==3));
  scr8.uploadclut();	
}

void radial_init2()
{
  tex1.allocupload();
}

void radial_frame(float frames, texture *screen_, texture *tempscreen_, int iframe_, float timing_)
{
  tempscreen=tempscreen_;
  screen=screen_;
  iframe=iframe_;
  timing=timing_;

  scr8.addr=screen->addr;

  frames*=2;
  //	vutest(frames);

  screen->dmalistframe1(0);
  //	puttexture(&tex1,320+100*cos(frames*0.02),128+50*cos(frames*0.015),256,256/2);
  puttexture(&tex1,320+100*cos(frames*0.02),128+50*cos(frames*0.015),256,256/2);

  for(int t=0;t<12;t++)
    {
      tempscreen->dmalistframe1(0);
      puttexture(screen,320,128,640,256);
      screen->dmalistframe1(0);
      puttexture_alpha(tempscreen,320,128,(1+timing*2.0/(2+t))*640,(1+timing*2.0/(2+t))*256);
    }
  /*

  {
  static int t=0;
  static int r;
  r++;
  if(!(r&1))
  {		((int32*)tex1.image)[t+0*8*1024+0*256]=0xfffefdfc;
  t++;
  }		tex1.upload(tex1.addr);


  //		tempscreen->dmalistframe1(0);
  //		puttexture(&tex1,320+100*cos(frames*0.02),128+50*cos(frames*0.015),256,256/2);
  }
  tempscreen->dmalistframe1(0);
  puttexture_nobil(&tex1,128,128,256,256);
  radial_getbluecolor(tempscreen,screen);
  /*	scr8.addr=tempscreen->addr;
  screen->dmalistframe1(0);
  puttexture2(&scr8,256,128,512,256);
  */
  /*
    magnify(screen);
  */
}

void radial_deinit()
{
}
