/* 3D PIXEL */
/* SoopaDoopa 2002 */

#define SAMPLEBUFX 256
#define SAMPLEBUFY 128
#define SAMPLESTEPX 1

#include "pixel.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"
#include "vu.h"
#include "matrix.h"
#include "timing.h"
#include "mesh.h"
#include "malloc.h"
#include "main.h"
#include "spline.h"
#include "overlay.h"

#include "myassert.h"

static int128	list[40];

extern unsigned int pixel_vucodebegin  __attribute__((section(".vudata")));
extern unsigned int pixel_vucodeend  __attribute__((section(".vudata")));
extern unsigned int pixel_vudatabegin  __attribute__((section(".vudata")));
extern unsigned int pixel_vudataend  __attribute__((section(".vudata")));
extern unsigned int pixel_vudataend2  __attribute__((section(".vudata")));

extern char binary_sdlogo3ds_start[];
extern char binary_sdlogopcx_start[];
extern char binary_metablob3ds_start[];
extern char binary_metablobpcx_start[];

extern int128 pixel_e_start,pixel_e_delta,pixel_e_giftag,pixel_e_matrix,pixel_e_seed   __attribute__((section(".vudata")));
extern vec pixel_e_light,pixel_e_lightcolor   __attribute__((section(".vudata")));

static float sss1,sss2,sss3;
static float maxzoom;
static int scrollv;

static texture *tempscreen;
static texture *screen;
static int iframe;
static texture *background;

static mesh themesh[2];
static texture tex1[2];

static float scalex;

static int objectSelector=1;

static float localFrames[2];

#define ZPOSITION 1150

static fvec ver(float x, float y, float z)
{
  fvec v;
  
  v.x=x;
  v.y=y;
  v.z=z;
  v.w=1.0;
  
  return v;
}

static ivec fac(int x, int y, int z)
{
  ivec v;
  
  v.x=x;
  v.y=y;
  v.z=z;
  v.w=0;
  
  return v;
}

extern int PAL;


typedef ivec pixel;

typedef pixel* level3[64];
typedef level3* level2[64];
typedef level2* level1[64];

#define maxlev1 64
#define maxlev2 16*16*2*2
#define maxlev3 16*16*16*2
#define maxpix 256*128

static level1 lev1mem[maxlev1];
static level2 lev2mem[maxlev2];
static level3 lev3mem[maxlev3];
static pixel pixelmem[maxpix];

static level1* lev0[64];

static int next1,next2,next3,nextp;

static texture zbuf,colbuf;

linearSpline fadeSpline;

static void clearmem()
{
  next1=next2=next3=nextp=0;
  
  for(int t=0;t<64;t++)
    {
      lev0[t]=0;
    }
}

static inline void addpixel(int x, int y, int z, int col/*ivec q*/)
{
  //	x&=255;
  //	y&=255;
  //	z&=255;
  
#if 0
  int i0=(z>>2)&48|(y>>4)&12|(x>>6)&3;
  int i1=(z   )&48|(y>>2)&12|(x>>4)&3;
  int i2=(z<<2)&48|(y   )&12|(x>>2)&3;
  int i3=(z<<4)&48|(y<<2)&12|(x   )&3;
#else
  int x2=x;
  int y2=y<<2;
  int z2=z<<4;
  int i0=(z2&3072|y2&768|x2&192)>>6;
  int i1=(z2&768|y2&192|x2&48)>>4;
  int i2=(z2&192|y2&48|x2&12)>>2;
  int i3=z2&48|y2&12|x2&3;
#endif
  
  level1 *lev1=lev0[i0];
  if(!lev1)
    {
      myassert(next1<maxlev1);
      lev1=lev0[i0]=lev1mem+(next1++);
      for(int i=0;i<64;i++)(*lev1)[i]=0;
    }
  level2 *lev2=(*lev1)[i1];
  if(!lev2)
    {
      myassert(next2<maxlev2);
      lev2=(*lev1)[i1]=lev2mem+(next2++);
      for(int i=0;i<64;i++)(*lev2)[i]=0;
    }
  level3 *lev3=(*lev2)[i2];
  if(!lev3)
    {
      myassert(next3<maxlev3);
      lev3=(*lev2)[i2]=lev3mem+(next3++);
      for(int i=0;i<64;i++)(*lev3)[i]=0;
    }
  pixel *p=(*lev3)[i3];
  if(!p)
    {
      //	    myassert(nextp<maxpix);
      p=(*lev3)[i3]=pixelmem+(nextp++);
      p->x=0;p->y=0;p->z=0;p->w=0;
    }
  
  p->x+=col&255;
  p->y+=col&(255*256);
  p->z+=(col>>16)&255;
	/*	p->x+=q.x;
		p->y+=q.y;
		p->z+=q.z;
	*/
  p->w+=1;
}


static int getpixels(int &i0, int &i1, int &i2, int &i3, int128 *m, int max)
{
  // "coroutine" for traversing the pixel set structure
  // and generate a list of positions and colors with length atmost max pixel entries
  int n=0;
  
  for(;i0<64;i0++)
    {
      level1 *lev1=lev0[i0];
      if(lev1)
	for(;i1<64;i1++)
	  {
	    level2 *lev2=(*lev1)[i1];
	    if(lev2)
	      for(;i2<64;i2++)
		{
		  level3 *lev3=(*lev2)[i2];
		  if(lev3)
		    {
		      int X=((i0&3)<<6)+((i1&3)<<4)+((i2&3)<<2);
		      int Y=((i0&12)<<4)+((i1&12)<<2)+((i2&12));
		      int Z=((i0&48)<<2)+((i1&48))+((i2&48)>>2);
		      for(;i3<64;i3++)
			{
			  ivec *p=(*lev3)[i3];
			  if(p)
			    {
			      int x=X+((i3&3));
			      int y=Y+((i3&12)>>2);
			      int z=Z+((i3)>>4);
			      
			      p->y>>=8;
			      ((ivec*)m)->x=x;
			      ((ivec*)m)->y=y;
			      ((ivec*)m)->z=z;
			      ((ivec*)m)->w=0;
			      *(m+1)=*(int128*)p;
			      m+=2;
			      n++;
			      if(n>=max)return n;
			    }
			}
		    }
		  i3=0;
		}
	    i2=0;
	  }
      i1=0;
    }
  return n;
}








static void sendhexagon()
{
  pixel_e_giftag.hi=0x55155155155;
  pixel_e_giftag.lo=0xb000000000008001+GTP(PRIMtrianglefan+PRIMcontext2);
}

static void setupvif()
{
  gif_env;
  
  initvifdmalist();
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_mpg(((char*)&pixel_vucodeend-(char*)&pixel_vucodebegin)>>3,0);
  dma01_endp();
  
  dma01_ref(&pixel_vucodebegin,&pixel_vucodeend);
  
  sendhexagon();
  
  uploadvudata((char*)&pixel_vudatabegin,(char*)&pixel_vudataend);

  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  
  {
    gif_tag(0xe,1,0,0,0);
    gPRMODECONT(1);
    gCOLCLAMP(1);
    gDTHE(0);
    gTEST_2(0x70000);
    gALPHA_2(0x8000000068);
    gif_endfinal();
  }
  vif_direct_end();
  dma01_endp();
}


static float timingRotate;

static void drawPixels(float frames, float pos)
{
  frames+=350;

  static float angle;
  int x=20,y;
  float s;
  fmatrix M;
  fmatrix M2;
  fmatrix m;
  vec light;
	
  gif_env;
  
  frames*=0.10;
  pos*=0.10;
	
  angle=0.005*3*4*frames;
  
  // Setup "screen to grid" matrix
  {
    static float zoom;
    if(objectSelector==0)
      {
	static int oldV;
	static float direction;
	{
	  const int channel=10;
	  static float oldTime11; 
	  if(timing::gettime(channel)!=oldTime11 && timing::getval2(channel)>0)
	    {
	      int v=timing::getval(channel);
	      direction=(oldV-v)/8.0f;
	      zoom=22+v;
	      oldV=v;
	    }
	  oldTime11=timing::gettime(channel);
	}
	
	zoom+=direction;
	if(zoom<22)zoom=22;
      }
    else
       zoom=92-66*cos2(frames*0.1);
    
    resetmatrixf(&M);
    resetmatrixf(&m);
    movematrixf(&M,-128,-128,-128);
    
    scalematrixf(&M,scalex,1,1);
    fscalematrixf(&m,1/scalex,1,1);

    rotatematrixxf(&M,frames*0.1*0.1);
    frotatematrixxf(&m,-frames*0.1*0.1);
    rotatematrixyf(&M,frames*0.3*0.1+timingRotate);
    frotatematrixyf(&m,-frames*0.3*0.1-timingRotate);
    rotatematrixzf(&M,frames*0.3*0.1);
    frotatematrixzf(&m,-frames*0.3*0.1);
    
    scalematrixf(&M,zoom,zoom,zoom);
    fscalematrixf(&m,1/zoom,1/zoom,1/zoom);
    
    movematrixf(&M,0,0,ZPOSITION);
    
    M2=M;

    scalematrixf(&M,256.0/320,1,1.5);
    screenmatrixf(&M,640*16,256*16,32000,32000);
    scalematrixf(&M,90,90,90);
    

    light.fv.y=M2.zu/sqrt(M2.xu*M2.xu+M2.yu*M2.yu+M2.zu*M2.zu);
    light.fv.y=0.75+0.25*sqrt(light.fv.y*light.fv.y);
    light.fv.z=M2.zv/sqrt(M2.xv*M2.xv+M2.yv*M2.yv+M2.zv*M2.zv);
    light.fv.z=0.75+0.25*sqrt(light.fv.z*light.fv.z);
    light.fv.x=M2.zw/sqrt(M2.xw*M2.xw+M2.yw*M2.yw+M2.zw*M2.zw);
    light.fv.x=0.75+0.25*sqrt(light.fv.x*light.fv.x);
  }

  static int notfirst;
  // Insert the pixel boxes into the pixel set structure
  {
    s=0.2;//+(x-posrel+1)*0.014;
    
    int i0,i1,i2,i3;
    int n;
    ivec col;
    clearmem();

    // additional adjustment??

    movematrixf(&m,-ZPOSITION*m.xw,-ZPOSITION*m.yw,-ZPOSITION*m.zw);
    // scalematrixf(&m,0.1,0.1,0.1);
    movematrixf(&m,128,128,128);
    //corresponding to:
    // z2-=1000


    /*
	      v.x*=1.0/100;
	      v.y*=1.0/100;
	      v.x*=(2.0f/SAMPLEBUFX);
	      v.y*=(2.0f/SAMPLEBUFY);
	      v.z*=1.0/100;
	      v.x-=v.z;
	      v.y-=v.z;
    */


    m.xw-=m.xu;
    m.xw-=m.xv;
    m.yw-=m.yu;
    m.yw-=m.yv;
    m.zw-=m.zu;
    m.zw-=m.zv;
   
    fscalematrixf(&m,(2.0f/SAMPLEBUFX)/100,(2.0f/SAMPLEBUFY)/100,1.0/100);

    setbgcolor(0);

    __asm__ __volatile__(
		"lqc2	vf8, 0x0(%0)\n"
		"lqc2	vf9, 0x10(%0)\n"
		"lqc2	vf10, 0x20(%0)\n"
		"lqc2	vf11, 0x30(%0)\n"

		
		 : : "r" (&m));
    
    for(int Y=0;Y<4;Y++)
      for(int X=0;X<4;X++)
	for(int y=(SAMPLEBUFY/4)*Y;y<((SAMPLEBUFY/4)*(Y+1));y+=1)
	  for(int x=(SAMPLEBUFX/4)*X;x<((SAMPLEBUFX/4)*(X+1));x+=SAMPLESTEPX)
	//    for(int y=0;y<SAMPLEBUFY;y+=1)
	//      for(int x=0;x<SAMPLEBUFX;x+=SAMPLESTEPX)
	{
	  int index=SAMPLEBUFX*(y^16)+(x^32);
	  int index2=SAMPLEBUFX*(y)+(x);
	  int z=zbuf.image[index];
	  //	  printf("%i\n",index);
	  //    if(!notfirst)printf("%x\n",z);
	  if(z!=0)
	    {
	      ivec col;
	      fvec v;

	      /*	      v.x=x*(2.0f/SAMPLEBUFX)-1;
	      v.y=y*(2.0f/SAMPLEBUFY)-1;
	      v.z=(3000.0f-z)/100;
	      v.x*=v.z;
	      v.y*=v.z;
	      */
	      v.x=x;
	      v.y=y;
	      v.z=3000.0f-z;
	      v.x*=v.z;
	      v.y*=v.z;
	      
	      /*v.x*=1.0/100;
	      v.y*=1.0/100;
	      v.x*=(2.0f/SAMPLEBUFX);
	      v.y*=(2.0f/SAMPLEBUFY);
	      v.z*=1.0/100;
	      v.x-=v.z;
	      v.y-=v.z;
	      */
#if 0
	      fvec t;

	      t.x=m.xu*v.x+m.xv*v.y+m.xw*v.z+m.xx;
	      t.y=m.yu*v.x+m.yv*v.y+m.yw*v.z+m.yy;
	      t.z=m.zu*v.x+m.zv*v.y+m.zw*v.z+m.zz;
	      
	      addpixel((int)(t.x),(int)(t.y),(int)(t.z),colbuf.image[index2]);
#else
	      ivec t;
	      __asm__ __volatile__(
		"lqc2	vf4, 0x0(%0)\n"

		"vmulaw.xyz	ACC,vf11,vf0w\n"
		"vmaddax.xyz	ACC,vf8,vf4x\n"
		"VMADDAy.xyz	ACC,vf9,vf4y\n"
		"vmaddz.xyz	vf5,vf10,vf4z\n"
                "vftoi0   vf5,vf5\n"

		"sqc2	vf5,0x0(%1)"
		
		 : : "r" (&(v)),"r" (&t));
	      
	      addpixel((int)(t.x),(int)(t.y),(int)(t.z),colbuf.image[index2]);
#endif	      
	    }
	}
    notfirst=1;
    /*	{
	  int index=640*(y^16)+(x^32);
	  int index2=640*(y)+(x);
	  int z=zbuf.image[index];
	  ivec col;
	  float z2=40000-z;
	  z2*=0.01;
	  float x2=(x*(2.0f/SAMPLEBUFX)-1);
	  float y2=(y*(2.0f/SAMPLEBUFY)-1);
	  x2*=z2;
	  y2*=z2;

	  z2-=1000;
	  z2*=0.1;
	  x2*=0.1;
	  y2*=0.1;
	  
	  fvec t;
	  t.x=m.xu*x2+m.xv*y2+m.xw*z2+m.xx;
	  t.y=m.yu*x2+m.yv*y2+m.yw*z2+m.yy;
	  t.z=m.zu*x2+m.zv*y2+m.zw*z2+m.zz;
	  x2=t.x;
	  y2=t.y;
	  z2=t.z;
	  
	  col.x=(colbuf.image[index2])&255;
	  col.y=(colbuf.image[index2]>>8)&255;
	  col.z=(colbuf.image[index2]>>16)&255;
	  if(z<-10)
	    addpixel((int)(128+x2),(int)(128+y2),(int)(128+z2),col);
	    }*/

    setbgcolor(0x808080);

    // Traverse pixel set structure and generate vu data
    dma01_beginp();
    vif_flushe();
    vif_base(20);
    vif_offset(420);
    vif_stcycl(0x101);
    vif_stmask(0);
    
    i0=i1=i2=i3=0;
    while(n=getpixels(i0,i1,i2,i3,(int128*)(dma01_currentpos+2+6*4),100))
      {
	int length=2*n+6;
	vec pos;
	vec nv;
	fmatrix *m;
	nv.iv.x=n;
	vif_nop();
	vif_unpack(length,0+0x8000);
	m=(fmatrix*)dma01_currentpos;
	vif_128(nv.i128);
	vif_128(light.i128);
	vif_128(((int128*)&M)[0]);
	vif_128(((int128*)&M)[1]);
	vif_128(((int128*)&M)[2]);
	vif_128(((int128*)&M)[3]);
	
	dma01_currentpos+=4*(2*n);
	
	vif_mscal(0x0);
	vif_nop();
      }
    setbgcolor(0);
    
    vif_flush();
    vif_flusha();
    vif_flushe();
    vif_flush();
    vif_nop();
    vif_nop();
    dma01_endp();
  }
  //  printf("nextp:%i next1: %i next2: %i next3: %i\n",nextp,next1,next2,next3);
}

static void tunnel(float pos)
{
  setbgcolor(rgb(255,0,0));

  float frames=localFrames[objectSelector];

  if(objectSelector==0)
    {
      if(frames>351.415)frames=340;
      else
	if(frames>320)
	  frames=320+20*sin((frames-320)/20.0f);
    }

  gif_env;
  
  setupvif();
  
  screen->setcurrent_vif(1-iframe);
  screen->setcurrent_vif2(1-iframe);
  
  //clearscreen
  //screen->clear_vif(0*0xff00ff+1*0x595909,1);
  main_renderBackground(iframe,false);
	
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  
  {
    gif_tag(0xe,1,0,0,0);
    gTEST_2(0x70000);
    gif_endfinal();
  }
  vif_direct_end();
  dma01_endp();

  setbgcolor(rgb(0,255,0));
  //effect
  drawPixels(frames,pos);
  setbgcolor(rgb(0,0,255));

  screen->setcurrent_vif(1);
  //screen->clear_vif(0x802030);


  if(objectSelector==0)
    {
      int fade=int(fadeSpline.evaluate(localFrames[objectSelector]));
      overlay_maxcolor=fade*2;
      if(fade!=256)texture::boxNoTexture_vif(0, 0, 640*16, 512*16, 0x10000000, 0x000000A9+((int64)fade<<32));
    }
  //	main_renderBackground(iframe,true);

  //    colbuf.boxuv_vif(0,0,SAMPLEBUFX*16,SAMPLEBUFY*2*16,0,hhw(SAMPLEBUFX*16,SAMPLEBUFY*16));

  fmatrix M;
  fmatrix L;
  

  resetmatrixf(&M);
  resetmatrixf(&L);
  screen->setcurrent_vif(1);
  //	screen->clear_vif(0x802030);
  //	screen->clear_vif(0x202030);
  
  scalematrixf(&M,1.1,1.1,1.1);
  rotatematrixxf(&M,0.3*3.14);
  rotatematrixxf(&L,0.3*3.14);
  rotatematrixzf(&M,0.2*3.14);
  rotatematrixzf(&L,0.2*3.14);
  rotatematrixxf(&M,frames*0.01);
  rotatematrixyf(&M,frames*0.009);
  rotatematrixzf(&M,frames*0.008);
  rotatematrixxf(&L,frames*0.01);
  rotatematrixyf(&L,frames*0.009);
  rotatematrixzf(&L,frames*0.008);
  scalematrixf(&M,1,(float)SAMPLEBUFX/(SAMPLEBUFY*2),1);
  movematrixf(&M,0,0,ZPOSITION);
  screenmatrixf(&M,SAMPLEBUFX*16,SAMPLEBUFY*16,32000,32000);
  scalematrixf(&M,100,100,100);
  fscalematrixf(&M,3,3,3);


  tex1[objectSelector].upload_vif(tempscreen->addr);
  {
    gif_env;
    
    dma01_beginp();
    vif_nop();
    vif_nop();
    vif_nop();
    vif_direct_begin();
    
    {
      
      gif_tag(0xe,1,0,0,0);
      gTEX0_2(tex1[objectSelector].TEX0()+((int64)1<<35));//nolight!
      gTEX1_2(1<<5);				//bilinear
      gif_endfinal();
      
    }
    vif_direct_end();
    
    dma01_endp();
  }

  colbuf.setcurrent_vif2(0);
  colbuf.setcurrent_vif(0);
  colbuf.clear_vif(0x595909);
 
  setbgcolor(rgb(0,255,0));
  setbgcolor(rgb(255,255,255));
  themesh[objectSelector].setupvif();
  themesh[objectSelector].draw_vu(&M,&L);
  //	themesh.draw(&M);
  setbgcolor(rgb(0,255,0));

  dma01_endchain();
  setbgcolor(RGB(255,255,255));
  dma01_wait();
  setbgcolor(RGB(0,255,255));
}

void pixel_init()
{
  localFrames[0]=-250;
  localFrames[1]=-250;

  tex1[0].init();
  tex1[0].load(binary_sdlogopcx_start);
  tex1[1].init();
  tex1[1].load(binary_metablobpcx_start);
  
  themesh[0].tetrahedron();
  themesh[1].tetrahedron();
  themesh[0].load(binary_sdlogo3ds_start,"Text02",1,1);
  themesh[0].vudataalloc(2*3*1024);
  themesh[1].load(binary_metablob3ds_start,"Clay Surfa",1,1);
  themesh[1].vudataalloc(2*3*1024);
  
  zbuf.init();
  zbuf.bitsperpixel=32;
  zbuf.width=SAMPLEBUFX;
  zbuf.height=SAMPLEBUFY;
  zbuf.image=(int32*)malloc(SAMPLEBUFX*SAMPLEBUFY*4);
  myassert(zbuf.image);
  
  colbuf.init();
  colbuf.bitsperpixel=32;
  colbuf.width=SAMPLEBUFX;
  colbuf.height=SAMPLEBUFY;
  colbuf.image=(int32*)malloc(SAMPLEBUFX*SAMPLEBUFY*4);
  myassert(colbuf.image);
  
  themesh[0].removeFaceList();
  themesh[0].buildvudata();
  themesh[1].removeFaceList();
  themesh[1].buildvudata();

  fadeSpline.init();
  fadeSpline.addKeyValue(0,128);
  fadeSpline.addKeyValue(10*50,128);
  fadeSpline.addKeyValue(12*50,0);
}

void pixel_init2()
{
  tex1[0].allocclut();
  tex1[0].uploadclut();
  tex1[1].allocclut();
  tex1[1].uploadclut();
}

static int oldframes=-10;
void pixel_frame(float frames, texture *screen_, texture *tempscreen_, int iframe_, texture *background_)
{
  static bool tempObjectWasRenderedLastFrame;
  tempscreen=tempscreen_;
  screen=screen_;
  iframe=iframe_;
  background=background_;

  objectSelector=timing::getval(22)&1;

  localFrames[objectSelector]+=PAL?1:(5.0f/6);
  
  scalex=1+0.1*timing::get(1);

  {
    static float oldTime11; 
    if(timing::gettime(11)!=oldTime11 && timing::getval2(11)>0)
      {
	timingRotate+=timing::getval2(11);
      }
    oldTime11=timing::gettime(11);
  }

  zbuf.addr=tempscreen->addr+256*256+iframe*2*SAMPLEBUFX*SAMPLEBUFY*4;
  colbuf.addr=zbuf.addr+SAMPLEBUFX*SAMPLEBUFY*4;
  colbuf.zbufaddr=zbuf.addr;
  
  if(oldframes!=(((int)frames)-1))
    {
      tempObjectWasRenderedLastFrame=false;
    }
  
  if(tempObjectWasRenderedLastFrame)
    {
      colbuf.download();
      zbuf.download();
      
      // FlushCache(0);
    }
  else
    {
      //      printf("clearing: %x\n",zbuf.image);
      for(int t=0;t<SAMPLEBUFX*SAMPLEBUFY;t++)
	{	//  printf("clearing zbuf\n");
	  zbuf.image[t]=0;
	}
    }
  
  if(oldframes==(((int)frames)-1))
    {
      tempObjectWasRenderedLastFrame=true;
    }
  else
    {
      tempObjectWasRenderedLastFrame=false;
    }
  oldframes=(int)frames;
  
  return tunnel(localFrames[objectSelector]*8+5*200*sin(localFrames[objectSelector]/200));
}

void pixel_deinit()
{
}
