#include "overlay.h"
#include <kernel.h>
#include "matrix.h"
#include "gif.h"
#include "dma.h"
#include "myassert.h"
#include "math.h"
#include "spline.h"
#include "timing.h"

static int iframe_;

int overlay_maxcolor=256;

typedef struct point{
  float x,y;
  float u,v;
}point;

typedef struct quad{
  point p[4];
}quad;

static texture *source;

static float mod(float x, float m)
{
  int i=(int)((x/m)+100);
  return x-(i-100)*m;
}

static void renderLine(const point &A, const point &B)
{
  int c=64;

  //  int color=0x404040;

  c=overlay_maxcolor/4;

  int color =rgb (c,c,c);
  point a=A;
  point b=B;


  a.u/=1024;
  a.v/=512;
  b.u/=1024;
  b.v/=512;

  gif_env;

  int x,y,u,v;
	
  dma_begingp();
  gif_tag(0xe,1,0,0,0);
  
  gPRMODECONT(1);				// refer to prim attributes
  gCOLCLAMP(1);
  gDTHE(0);				// Dither off
  
  gCLAMP_1(0);
  gALPHA_1(0x8000000029);
  
  gTEX0_1((source->TEX0()));

  gTEX1_1(1<<5);				//bilinear
  gTEST_1(0x30000);
  
  gPRIM(PRIMline+0*PRIMtexture+0*PRIMuv+PRIMalpha);
  gPABE(0);
  gRGBAQ(0x3F80000080000000+color);		// Background RGBA
  
  x=65535&(int)(a.x*16+32000);
  y=65535&(int)(a.y*16/2+32000);
  u=4095&(int)(a.u);
  v=4095&(int)(a.v);
  //gUV(hhw(u,v));
  gST(wwd(*((int*)&a.u),*((int*)&a.v)));
  gXYZ2(hhw(x,y));
  //  gXYZ2(hhw(x,y));
  
  gRGBAQ(0x3F80000080000000+color);		// Background RGBA
  x=65535&(int)(b.x*16+32000);
  y=65535&(int)(b.y*16/2+32000);
  u=4095&(int)(b.u);
  v=4095&(int)(b.v);
  //gUV(hhw(u,v));
  gST(wwd(*((int*)&b.u),*((int*)&b.v)));
  gXYZ2(hhw(x,y));
  //  gXYZ2(hhw(x,y));

  gif_endfinal();
  dma_endgp();
}


static void renderTriangle(const point &A, const point &B, const point &C)
{
  int color=0x808080;

  point a=A;
  point b=B;
  point c=C;

  a.v+=iframe_;
  b.v+=iframe_;
  c.v+=iframe_;

  a.u/=1024;
  a.v/=512;
  b.u/=1024;
  b.v/=512;
  c.u/=1024;
  c.v/=512;

  gif_env;

  int x,y,u,v;
	
  dma_begingp();
  gif_tag(0xe,1,0,0,0);
  
  gPRMODECONT(1);				// refer to prim attributes
  gCOLCLAMP(1);
  gDTHE(0);				// Dither off
  
  gCLAMP_1(0);
  gALPHA_1(0x4000000044);
  
  gTEX0_1((source->TEX0()));

  //    gTEX0_1((source->TEX0())&0xfffffffc03ffffff||0x00000000cc000000);
  //      gCLAMP_1(0x3ff003fff);
  
  gTEX1_1(1<<5);				//bilinear
  gTEST_1(0x30000);
  
  gPRIM(PRIMtriangle+PRIMtexture+0*PRIMuv);
  gPABE(0);
  gRGBAQ(0x3F80000080000000+color);		// Background RGBA
  
  x=65535&(int)(a.x*16+32000);
  y=65535&(int)(a.y*16/2+32000);
  u=4095&(int)(a.u);
  v=4095&(int)(a.v);
  //gUV(hhw(u,v));
  gST(wwd(*((int*)&a.u),*((int*)&a.v)));
  gXYZ2(hhw(x,y));
  //  gXYZ2(hhw(x,y));
  
  gRGBAQ(0x3F80000080000000+color);		// Background RGBA
  x=65535&(int)(b.x*16+32000);
  y=65535&(int)(b.y*16/2+32000);
  u=4095&(int)(b.u);
  v=4095&(int)(b.v);
  //gUV(hhw(u,v));
  gST(wwd(*((int*)&b.u),*((int*)&b.v)));
  gXYZ2(hhw(x,y));
  //  gXYZ2(hhw(x,y));
  
  gRGBAQ(0x3F80000080000000+color);		// Background RGBA
  x=65535&(int)(c.x*16+32000);
  y=65535&(int)(c.y*16/2+32000);
  u=4095&(int)(c.u);
  v=4095&(int)(c.v);
  //  gUV(hhw(u,v));
  gST(wwd(*((int*)&c.u),*((int*)&c.v)));
  gXYZ2(hhw(x,y));

  gif_endfinal();
  dma_endgp();
}


static void renderQuad(const quad &q)
{
  renderTriangle(q.p[0],q.p[1],q.p[2]);
  renderTriangle(q.p[2],q.p[1],q.p[3]);
}

static quad transformQuad(const quad &q, const fmatrix &m, const fmatrix &mSource)
{
  quad ret;

  for(int t=0;t<4;t++)
    {
      ret.p[t].x=m.xu*q.p[t].x+m.xv*q.p[t].y+m.xx;
      ret.p[t].y=m.yu*q.p[t].x+m.yv*q.p[t].y+m.yy;
      ret.p[t].u=mSource.xu*q.p[t].u+mSource.xv*q.p[t].v+mSource.xx;
      ret.p[t].v=mSource.yu*q.p[t].u+mSource.yv*q.p[t].v+mSource.yy;
    }

  return ret;
}

static quad initialQuad()
{
  quad ret;
  ret.p[0].x=0;
  ret.p[0].y=0;
  ret.p[0].u=0;
  ret.p[0].v=0;

  ret.p[1].x=640;
  ret.p[1].y=0;
  ret.p[1].u=640;//640/16/16;
  ret.p[1].v=0;

  ret.p[2].x=0;
  ret.p[2].y=512;
  ret.p[2].u=0;
  ret.p[2].v=512;//512/16/16;

  ret.p[3].x=640;
  ret.p[3].y=512;
  ret.p[3].u=640;//640/16/16;
  ret.p[3].v=512;//512/16/16;

  return ret;
}


void overlay0(float frames)
{
  quad q=initialQuad();

  fmatrix m,M;

  resetmatrixf(&m);
  movematrixf(&m,-640*8,0,0);

  resetmatrixf(&M);
  rotatematrixzf(&M,frames*0.01);

  q=transformQuad(q,m,M);

  renderQuad(q);
}

void overlay1(float frames)
{
  quad q=initialQuad();

  fmatrix m,M;

  resetmatrixf(&m);
  movematrixf(&m,-640*8,-512*8,0);
  rotatematrixzf(&m,frames*0.01);
  movematrixf(&m,640*8,512*8,0);

  //  movematrixf(&m,-640*8,0,0);

  resetmatrixf(&M);
  //scalematrixf(&M,0,1,0);
  //  movematrixf(&M,-640*8,-512*8,0);
  rotatematrixzf(&M,frames*0.01);
  //  movematrixf(&M,640*8,512*8,0);


  q=transformQuad(q,m,M);

  renderQuad(q);
}



//------------------------------------------------
// Overlay 2
//------------------------------------------------

linearSpline overlay3YPos[5];

void overlay2Box(float yPos, float ySize, float vOffset)
{
  quad q=initialQuad();

  fmatrix m,M;

  resetmatrixf(&m);

  scalematrixf(&m,1,ySize/512,1);
  movematrixf(&m,0,yPos,0);

  resetmatrixf(&M);
  scalematrixf(&M,1,ySize/512,1);
  movematrixf(&M,0,yPos+vOffset,0);

  q=transformQuad(q,m,M);

  renderQuad(q);

  renderLine(q.p[0],q.p[1]);
  renderLine(q.p[2],q.p[3]);
}

void initOverlay2()
{
  printf("TESTTESTSTESTSETEST\n");
  for(int i=0;i<5;i++)
    overlay3YPos[i].init();

  overlay3YPos[0].addKeyValue(0,0);
  overlay3YPos[0].addKeyValue(10,400);
  overlay3YPos[0].addKeyValue(100,0);
  overlay3YPos[0].addKeyValue(1000,400);

  overlay3YPos[1].addKeyValue(0,0);
  overlay3YPos[1].addKeyValue(0,0);
  overlay3YPos[1].addKeyValue(0,0);
  overlay3YPos[1].addKeyValue(0,0);

  overlay3YPos[2].addKeyValue(0,0);
  overlay3YPos[2].addKeyValue(0,0);
  overlay3YPos[2].addKeyValue(0,0);
  overlay3YPos[2].addKeyValue(0,0);

  overlay3YPos[3].addKeyValue(0,0);
  overlay3YPos[3].addKeyValue(0,0);
  overlay3YPos[3].addKeyValue(0,0);
  overlay3YPos[3].addKeyValue(0,0);

  overlay3YPos[4].addKeyValue(0,0);
  overlay3YPos[4].addKeyValue(0,0);
  overlay3YPos[4].addKeyValue(0,0);
  overlay3YPos[4].addKeyValue(0,0);

  overlay3YPos[0].print();
}


void overlay2(float frames)
{
  for(int i=0;i<5;i++)
    overlay2Box(overlay3YPos[i].evaluate(frames),50+40*sin(i*1.3+8),-140*cos(i));
  //    overlay2Box(-100+mod(1560+1500*sin(0.02*frames*(0.02+i*0.002)+i*i*0.7),600),50+40*sin(i*1.3+8),-140*cos(i));
  //    overlay2Box(156+150*sin(frames*(0.02+i*0.002)+i),50+40*sin(i*1.3+8),-40*cos(i));
}



//------------------------------------------------
// Overlay 3
//------------------------------------------------

void overlay3(float frames)
{
  unsigned long int next=1;

  for(int i=0;i<640;i+=128)
    for(int j=0;j<512;j+=128)
      {
	quad q=initialQuad();
	
	fmatrix m,M;
	int temp;
	
	resetmatrixf(&m);
	
	scalematrixf(&m,128.0f/640,128.0f/512,1);
	temp=next;
	next=next*1103515245+12345;
	movematrixf(&m,i+(next&63),j+(temp&63),0);
	next=next*1103515245+12345;

	resetmatrixf(&M);
	scalematrixf(&M,128.0f/640,128.0f/512,1);

	temp=next;
	next=next*1103515245+12345;
	movematrixf(&M,i+(next&63),j+(temp&63),0);
	next=next*1103515245+12345;
  

	q=transformQuad(q,m,M);
	
	renderQuad(q);
      }
}


void overlay4Box(float ystart, float ystop, float offset)
{
  overlay2Box((ystart),ystop-ystart,offset);
}

void overlay4(float frames)
{
  int num=0;

  static int n;

  {
    static float oldTime11; 
    if(timing::gettime(11)!=oldTime11 && timing::getval2(11)>0)
      {
	n++;
      }
    oldTime11=timing::gettime(11);
  }

  num=n;//>>8;

  switch(num%14)
    {
    case 0:
      overlay4Box(98, 316, 30);
      overlay4Box(484, 512, -30);
      break;
    case 1:
      overlay4Box(56, 195, 30);
      overlay4Box(455, 512, -30);
      break;
    case 2:
      overlay4Box(289, 344, 30);
      overlay4Box(316, 457, -30);
      break;
    case 3:
      overlay4Box(28, 414, 30);
      break;
    case 4:
      overlay4Box(28, 386, 30);
      overlay4Box(484, 512, -30);
      {
	static int y;
	y+=4;
	y&=255;
	float y2=y;
	//	if(y>256)y2=512-y;
	for(int i=0;i<5;i++)
	  overlay4Box(28+y2+10*i, 38+y2+10*i, 30-10*i);
      }
      break;
    case 5:
      overlay4Box(195, 484, -30);
      break;
    case 6:
      overlay4Box(0, 28, 30);
      overlay4Box(288, 414, 30);
      break;
    case 7:
      overlay4Box(0, 195, 30);
      break;
    case 8:
      overlay4Box(0, 98, 30);
      overlay4Box(316, 512, -30);
      break;
    case 9:
      overlay4Box(0, 98, 30);
      overlay4Box(386, 444, 30);
      break;
    case 10:
      overlay4Box(0, 316, 30);
      break;
    case 11:
      overlay4Box(0, 98, 30);
      overlay4Box(316, 512, -30);
      break;
    case 12:
      overlay4Box(0, 84, 30);
      overlay4Box(154, 251, 30);
      break;
    case 13:
      overlay4Box(28, 414, 30);
      break;
    
    }
}




void renderOverlay(float frames, texture *screen, texture *tempscreen, int iframe, unsigned int overlaynum)
{
  iframe_=iframe;

  source=tempscreen;

  tempscreen->dmalistframe1(0*iframe);

  screen->box(0,0,640*16,512*16,0x80808080);
  
  screen->dmalistframe1(iframe);
  //  tempscreen->box(0,0,320*16,512*16,0x80808080);

  switch(overlaynum%5)
    {
    case 0:
      overlay0(frames);
      break;
    case 1:
      overlay1(frames);
      break; 
    case 2:
      overlay2(frames);
      break; 
    case 3:
      overlay3(frames);
      break;
    case 4:
      overlay4(frames);
      break;
    default:
      myassert(0);
    }
}


void initOverlay()
{
  initOverlay2();
}
